/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class SparseBloomFilter
implements BloomFilter {
    private final TreeSet<Integer> indices;
    private final Shape shape;

    public SparseBloomFilter(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        this.shape = shape;
        this.indices = new TreeSet();
    }

    private SparseBloomFilter(SparseBloomFilter source) {
        this.shape = source.shape;
        this.indices = new TreeSet<Integer>((SortedSet<Integer>)source.indices);
    }

    private boolean add(int idx) {
        this.indices.add(idx);
        return true;
    }

    @Override
    public long[] asBitMapArray() {
        long[] result = new long[BitMap.numberOfBitMaps(this.shape.getNumberOfBits())];
        for (int i : this.indices) {
            BitMap.set(result, i);
        }
        return result;
    }

    @Override
    public int cardinality() {
        return this.indices.size();
    }

    @Override
    public int characteristics() {
        return 1;
    }

    @Override
    public void clear() {
        this.indices.clear();
    }

    @Override
    public boolean contains(BitMapProducer bitMapProducer) {
        return this.contains(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    @Override
    public boolean contains(IndexProducer indexProducer) {
        return indexProducer.forEachIndex(this.indices::contains);
    }

    @Override
    public SparseBloomFilter copy() {
        return new SparseBloomFilter(this);
    }

    @Override
    public boolean forEachBitMap(LongPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        int limit = BitMap.numberOfBitMaps(this.shape.getNumberOfBits());
        long bitMap = 0L;
        int idx = 0;
        for (int i : this.indices) {
            while (BitMap.getLongIndex(i) != idx) {
                if (!consumer.test(bitMap)) {
                    return false;
                }
                bitMap = 0L;
                ++idx;
            }
            bitMap |= BitMap.getLongBit(i);
        }
        if (!consumer.test(bitMap)) {
            return false;
        }
        ++idx;
        while (idx < limit) {
            if (!consumer.test(0L)) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    @Override
    public boolean forEachIndex(IntPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        for (int value : this.indices) {
            if (consumer.test(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isEmpty() {
        return this.indices.isEmpty();
    }

    @Override
    public boolean merge(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        return this.merge(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    @Override
    public boolean merge(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        IndexProducer producer = (other.characteristics() & 1) != 0 ? other : IndexProducer.fromBitMapProducer(other);
        this.merge(producer);
        return true;
    }

    @Override
    public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        this.merge(hasher.indices(this.shape));
        return true;
    }

    @Override
    public boolean merge(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        indexProducer.forEachIndex(this::add);
        if (!this.indices.isEmpty()) {
            if (this.indices.last() >= this.shape.getNumberOfBits()) {
                throw new IllegalArgumentException(String.format("Value in list %s is greater than maximum value (%s)", this.indices.last(), this.shape.getNumberOfBits() - 1));
            }
            if (this.indices.first() < 0) {
                throw new IllegalArgumentException(String.format("Value in list %s is less than 0", this.indices.first()));
            }
        }
        return true;
    }
}

