/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CountingPredicate;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;

public interface BloomFilterProducer {
    public static BloomFilterProducer fromBloomFilterArray(final BloomFilter ... filters) {
        Objects.requireNonNull(filters, "filters");
        return new BloomFilterProducer(){

            @Override
            public BloomFilter[] asBloomFilterArray() {
                return (BloomFilter[])filters.clone();
            }

            @Override
            public boolean forEachBloomFilter(Predicate<BloomFilter> predicate) {
                for (BloomFilter filter : filters) {
                    if (predicate.test(filter)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean forEachBloomFilterPair(BloomFilterProducer other, BiPredicate<BloomFilter, BloomFilter> func) {
                CountingPredicate<BloomFilter> p = new CountingPredicate<BloomFilter>(filters, func);
                return other.forEachBloomFilter(p) && p.forEachRemaining();
            }
        };
    }

    default public BloomFilter[] asBloomFilterArray() {
        ArrayList filters = new ArrayList();
        this.forEachBloomFilter(f -> filters.add(f.copy()));
        return filters.toArray(new BloomFilter[0]);
    }

    default public BloomFilter flatten() {
        BloomFilter[] bf = new BloomFilter[]{null};
        this.forEachBloomFilter(x -> {
            if (bf[0] == null) {
                bf[0] = new SimpleBloomFilter(x.getShape());
            }
            return bf[0].merge((BloomFilter)x);
        });
        return bf[0];
    }

    public boolean forEachBloomFilter(Predicate<BloomFilter> var1);

    default public boolean forEachBloomFilterPair(BloomFilterProducer other, BiPredicate<BloomFilter, BloomFilter> func) {
        CountingPredicate<BloomFilter> p = new CountingPredicate<BloomFilter>(this.asBloomFilterArray(), func);
        return other.forEachBloomFilter(p) && p.forEachRemaining();
    }
}

