/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;

public interface BloomFilter
extends IndexProducer,
BitMapProducer {
    public static final int SPARSE = 1;

    public int cardinality();

    public int characteristics();

    public void clear();

    default public boolean contains(BitMapProducer bitMapProducer) {
        return this.forEachBitMapPair(bitMapProducer, (x, y) -> (x & y) == y);
    }

    default public boolean contains(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return (this.characteristics() & 1) != 0 ? this.contains((IndexProducer)other) : this.contains((BitMapProducer)other);
    }

    default public boolean contains(Hasher hasher) {
        Objects.requireNonNull(hasher, "Hasher");
        Shape shape = this.getShape();
        return this.contains(hasher.indices(shape));
    }

    public boolean contains(IndexProducer var1);

    public BloomFilter copy();

    default public int estimateIntersection(BloomFilter other) {
        long estimate;
        Objects.requireNonNull(other, "other");
        double eThis = this.getShape().estimateN(this.cardinality());
        double eOther = this.getShape().estimateN(other.cardinality());
        if (Double.isInfinite(eThis) && Double.isInfinite(eOther)) {
            return Integer.MAX_VALUE;
        }
        if (Double.isInfinite(eThis)) {
            estimate = Math.round(eOther);
        } else if (Double.isInfinite(eOther)) {
            estimate = Math.round(eThis);
        } else {
            BloomFilter union = this.copy();
            union.merge(other);
            double eUnion = this.getShape().estimateN(union.cardinality());
            if (Double.isInfinite(eUnion)) {
                throw new IllegalArgumentException("The estimated N for the union of the filters is infinite");
            }
            estimate = Math.round(eThis + eOther - eUnion);
            estimate = estimate < 0L ? 0L : estimate;
        }
        return estimate > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)estimate;
    }

    default public int estimateN() {
        double d = this.getShape().estimateN(this.cardinality());
        if (Double.isInfinite(d)) {
            return Integer.MAX_VALUE;
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cardinality too large: " + this.cardinality());
        }
        long l = Math.round(d);
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    default public int estimateUnion(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        BloomFilter cpy = this.copy();
        cpy.merge(other);
        return cpy.estimateN();
    }

    public Shape getShape();

    default public boolean isEmpty() {
        return this.forEachBitMap(y -> y == 0L);
    }

    default public boolean isFull() {
        return this.cardinality() == this.getShape().getNumberOfBits();
    }

    public boolean merge(BitMapProducer var1);

    default public boolean merge(BloomFilter other) {
        return (this.characteristics() & 1) != 0 ? this.merge((IndexProducer)other) : this.merge((BitMapProducer)other);
    }

    default public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.getShape()));
    }

    public boolean merge(IndexProducer var1);

    @Override
    default public IndexProducer uniqueIndices() {
        return this;
    }
}

