/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.TransformedSet;

public class TransformedSetTest<E>
extends AbstractSetTest<E> {
    public TransformedSetTest(String testName) {
        super(testName);
    }

    @Override
    public Set<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Set<E> makeConfirmedFullCollection() {
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public Set<E> makeObject() {
        return TransformedSet.transformingSet(new HashSet(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public Set<E> makeFullCollection() {
        HashSet list = new HashSet();
        list.addAll(Arrays.asList(this.getFullElements()));
        return TransformedSet.transformingSet(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedSet() {
        TransformedSet set = TransformedSet.transformingSet(new HashSet(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSetTest.assertEquals((int)0, (int)set.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            set.add(els[i]);
            TransformedSetTest.assertEquals((int)(i + 1), (int)set.size());
            TransformedSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)els[i])));
            TransformedSetTest.assertEquals((boolean)false, (boolean)set.contains(els[i]));
        }
        TransformedSetTest.assertEquals((boolean)false, (boolean)set.remove(els[0]));
        TransformedSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    public void testTransformedSet_decorateTransform() {
        HashSet originalSet = new HashSet();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalSet, els);
        Set set = TransformedSet.transformedSet(originalSet, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSetTest.assertEquals((int)els.length, (int)set.size());
        for (Object el : els) {
            TransformedSetTest.assertEquals((boolean)true, (boolean)set.contains(Integer.valueOf((String)el)));
            TransformedSetTest.assertEquals((boolean)false, (boolean)set.contains(el));
        }
        TransformedSetTest.assertEquals((boolean)false, (boolean)set.remove(els[0]));
        TransformedSetTest.assertEquals((boolean)true, (boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

