/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.TransformedQueue;

public class TransformedQueueTest<E>
extends AbstractQueueTest<E> {
    public TransformedQueueTest(String testName) {
        super(testName);
    }

    @Override
    public Queue<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Queue<E> makeConfirmedFullCollection() {
        LinkedList list = new LinkedList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public Queue<E> makeObject() {
        return TransformedQueue.transformingQueue(new LinkedList(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList list = new LinkedList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return TransformedQueue.transformingQueue(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    public void testTransformedQueue() {
        TransformedQueue queue = TransformedQueue.transformingQueue(new LinkedList(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedQueueTest.assertEquals((int)0, (int)queue.size());
        Object[] elements = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < elements.length; ++i) {
            queue.add(elements[i]);
            TransformedQueueTest.assertEquals((int)(i + 1), (int)queue.size());
            TransformedQueueTest.assertEquals((boolean)true, (boolean)queue.contains(Integer.valueOf((String)elements[i])));
            TransformedQueueTest.assertEquals((boolean)false, (boolean)queue.contains(elements[i]));
        }
        TransformedQueueTest.assertEquals((boolean)false, (boolean)queue.remove(elements[0]));
        TransformedQueueTest.assertEquals((boolean)true, (boolean)queue.remove(Integer.valueOf((String)elements[0])));
    }

    public void testTransformedQueue_decorateTransform() {
        LinkedList originalQueue = new LinkedList();
        Object[] elements = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalQueue, elements);
        TransformedQueue queue = TransformedQueue.transformedQueue(originalQueue, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedQueueTest.assertEquals((int)elements.length, (int)queue.size());
        for (Object el : elements) {
            TransformedQueueTest.assertEquals((boolean)true, (boolean)queue.contains(Integer.valueOf((String)el)));
            TransformedQueueTest.assertEquals((boolean)false, (boolean)queue.contains(el));
        }
        TransformedQueueTest.assertEquals((boolean)false, (boolean)queue.remove(elements[0]));
        TransformedQueueTest.assertEquals((boolean)true, (boolean)queue.remove(Integer.valueOf((String)elements[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

