/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.properties;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.collections4.properties.AbstractPropertiesFactory;
import org.apache.commons.collections4.properties.PropertiesFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractPropertiesFactoryTest<T extends Properties> {
    private static final String PATH_STRING = "src/test/resources/properties/test.properties";
    private final AbstractPropertiesFactory<T> factory;

    protected AbstractPropertiesFactoryTest(AbstractPropertiesFactory<T> factory) {
        this.factory = factory;
    }

    private void assertContents(T properties) {
        Assert.assertEquals((Object)"value1", (Object)((Properties)properties).getProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)((Properties)properties).getProperty("key2"));
    }

    @Test
    public void testInstance() {
        Assert.assertNotNull((Object)PropertiesFactory.INSTANCE);
    }

    @Test
    public void testLoadClassLoaderMissingResource() throws Exception {
        Assert.assertNull((Object)this.factory.load(ClassLoader.getSystemClassLoader(), "missing/test.properties"));
    }

    @Test
    public void testLoadClassLoaderResource() throws Exception {
        this.assertContents(this.factory.load(ClassLoader.getSystemClassLoader(), "properties/test.properties"));
    }

    @Test
    public void testLoadFile() throws Exception {
        this.assertContents(this.factory.load(Paths.get(PATH_STRING, new String[0]).toFile()));
    }

    @Test
    public void testLoadFileName() throws Exception {
        this.assertContents(this.factory.load(PATH_STRING));
    }

    @Test
    public void testLoadInputStream() throws Exception {
        try (FileInputStream inputStream = new FileInputStream(PATH_STRING);){
            this.assertContents(this.factory.load((InputStream)inputStream));
        }
    }

    @Test
    public void testLoadPath() throws Exception {
        this.assertContents(this.factory.load(Paths.get(PATH_STRING, new String[0])));
    }

    @Test
    public void testLoadReader() throws Exception {
        try (BufferedReader inputStream = Files.newBufferedReader(Paths.get(PATH_STRING, new String[0]));){
            this.assertContents(this.factory.load((Reader)inputStream));
        }
    }

    @Test
    public void testLoadUri() throws Exception {
        this.assertContents(this.factory.load(Paths.get(PATH_STRING, new String[0]).toUri()));
    }

    @Test
    public void testLoadUrl() throws Exception {
        this.assertContents(this.factory.load(Paths.get(PATH_STRING, new String[0]).toUri().toURL()));
    }
}

