/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.IdentityMap;
import org.apache.commons.collections4.map.ReferenceIdentityMap;

public class ReferenceIdentityMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Integer I1A = new Integer(1);
    private static final Integer I1B = new Integer(1);
    private static final Integer I2A = new Integer(2);
    private static final Integer I2B = new Integer(2);
    WeakReference<K> keyReference;
    WeakReference<V> valueReference;

    public ReferenceIdentityMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ReferenceIdentityMapTest.class);
    }

    @Override
    public ReferenceIdentityMap<K, V> makeObject() {
        return new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    }

    @Override
    public Map<K, V> makeConfirmedMap() {
        return new IdentityMap();
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testBasics() {
        ReferenceIdentityMap map = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD);
        ReferenceIdentityMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)I1A, (Object)I2A);
        ReferenceIdentityMapTest.assertEquals((int)1, (int)map.size());
        ReferenceIdentityMapTest.assertSame((Object)I2A, (Object)map.get((Object)I1A));
        ReferenceIdentityMapTest.assertSame(null, (Object)map.get((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1A));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)map.containsKey((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)I2A));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)I2B));
        map.put((Object)I1A, (Object)I2B);
        ReferenceIdentityMapTest.assertEquals((int)1, (int)map.size());
        ReferenceIdentityMapTest.assertSame((Object)I2B, (Object)map.get((Object)I1A));
        ReferenceIdentityMapTest.assertSame(null, (Object)map.get((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1A));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)map.containsKey((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)I2A));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)I2B));
        map.put((Object)I1B, (Object)I2B);
        ReferenceIdentityMapTest.assertEquals((int)2, (int)map.size());
        ReferenceIdentityMapTest.assertSame((Object)I2B, (Object)map.get((Object)I1A));
        ReferenceIdentityMapTest.assertSame((Object)I2B, (Object)map.get((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1A));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1B));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)map.containsValue((Object)I2A));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)map.containsValue((Object)I2B));
    }

    public void testHashEntry() {
        ReferenceIdentityMap map = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD);
        map.put((Object)I1A, (Object)I2A);
        map.put((Object)I1B, (Object)I2A);
        Map.Entry entry1 = (Map.Entry)map.entrySet().iterator().next();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry2 = (Map.Entry)it.next();
        Map.Entry entry3 = (Map.Entry)it.next();
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)entry1.equals(entry2));
        ReferenceIdentityMapTest.assertEquals((boolean)true, (boolean)entry2.equals(entry1));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)entry1.equals(entry3));
    }

    public void testNullHandling() {
        this.resetFull();
        ReferenceIdentityMapTest.assertEquals(null, (Object)this.getMap().get(null));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)this.getMap().containsKey(null));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)this.getMap().containsValue(null));
        ReferenceIdentityMapTest.assertEquals(null, (Object)this.getMap().remove(null));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)this.getMap().entrySet().contains(null));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)this.getMap().keySet().contains(null));
        ReferenceIdentityMapTest.assertEquals((boolean)false, (boolean)this.getMap().values().contains(null));
        try {
            this.getMap().put(null, null);
            ReferenceIdentityMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.getMap().put(new Object(), null);
            ReferenceIdentityMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.getMap().put(null, new Object());
            ReferenceIdentityMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Map<K, V> buildRefMap() {
        Object key = new Object();
        Object value = new Object();
        this.keyReference = new WeakReference<Object>(key);
        this.valueReference = new WeakReference<Object>(value);
        ReferenceIdentityMap testMap = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, true);
        testMap.put(key, value);
        ReferenceIdentityMapTest.assertEquals((String)"In map", (Object)value, testMap.get(key));
        ReferenceIdentityMapTest.assertNotNull((String)"Weak reference released early (1)", this.keyReference.get());
        ReferenceIdentityMapTest.assertNotNull((String)"Weak reference released early (2)", this.valueReference.get());
        return testMap;
    }

    public void testPurgeValues() throws Exception {
        Map<K, V> testMap = this.buildRefMap();
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                ReferenceIdentityMapTest.fail((String)"Max iterations reached before resource released.");
            }
            testMap.isEmpty();
            if (this.keyReference.get() == null && this.valueReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    private static void gc() {
        try {
            byte[][] tooLarge = new byte[1000000000][1000000000];
            ReferenceIdentityMapTest.fail((String)"you have too much RAM");
        }
        catch (OutOfMemoryError ex) {
            System.gc();
        }
    }
}

