/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ListIteratorWrapper;

public class ListIteratorWrapperTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<E> list1 = null;

    public ListIteratorWrapperTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.list1 = new ArrayList();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list1.add("Four");
        this.list1.add("Five");
        this.list1.add("Six");
    }

    @Override
    public ResettableListIterator<E> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new ListIteratorWrapper(list.iterator());
    }

    @Override
    public ResettableListIterator<E> makeObject() {
        return new ListIteratorWrapper(this.list1.iterator());
    }

    public void testIterator() {
        Object iterValue;
        ResettableListIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            ListIteratorWrapperTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ListIteratorWrapperTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            ListIteratorWrapperTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
        for (int i = this.testArray.length - 1; i > -1; --i) {
            String testValue = this.testArray[i];
            Object iterValue2 = iter.previous();
            ListIteratorWrapperTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue2);
        }
        try {
            iter.previous();
        }
        catch (Exception e) {
            ListIteratorWrapperTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
        for (String testValue : this.testArray) {
            iterValue = iter.next();
            ListIteratorWrapperTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
    }

    @Override
    public void testRemove() {
        ResettableListIterator<E> iter = this.makeObject();
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        try {
            iter.remove();
            ListIteratorWrapperTest.fail((String)"ListIteratorWrapper#remove() should fail; must be initially positioned first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        int sz = this.list1.size();
        ListIteratorWrapperTest.assertEquals(this.list1.get(0), iter.next());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapperTest.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        try {
            iter.remove();
            ListIteratorWrapperTest.fail((String)"ListIteratorWrapper#remove() should fail; must be repositioned first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(0), iter.next());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(1), iter.next());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)2, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(1), iter.previous());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapperTest.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(0), iter.previous());
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        try {
            iter.remove();
            ListIteratorWrapperTest.fail((String)"ListIteratorWrapper does not support the remove() method while dug into the cache via previous()");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIteratorWrapperTest.assertEquals((int)-1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(0), iter.next());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(1), iter.next());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)2, (int)iter.nextIndex());
        iter.remove();
        ListIteratorWrapperTest.assertEquals((int)(--sz), (int)this.list1.size());
        ListIteratorWrapperTest.assertEquals((int)0, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.nextIndex());
        ListIteratorWrapperTest.assertEquals(this.list1.get(1), iter.next());
        ListIteratorWrapperTest.assertEquals((int)1, (int)iter.previousIndex());
        ListIteratorWrapperTest.assertEquals((int)2, (int)iter.nextIndex());
    }

    public void testReset() {
        ResettableListIterator<E> iter = this.makeObject();
        Object first = iter.next();
        Object second = iter.next();
        iter.reset();
        ListIteratorWrapperTest.assertFalse((String)"No previous elements after reset()", (boolean)iter.hasPrevious());
        ListIteratorWrapperTest.assertEquals((String)"First element should be the same", (Object)first, (Object)iter.next());
        ListIteratorWrapperTest.assertEquals((String)"Second elment should be the same", (Object)second, (Object)iter.next());
        for (int i = 2; i < this.testArray.length; ++i) {
            String testValue = this.testArray[i];
            Object iterValue = iter.next();
            ListIteratorWrapperTest.assertEquals((String)"Iteration value is correct", (Object)testValue, (Object)iterValue);
        }
    }
}

