/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.FixedOrderComparator;
import org.junit.Test;

public class FixedOrderComparatorTest
extends AbstractComparatorTest<String> {
    private static final String[] topCities = new String[]{"Tokyo", "Mexico City", "Mumbai", "Sao Paulo", "New York", "Shanghai", "Lagos", "Los Angeles", "Calcutta", "Buenos Aires"};

    public FixedOrderComparatorTest(String name) {
        super(name);
    }

    @Override
    public Comparator<String> makeObject() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        return comparator;
    }

    @Override
    public List<String> getComparableObjectsOrdered() {
        return Arrays.asList(topCities);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Test
    public void testConstructorPlusAdd() {
        FixedOrderComparator comparator = new FixedOrderComparator();
        for (String topCitie : topCities) {
            comparator.add((Object)topCitie);
        }
        String[] keys = (String[])topCities.clone();
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testArrayConstructor() {
        String[] keys = (String[])topCities.clone();
        Object[] topCitiesForTest = (String[])topCities.clone();
        FixedOrderComparator comparator = new FixedOrderComparator(topCitiesForTest);
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
        topCitiesForTest[0] = "Brighton";
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testListConstructor() {
        String[] keys = (String[])topCities.clone();
        LinkedList<String> topCitiesForTest = new LinkedList<String>(Arrays.asList(topCities));
        FixedOrderComparator comparator = new FixedOrderComparator(topCitiesForTest);
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
        topCitiesForTest.set(0, "Brighton");
        this.assertComparatorYieldsOrder(keys, (Comparator<String>)comparator);
    }

    @Test
    public void testAddAsEqual() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        comparator.addAsEqual((Object)"New York", (Object)"Minneapolis");
        FixedOrderComparatorTest.assertEquals((int)0, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        FixedOrderComparatorTest.assertEquals((int)-1, (int)comparator.compare((Object)"Tokyo", (Object)"Minneapolis"));
        FixedOrderComparatorTest.assertEquals((int)1, (int)comparator.compare((Object)"Shanghai", (Object)"Minneapolis"));
    }

    @Test
    public void testLock() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        FixedOrderComparatorTest.assertEquals((boolean)false, (boolean)comparator.isLocked());
        comparator.compare((Object)"New York", (Object)"Tokyo");
        FixedOrderComparatorTest.assertEquals((boolean)true, (boolean)comparator.isLocked());
        try {
            comparator.add((Object)"Minneapolis");
            FixedOrderComparatorTest.fail((String)"Should have thrown an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            comparator.addAsEqual((Object)"New York", (Object)"Minneapolis");
            FixedOrderComparatorTest.fail((String)"Should have thrown an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownObjectBehavior() {
        FixedOrderComparator comparator = new FixedOrderComparator((Object[])topCities);
        try {
            comparator.compare((Object)"New York", (Object)"Minneapolis");
            FixedOrderComparatorTest.fail((String)"Should have thrown a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            comparator.compare((Object)"Minneapolis", (Object)"New York");
            FixedOrderComparatorTest.fail((String)"Should have thrown a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FixedOrderComparatorTest.assertEquals((Object)FixedOrderComparator.UnknownObjectBehavior.EXCEPTION, (Object)comparator.getUnknownObjectBehavior());
        comparator = new FixedOrderComparator((Object[])topCities);
        comparator.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.BEFORE);
        FixedOrderComparatorTest.assertEquals((Object)FixedOrderComparator.UnknownObjectBehavior.BEFORE, (Object)comparator.getUnknownObjectBehavior());
        LinkedList<String> keys = new LinkedList<String>(Arrays.asList(topCities));
        keys.addFirst("Minneapolis");
        this.assertComparatorYieldsOrder(keys.toArray(new String[0]), (Comparator<String>)comparator);
        FixedOrderComparatorTest.assertEquals((int)-1, (int)comparator.compare((Object)"Minneapolis", (Object)"New York"));
        FixedOrderComparatorTest.assertEquals((int)1, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        FixedOrderComparatorTest.assertEquals((int)0, (int)comparator.compare((Object)"Minneapolis", (Object)"St Paul"));
        comparator = new FixedOrderComparator((Object[])topCities);
        comparator.setUnknownObjectBehavior(FixedOrderComparator.UnknownObjectBehavior.AFTER);
        keys = new LinkedList<String>(Arrays.asList(topCities));
        keys.add("Minneapolis");
        this.assertComparatorYieldsOrder(keys.toArray(new String[0]), (Comparator<String>)comparator);
        FixedOrderComparatorTest.assertEquals((int)1, (int)comparator.compare((Object)"Minneapolis", (Object)"New York"));
        FixedOrderComparatorTest.assertEquals((int)-1, (int)comparator.compare((Object)"New York", (Object)"Minneapolis"));
        FixedOrderComparatorTest.assertEquals((int)0, (int)comparator.compare((Object)"Minneapolis", (Object)"St Paul"));
    }

    private void assertComparatorYieldsOrder(String[] orderedObjects, Comparator<String> comparator) {
        int i;
        String[] keys = (String[])orderedObjects.clone();
        boolean isInNewOrder = false;
        Random rand = new Random();
        while (keys.length > 1 && !isInNewOrder) {
            for (i = keys.length - 1; i > 0; --i) {
                String swap = keys[i];
                int j = rand.nextInt(i + 1);
                keys[i] = keys[j];
                keys[j] = swap;
            }
            for (i = 0; i < keys.length && !isInNewOrder; ++i) {
                if (orderedObjects[i].equals(keys[i])) continue;
                isInNewOrder = true;
            }
        }
        Arrays.sort(keys, comparator);
        for (i = 0; i < orderedObjects.length; ++i) {
            FixedOrderComparatorTest.assertEquals((String)orderedObjects[i], (String)keys[i]);
        }
    }
}

