/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.set.PredicatedSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SetUtilsTest {
    private Set<Integer> setA;
    private Set<Integer> setB;

    @Test
    public void difference() {
        SetUtils.SetView set = SetUtils.difference(this.setA, this.setB);
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertTrue((boolean)set.contains((Object)1));
        Assert.assertTrue((boolean)set.contains((Object)2));
        for (Integer i : this.setB) {
            Assert.assertFalse((boolean)set.contains((Object)i));
        }
        SetUtils.SetView set2 = SetUtils.difference(this.setA, (Set)SetUtils.emptySet());
        Assert.assertEquals(this.setA, (Object)set2);
        try {
            SetUtils.difference(this.setA, null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SetUtils.difference(null, this.setA);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void disjunction() {
        SetUtils.SetView set = SetUtils.disjunction(this.setA, this.setB);
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains((Object)1));
        Assert.assertTrue((boolean)set.contains((Object)2));
        Assert.assertTrue((boolean)set.contains((Object)6));
        Assert.assertTrue((boolean)set.contains((Object)7));
        Assert.assertFalse((boolean)set.contains((Object)3));
        Assert.assertFalse((boolean)set.contains((Object)4));
        Assert.assertFalse((boolean)set.contains((Object)5));
        SetUtils.SetView set2 = SetUtils.disjunction(this.setA, (Set)SetUtils.emptySet());
        Assert.assertEquals(this.setA, (Object)set2);
        try {
            SetUtils.disjunction(this.setA, null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SetUtils.disjunction(null, this.setA);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void intersection() {
        SetUtils.SetView set = SetUtils.intersection(this.setA, this.setB);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains((Object)3));
        Assert.assertTrue((boolean)set.contains((Object)4));
        Assert.assertTrue((boolean)set.contains((Object)5));
        Assert.assertFalse((boolean)set.contains((Object)1));
        Assert.assertFalse((boolean)set.contains((Object)2));
        Assert.assertFalse((boolean)set.contains((Object)6));
        Assert.assertFalse((boolean)set.contains((Object)7));
        SetUtils.SetView set2 = SetUtils.intersection(this.setA, (Set)SetUtils.emptySet());
        Assert.assertEquals((Object)SetUtils.emptySet(), (Object)set2);
        try {
            SetUtils.intersection(this.setA, null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SetUtils.intersection(null, this.setA);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Before
    public void setUp() {
        this.setA = new HashSet<Integer>();
        this.setA.add(1);
        this.setA.add(2);
        this.setA.add(3);
        this.setA.add(4);
        this.setA.add(5);
        this.setB = new HashSet<Integer>();
        this.setB.add(3);
        this.setB.add(4);
        this.setB.add(5);
        this.setB.add(6);
        this.setB.add(7);
    }

    @Test
    public void testEmptyIfNull() {
        Assert.assertTrue((boolean)SetUtils.emptyIfNull(null).isEmpty());
        HashSet set = new HashSet();
        Assert.assertSame(set, (Object)SetUtils.emptyIfNull(set));
    }

    @Test
    public void testEquals() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        Assert.assertEquals((Object)true, (Object)a.equals(b));
        Assert.assertEquals((Object)true, (Object)SetUtils.isEqualSet(a, b));
        a.clear();
        Assert.assertEquals((Object)false, (Object)SetUtils.isEqualSet(a, b));
        Assert.assertEquals((Object)false, (Object)SetUtils.isEqualSet(a, null));
        Assert.assertEquals((Object)false, (Object)SetUtils.isEqualSet(null, b));
        Assert.assertEquals((Object)true, (Object)SetUtils.isEqualSet(null, null));
    }

    @Test
    public void testHashCode() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        Assert.assertEquals((Object)true, (Object)(a.hashCode() == b.hashCode() ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(a.hashCode() == SetUtils.hashCodeForSet(a) ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(b.hashCode() == SetUtils.hashCodeForSet(b) ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(SetUtils.hashCodeForSet(a) == SetUtils.hashCodeForSet(b) ? 1 : 0));
        a.clear();
        Assert.assertEquals((Object)false, (Object)(SetUtils.hashCodeForSet(a) == SetUtils.hashCodeForSet(b) ? 1 : 0));
        Assert.assertEquals((long)0L, (long)SetUtils.hashCodeForSet(null));
    }

    @Test
    public void testHashSet() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Object[0]);
        Assert.assertTrue((String)"set is empty", (boolean)set1.isEmpty());
        HashSet set2 = SetUtils.hashSet((Object[])new Integer[]{1, 2, 2, 3});
        Assert.assertEquals((String)"set has 3 elements", (long)3L, (long)set2.size());
        Assert.assertTrue((String)"set contains 1", (boolean)set2.contains(1));
        Assert.assertTrue((String)"set contains 2", (boolean)set2.contains(2));
        Assert.assertTrue((String)"set contains 3", (boolean)set2.contains(3));
        HashSet set3 = SetUtils.hashSet((Object[])new String[]{"1", "2", "2", "3"});
        Assert.assertEquals((String)"set has 3 elements", (long)3L, (long)set3.size());
        Assert.assertTrue((String)"set contains 1", (boolean)set3.contains("1"));
        Assert.assertTrue((String)"set contains 2", (boolean)set3.contains("2"));
        Assert.assertTrue((String)"set contains 3", (boolean)set3.contains("3"));
        HashSet set4 = SetUtils.hashSet((Object[])new Object[]{null, null});
        Assert.assertEquals((String)"set has 1 element", (long)1L, (long)set4.size());
        Assert.assertTrue((String)"set contains null", (boolean)set4.contains(null));
        HashSet set5 = SetUtils.hashSet((Object[])null);
        Assert.assertEquals((String)"set is null", null, (Object)set5);
    }

    @Test
    public void testNewIdentityHashSet() {
        Set set = SetUtils.newIdentityHashSet();
        String a = new String("a");
        set.add(a);
        set.add(new String("b"));
        set.add(a);
        Assert.assertEquals((long)2L, (long)set.size());
        set.add(new String("a"));
        Assert.assertEquals((long)3L, (long)set.size());
        set.remove(a);
        Assert.assertEquals((long)2L, (long)set.size());
    }

    @Test
    public void testpredicatedSet() {
        Predicate<Object> predicate = new Predicate<Object>(){

            public boolean evaluate(Object o) {
                return o instanceof String;
            }
        };
        Set set = SetUtils.predicatedSet(new HashSet(), (Predicate)predicate);
        Assert.assertTrue((String)"returned object should be a PredicatedSet", (boolean)(set instanceof PredicatedSet));
        try {
            SetUtils.predicatedSet(new HashSet(), null);
            Assert.fail((String)"Expecting NullPointerException for null predicate.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SetUtils.predicatedSet(null, (Predicate)predicate);
            Assert.fail((String)"Expecting NullPointerException for null set.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testUnmodifiableSet() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Object[0]);
        Assert.assertTrue((String)"set is empty", (boolean)set1.isEmpty());
        Set set2 = SetUtils.unmodifiableSet((Object[])new Integer[]{1, 2, 2, 3});
        Assert.assertEquals((String)"set has 3 elements", (long)3L, (long)set2.size());
        Assert.assertTrue((String)"set contains 1", (boolean)set2.contains(1));
        Assert.assertTrue((String)"set contains 2", (boolean)set2.contains(2));
        Assert.assertTrue((String)"set contains 3", (boolean)set2.contains(3));
        Set set3 = SetUtils.unmodifiableSet((Object[])new String[]{"1", "2", "2", "3"});
        Assert.assertEquals((String)"set has 3 elements", (long)3L, (long)set3.size());
        Assert.assertTrue((String)"set contains 1", (boolean)set3.contains("1"));
        Assert.assertTrue((String)"set contains 2", (boolean)set3.contains("2"));
        Assert.assertTrue((String)"set contains 3", (boolean)set3.contains("3"));
        Set set4 = SetUtils.unmodifiableSet((Object[])new Object[]{null, null});
        Assert.assertEquals((String)"set has 1 element", (long)1L, (long)set4.size());
        Assert.assertTrue((String)"set contains null", (boolean)set4.contains(null));
        Set set5 = SetUtils.unmodifiableSet((Object[])null);
        Assert.assertEquals((String)"set is null", null, (Object)set5);
    }

    @Test
    public void testUnmodifiableSetWrap() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Integer[]{1, 2, 2, 3});
        Set set2 = SetUtils.unmodifiableSet((Set)set1);
        Assert.assertSame((Object)set1, (Object)set2);
    }

    @Test
    public void union() {
        SetUtils.SetView set = SetUtils.union(this.setA, this.setB);
        Assert.assertEquals((long)7L, (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(this.setA));
        Assert.assertTrue((boolean)set.containsAll(this.setB));
        SetUtils.SetView set2 = SetUtils.union(this.setA, (Set)SetUtils.emptySet());
        Assert.assertEquals(this.setA, (Object)set2);
        try {
            SetUtils.union(this.setA, null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SetUtils.union(null, this.setA);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

