/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.beanutils2.BeanIntrospectionData;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.DefaultBeanIntrospector;
import org.apache.commons.beanutils2.DefaultIntrospectionContext;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.MethodUtils;
import org.apache.commons.beanutils2.NestedNullException;
import org.apache.commons.beanutils2.SuppressPropertiesBeanIntrospector;
import org.apache.commons.beanutils2.WeakFastHashMap;
import org.apache.commons.beanutils2.WrapDynaBean;
import org.apache.commons.beanutils2.expression.DefaultResolver;
import org.apache.commons.beanutils2.expression.Resolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private static final Log LOG = LogFactory.getLog(PropertyUtilsBean.class);
    private Resolver resolver = new DefaultResolver();
    private final WeakFastHashMap<Class<?>, BeanIntrospectionData> descriptorsCache = new WeakFastHashMap();
    private final WeakFastHashMap<Class<?>, Map> mappedDescriptorsCache;
    private final List<BeanIntrospector> introspectors;

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    private static List<Object> toObjectList(Object obj) {
        return (List)obj;
    }

    private static Map<String, Object> toPropertyMap(Object obj) {
        return (Map)obj;
    }

    public PropertyUtilsBean() {
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
        this.introspectors = new CopyOnWriteArrayList<BeanIntrospector>();
        this.resetBeanIntrospectors();
    }

    public void addBeanIntrospector(BeanIntrospector introspector) {
        this.introspectors.add(Objects.requireNonNull(introspector, "introspector"));
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(dest, "dest");
        Objects.requireNonNull(orig, "orig");
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors;
            for (DynaProperty origDescriptor : origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties()) {
                String name = origDescriptor.getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = ((DynaBean)orig).get(name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                }
            }
        } else if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name = (String)entry.getKey();
                if (!this.isWriteable(dest, name)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, name, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors;
            for (PropertyDescriptor origDescriptor : origDescriptors = this.getPropertyDescriptors(orig)) {
                String name = origDescriptor.getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = this.getSimpleProperty(orig, name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                }
            }
        }
    }

    public Map<String, Object> describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors;
            for (DynaProperty descriptor : descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties()) {
                String name = descriptor.getName();
                description.put(name, this.getProperty(bean, name));
            }
        } else {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = this.getPropertyDescriptors(bean)) {
                String name = descriptor.getName();
                if (descriptor.getReadMethod() == null) continue;
                description.put(name, this.getProperty(bean, name));
            }
        }
        return description;
    }

    private BeanIntrospectionData fetchIntrospectionData(Class<?> beanClass) {
        DefaultIntrospectionContext ictx = new DefaultIntrospectionContext(beanClass);
        for (BeanIntrospector bi : this.introspectors) {
            try {
                bi.introspect(ictx);
            }
            catch (IntrospectionException iex) {
                LOG.error((Object)"Exception during introspection", (Throwable)iex);
            }
        }
        return new BeanIntrospectionData(ictx.getPropertyDescriptors());
    }

    public Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean, name, index);
    }

    public Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        Objects.requireNonNull(bean, "bean");
        if (name == null || name.isEmpty()) {
            if (bean.getClass().isArray()) {
                return Array.get(bean, index);
            }
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
        }
        Objects.requireNonNull(name, "name");
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            return ((DynaBean)bean).get(name, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod != null) {
                try {
                    return this.invokeMethod(readMethod, bean, index);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, BeanUtils.EMPTY_OBJECT_ARRAY);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            }
            return ((List)value).get(index);
        }
        try {
            return Array.get(value, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(value) + " for property '" + name + "'");
        }
    }

    private BeanIntrospectionData getIntrospectionData(Class<?> beanClass) {
        Objects.requireNonNull(beanClass, "beanClass");
        BeanIntrospectionData data = this.descriptorsCache.get(beanClass);
        if (data == null) {
            data = this.fetchIntrospectionData(beanClass);
            this.descriptorsCache.put(beanClass, data);
        }
        return data;
    }

    public Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean, name, key);
    }

    public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(key, "key");
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
            }
            return ((DynaBean)bean).get(name, key);
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod == null) {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            }
            result = this.invokeMethod(readMethod, bean, key);
        } else {
            Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
            if (readMethod == null) {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            }
            Object invokeResult = this.invokeMethod(readMethod, bean, BeanUtils.EMPTY_OBJECT_ARRAY);
            if (invokeResult instanceof Map) {
                result = ((Map)invokeResult).get(key);
            }
        }
        return result;
    }

    Map<Class<?>, Map> getMappedPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        return this.mappedDescriptorsCache.get(beanClass);
    }

    Map getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        bean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, name) : (this.resolver.isMapped(name) ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        BeanIntrospectionData data = this.getIntrospectionData(bean.getClass());
        PropertyDescriptor result = data.getDescriptor(name);
        if (result != null) {
            return result;
        }
        ConcurrentHashMap<String, PropertyDescriptor> mappedDescriptors = this.getMappedPropertyDescriptors(bean);
        if (mappedDescriptors == null) {
            mappedDescriptors = new ConcurrentHashMap<String, PropertyDescriptor>();
            this.mappedDescriptorsCache.put(bean.getClass(), mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get(name)) == null) {
            try {
                result = new MappedPropertyDescriptor(name, bean.getClass());
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put(name, result);
            }
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return this.getIntrospectionData(beanClass).getDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        Objects.requireNonNull(bean, "bean");
        return this.getPropertyDescriptors(bean.getClass());
    }

    public Class<?> getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    protected Object getPropertyOfMapBean(Map<?, ?> bean, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.isEmpty())) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean.get(propertyName);
    }

    public Class<?> getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object descriptor;
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof DynaBean) {
            descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                return null;
            }
            Class<?> type = ((DynaProperty)descriptor).getType();
            if (type == null) {
                return null;
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            return type;
        }
        descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
        }
        return ((PropertyDescriptor)descriptor).getPropertyType();
    }

    public Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        return this.invokeMethod(readMethod, bean, BeanUtils.EMPTY_OBJECT_ARRAY);
    }

    public Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        BeanIntrospectionData data = this.getIntrospectionData(clazz);
        return MethodUtils.getAccessibleMethod(clazz, data.getWriteMethod(clazz, descriptor));
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    private Object invokeMethod(Method method, Object bean, Object ... values) throws IllegalAccessException, InvocationTargetException {
        Objects.requireNonNull(bean, "bean");
        try {
            return method.invoke(bean, values);
        }
        catch (IllegalArgumentException | NullPointerException cause) {
            StringBuilder valueString = new StringBuilder();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString.append(", ");
                    }
                    if (values[i] == null) {
                        valueString.append("<null>");
                        continue;
                    }
                    valueString.append(values[i].getClass().getName());
                }
            }
            StringBuilder expectedString = new StringBuilder();
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString.append(", ");
                    }
                    expectedString.append(parTypes[i].getName());
                }
            }
            throw new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\"", cause);
        }
    }

    public boolean isReadable(Object bean, String name) {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method readMethod = this.getReadMethod(bean.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public boolean isWriteable(Object bean, String name) {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method writeMethod = this.getWriteMethod(bean.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public boolean removeBeanIntrospector(BeanIntrospector introspector) {
        return this.introspectors.remove(introspector);
    }

    public final void resetBeanIntrospectors() {
        this.introspectors.clear();
        this.introspectors.add(DefaultBeanIntrospector.INSTANCE);
        this.introspectors.add(SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
    }

    public void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        Objects.requireNonNull(bean, "bean");
        if (name == null || name.isEmpty()) {
            if (bean.getClass().isArray()) {
                Array.set(bean, index, value);
                return;
            }
            if (bean instanceof List) {
                List<Object> list = PropertyUtilsBean.toObjectList(bean);
                list.set(index, value);
                return;
            }
        }
        Objects.requireNonNull(name, "name");
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
            if (writeMethod != null) {
                try {
                    if (LOG.isTraceEnabled()) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        LOG.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")"));
                    }
                    this.invokeMethod(writeMethod, bean, index, value);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
                return;
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object array = this.invokeMethod(readMethod, bean, BeanUtils.EMPTY_OBJECT_ARRAY);
        if (!array.getClass().isArray()) {
            if (!(array instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            }
            List<Object> list = PropertyUtilsBean.toObjectList(array);
            list.set(index, value);
        } else {
            Array.set(array, index, value);
        }
    }

    public void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean, name, index, value);
    }

    public void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean, name, key, value);
    }

    public void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(key, "key");
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, key, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped setter methodon bean class '" + bean.getClass() + "'");
            }
            if (LOG.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                LOG.trace((Object)("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")"));
            }
            this.invokeMethod(mappedWriteMethod, bean, key, value);
        } else {
            Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
            if (readMethod == null) {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            }
            Object invokeResult = this.invokeMethod(readMethod, bean, BeanUtils.EMPTY_OBJECT_ARRAY);
            if (invokeResult instanceof Map) {
                PropertyUtilsBean.toPropertyMap(invokeResult).put(key, value);
            }
        }
    }

    public void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        if (bean instanceof Map) {
            this.setPropertyOfMapBean(PropertyUtilsBean.toPropertyMap(bean), name, value);
        } else if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean, name, value);
        } else if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean, name, value);
        } else {
            this.setSimpleProperty(bean, name, value);
        }
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean, name, value);
    }

    protected void setPropertyOfMapBean(Map<String, Object> bean, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.isEmpty())) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean.put(propertyName, value);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver == null ? new DefaultResolver() : resolver;
    }

    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(name, "name");
        Class<?> beanClass = bean.getClass();
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + beanClass + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + beanClass + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + beanClass + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + beanClass + "'");
        }
        Method writeMethod = this.getWriteMethod(beanClass, descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + beanClass + "'");
        }
        if (LOG.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            LOG.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")"));
        }
        this.invokeMethod(writeMethod, bean, value);
    }
}

