/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.beanutils2.ContextClassLoaderLocal;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.PropertyDescriptors;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.WrapDynaBean;

public class WrapDynaClass
implements DynaClass {
    private static final ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>> CLASSLOADER_CACHE = new ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>>(){

        @Override
        protected Map<CacheKey, WrapDynaClass> initialValue() {
            return new WeakHashMap<CacheKey, WrapDynaClass>();
        }
    };
    private final String beanClassName;
    private final Reference<Class<?>> beanClassRef;
    private final PropertyUtilsBean propertyUtilsBean;
    protected HashMap<String, PropertyDescriptor> descriptorsMap = new HashMap();
    protected DynaProperty[] properties;
    protected HashMap<String, DynaProperty> propertiesMap = new HashMap();

    public static void clear() {
        WrapDynaClass.getClassesCache().clear();
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass) {
        return WrapDynaClass.createDynaClass(beanClass, null);
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass, PropertyUtilsBean pu) {
        PropertyUtilsBean propUtils = pu != null ? pu : PropertyUtilsBean.getInstance();
        CacheKey key = new CacheKey(beanClass, propUtils);
        WrapDynaClass dynaClass = WrapDynaClass.getClassesCache().get(key);
        if (dynaClass == null) {
            dynaClass = new WrapDynaClass(beanClass, propUtils);
            WrapDynaClass.getClassesCache().put(key, dynaClass);
        }
        return dynaClass;
    }

    private static Map<CacheKey, WrapDynaClass> getClassesCache() {
        return CLASSLOADER_CACHE.get();
    }

    private WrapDynaClass(Class<?> beanClass, PropertyUtilsBean propUtils) {
        this.beanClassRef = new SoftReference(beanClass);
        this.beanClassName = beanClass.getName();
        this.propertyUtilsBean = propUtils;
        this.introspect();
    }

    protected Class<?> getBeanClass() {
        return this.beanClassRef.get();
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return (DynaProperty[])this.properties.clone();
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.propertiesMap.get(name);
    }

    @Override
    public String getName() {
        return this.beanClassName;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.descriptorsMap.get(name);
    }

    protected PropertyUtilsBean getPropertyUtilsBean() {
        return this.propertyUtilsBean;
    }

    protected void introspect() {
        Map<Class<?>, Map> mappeds;
        Class<?> beanClass = this.getBeanClass();
        PropertyDescriptor[] regulars = this.getPropertyUtilsBean().getPropertyDescriptors(beanClass);
        if (regulars == null) {
            regulars = PropertyDescriptors.EMPTY_ARRAY;
        }
        if ((mappeds = PropertyUtils.getMappedPropertyDescriptors(beanClass)) == null) {
            mappeds = new HashMap();
        }
        this.properties = new DynaProperty[regulars.length + mappeds.size()];
        for (int i = 0; i < regulars.length; ++i) {
            this.descriptorsMap.put(regulars[i].getName(), regulars[i]);
            this.properties[i] = new DynaProperty(regulars[i].getName(), regulars[i].getPropertyType());
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
        int j = regulars.length;
        for (Map.Entry<Class<?>, Map> entry : mappeds.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)((Object)entry.getValue());
            this.properties[j] = new DynaProperty(descriptor.getName(), Map.class);
            this.propertiesMap.put(this.properties[j].getName(), this.properties[j]);
            ++j;
        }
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.getBeanClass().newInstance());
    }

    private static class CacheKey {
        private final Class<?> beanClass;
        private final PropertyUtilsBean propUtils;

        public CacheKey(Class<?> beanCls, PropertyUtilsBean pu) {
            this.beanClass = beanCls;
            this.propUtils = pu;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey c = (CacheKey)obj;
            return this.beanClass.equals(c.beanClass) && this.propUtils.equals(c.propUtils);
        }

        public int hashCode() {
            int factor = 31;
            int result = 17;
            result = 31 * this.beanClass.hashCode() + result;
            result = 31 * this.propUtils.hashCode() + result;
            return result;
        }
    }
}

