/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

/**
 * EvalContext that walks the "ancestor::" and "ancestor-or-self::" axes.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.15 $ $Date: 2004-03-25 03:49:50 +0000 (Thu, 25 Mar 2004) $
 */
public class AncestorContext extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodePointer currentNodePointer;
    private boolean includeSelf;

    /**
     * @param parentContext represents the previous step on the path
     * @param  includeSelf differentiates between "ancestor::" and "ancestor-
     * or-self::" axes
     * @param nameTest is the name of the element(s) we are looking for
     */
    public AncestorContext(
        EvalContext parentContext,
        boolean includeSelf,
        NodeTest nodeTest) 
    {
        super(parentContext);
        this.includeSelf = includeSelf;
        this.nodeTest = nodeTest;
    }

    public NodePointer getCurrentNodePointer() {
        return currentNodePointer;
    }

    public int getDocumentOrder() {
        return -1;
    }

    public void reset() {
        super.reset();
        setStarted = false;
    }

    public boolean setPosition(int position) {
        if (position < getCurrentPosition()) {
            reset();
        }

        while (getCurrentPosition() < position) {
            if (!nextNode()) {
                return false;
            }
        }
        return true;
    }

    public boolean nextNode() {
        if (!setStarted) {
            setStarted = true;
            currentNodePointer = parentContext.getCurrentNodePointer();
            if (includeSelf) {
                if (currentNodePointer.testNode(nodeTest)) {
                    position++;
                    return true;
                }
            }
        }

        while (true) {
            currentNodePointer = currentNodePointer.getImmediateParentPointer();

            if (currentNodePointer == null) {
                return false;
            }

            if (currentNodePointer.testNode(nodeTest)) {
                position++;
                return true;
            }
        }
    }
}