/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath;

import java.net.URL;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;

import org.apache.commons.jxpath.xml.DocumentContainer;
import org.w3c.dom.Document;

/**
 * An XML document container reads and parses XML only when it is
 * accessed.  JXPath traverses Containers transparently -
 * you use the same paths to access objects in containers as you
 * do to access those objects directly.  You can create
 * XMLDocumentContainers for various XML documents that may or
 * may not be accessed by XPaths.  If they are, they will be automatically
 * read, parsed and traversed. If they are not - they won't be
 * read at all.
 *
 * @deprecated 1.1 Please use org.apache.commons.jxpath.xml.DocumentContainer
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.11 $ $Date: 2004-02-29 14:17:46 +0000 (Sun, 29 Feb 2004) $
 */
public class XMLDocumentContainer implements Container {

    private DocumentContainer delegate;
    private Object document;
    private URL xmlURL;
    private Source source;
    private String parser;

    /**
     * @param  URL is a URL for an XML file. Use getClass().getResource
     * (resourceName) to load XML from a resource file.
     */
    public XMLDocumentContainer(URL xmlURL) {
        delegate = new DocumentContainer(xmlURL);
    }

    public XMLDocumentContainer(Source source) {
        this.source = source;
        if (source == null) {
            throw new RuntimeException("Source is null");
        }
    }

    /**
     * Reads XML, caches it internally and returns the Document.
     */
    public Object getValue() {
        if (document == null) {
            try {
                if (source != null) {
                    DOMResult result = new DOMResult();
                    Transformer trans =
                        TransformerFactory.newInstance().newTransformer();
                    trans.transform(source, result);
                    document = (Document) result.getNode();
                }
                else {
                    document = delegate.getValue();
                }
            }
            catch (Exception ex) {
                throw new JXPathException(
                    "Cannot read XML from: "
                        + (xmlURL != null
                            ? xmlURL.toString()
                            : (source != null
                                ? source.getSystemId()
                                : "<<undefined source>>")),
                    ex);
            }
        }
        return document;
    }

    /**
     * Throws an UnsupportedOperationException
     */
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }
}