/*
 * Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jxpath;

/**
 * A delegate of JXPathContext that implements the XPath <code>"id()"</code>
 * function. This delegate is only used when there is no default implementation
 * of the <code>id()</code> function. For example, it is <i>not</i> used
 * when the root of the context is a DOM Node.
 *
 * @author Dmitri Plotnikov
 * @version $Revision: 1.4 $ $Date: 2004-02-29 14:17:46 +0000 (Sun, 29 Feb 2004) $
 */
public interface IdentityManager {

    /**
     * Finds a node by its ID.
     */
    Pointer getPointerByID(JXPathContext context, String id);
}