/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected boolean defaultAutoCommit = true;
    protected Boolean defaultReadOnly = null;
    protected int defaultTransactionIsolation = -1;
    protected String defaultCatalog = null;
    protected String driverClassName = null;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean poolPreparedStatements = false;
    protected int maxOpenPreparedStatements = -1;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;
    protected String password = null;
    protected String url = null;
    protected String username = null;
    protected String validationQuery = null;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private boolean restartNeeded = false;
    protected GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;

    public synchronized boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public synchronized void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
        this.restartNeeded = true;
    }

    public synchronized boolean getDefaultReadOnly() {
        if (this.defaultReadOnly != null) {
            return this.defaultReadOnly;
        }
        return false;
    }

    public synchronized void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this.restartNeeded = true;
    }

    public synchronized int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public synchronized void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.restartNeeded = true;
    }

    public synchronized String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public synchronized void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog != null && defaultCatalog.trim().length() > 0 ? defaultCatalog : null;
        this.restartNeeded = true;
    }

    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName != null && driverClassName.trim().length() > 0 ? driverClassName : null;
        this.restartNeeded = true;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxActive(maxActive);
        }
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(maxIdle);
        }
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(minIdle);
        }
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
        this.restartNeeded = true;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWait(maxWait);
        }
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean poolingStatements) {
        this.poolPreparedStatements = poolingStatements;
        this.restartNeeded = true;
    }

    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized void setMaxOpenPreparedStatements(int maxOpenStatements) {
        this.maxOpenPreparedStatements = maxOpenStatements;
        this.restartNeeded = true;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        }
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        }
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    public synchronized int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public synchronized int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
        this.restartNeeded = true;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
        this.restartNeeded = true;
    }

    public synchronized String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String username) {
        this.username = username;
        this.restartNeeded = true;
    }

    public synchronized String getValidationQuery() {
        return this.validationQuery;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery != null && validationQuery.trim().length() > 0 ? validationQuery : null;
        this.restartNeeded = true;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
        this.restartNeeded = true;
    }

    private synchronized boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public int getLoginTimeout() throws SQLException {
        return this.createDataSource().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.createDataSource().setLoginTimeout(loginTimeout);
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    public boolean getRemoveAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandoned();
        }
        return false;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandoned(removeAbandoned);
        this.restartNeeded = true;
    }

    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(removeAbandonedTimeout);
        this.restartNeeded = true;
    }

    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(logAbandoned);
        this.restartNeeded = true;
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
        this.restartNeeded = true;
    }

    public void removeConnectionProperty(String name) {
        this.connectionProperties.remove(name);
        this.restartNeeded = true;
    }

    public synchronized void close() throws SQLException {
        GenericObjectPool oldpool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot close connection pool", e);
        }
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Class<?> driverFromCCL = null;
        if (this.driverClassName != null) {
            try {
                try {
                    Class.forName(this.driverClassName);
                }
                catch (ClassNotFoundException e) {
                    driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                }
            }
            catch (Throwable t) {
                String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                this.logWriter.println(message);
                t.printStackTrace(this.logWriter);
                throw new SQLNestedException(message, t);
            }
        }
        Driver driver = null;
        try {
            if (driverFromCCL != null) {
                driver = (Driver)driverFromCCL.newInstance();
                if (!driver.acceptsURL(this.url)) {
                    new SQLException("No suitable driver", "08001");
                }
            } else {
                driver = DriverManager.getDriver(this.url);
            }
        }
        catch (Throwable t) {
            String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        this.connectionPool = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandoned() ? new AbandonedObjectPool(null, this.abandonedConfig) : new GenericObjectPool();
        this.connectionPool.setMaxActive(this.maxActive);
        this.connectionPool.setMaxIdle(this.maxIdle);
        this.connectionPool.setMinIdle(this.minIdle);
        this.connectionPool.setMaxWait(this.maxWait);
        this.connectionPool.setTestOnBorrow(this.testOnBorrow);
        this.connectionPool.setTestOnReturn(this.testOnReturn);
        this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.connectionPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.connectionPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.connectionPool.setTestWhileIdle(this.testWhileIdle);
        GenericKeyedObjectPoolFactory statementPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            statementPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        if (this.username != null) {
            this.connectionProperties.put("user", this.username);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        if (this.password != null) {
            this.connectionProperties.put("password", this.password);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverConnectionFactory, (ObjectPool)this.connectionPool, (KeyedObjectPoolFactory)statementPoolFactory, this.validationQuery, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, this.abandonedConfig);
            if (connectionFactory == null) {
                throw new SQLException("Cannot create PoolableConnectionFactory");
            }
            BasicDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        ((PoolingDataSource)this.dataSource).setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        this.dataSource.setLogWriter(this.logWriter);
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception e) {
            throw new SQLNestedException("Error preloading the connection pool", e);
        }
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        Connection conn = null;
        try {
            conn = (Connection)connectionFactory.makeObject();
            connectionFactory.activateObject(conn);
            connectionFactory.validateConnection(conn);
            connectionFactory.passivateObject(conn);
        }
        finally {
            connectionFactory.destroyObject(conn);
        }
    }

    private void restart() {
        try {
            this.close();
        }
        catch (SQLException e) {
            this.log("Could not restart DataSource, cause: " + e.getMessage());
        }
    }

    private void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }
}

