/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.caching.TimestampURLCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.sax.AbstractSAXProducer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.cocoon.stringtemplate.STRenderer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class StringTemplateGenerator
extends AbstractSAXProducer
implements Starter,
CachingPipelineComponent {
    private static final Logger LOG = LoggerFactory.getLogger(StringTemplateGenerator.class);
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    private URL url;
    private File file;
    private InputStream stream;
    private String string;

    public StringTemplateGenerator() {
    }

    public StringTemplateGenerator(URL source) {
        this.url = source;
    }

    public StringTemplateGenerator(File file) {
        this.file = file;
    }

    public StringTemplateGenerator(InputStream stream) {
        this.stream = stream;
    }

    public StringTemplateGenerator(String string) {
        this.string = string;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public CacheKey constructCacheKey() {
        if (this.url == null) {
            return null;
        }
        CompoundCacheKey cacheKey = new CompoundCacheKey();
        cacheKey.addCacheKey((CacheKey)new TimestampURLCacheKey(this.url, URLConnectionUtils.getLastModified((URL)this.url)));
        cacheKey.addCacheKey((CacheKey)ParameterCacheKey.getSitemapSafeInstance(this.parameters));
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTemplate() throws IOException {
        String template = null;
        InputStream localStream = null;
        String templateLocation = null;
        try {
            if (this.url != null) {
                localStream = this.url.openStream();
                template = IOUtils.toString((InputStream)localStream, (String)"UTF-8");
                templateLocation = this.url.toExternalForm();
            } else if (this.file != null) {
                localStream = new FileInputStream(this.file);
                template = IOUtils.toString((InputStream)localStream, (String)"UTF-8");
                templateLocation = this.file.toURI().toASCIIString();
            } else if (this.stream != null) {
                localStream = this.stream;
                template = IOUtils.toString((InputStream)this.stream, (String)"UTF-8");
                templateLocation = this.stream.toString();
            } else if (this.string != null) {
                template = this.string;
                templateLocation = String.class.getName();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(localStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)localStream);
        LOG.debug("Using template: {}", (Object)templateLocation);
        return template;
    }

    protected String renderTemplate() throws IOException {
        return STRenderer.getInstance().render(this.getTemplate(), this.parameters);
    }

    public void execute() {
        if (this.url == null && this.file == null && this.stream == null && this.string == null) {
            throw new IllegalArgumentException("StringTemplateGenerator has no source.");
        }
        try {
            XMLUtils.createXMLReader((ContentHandler)this.getSAXConsumer()).parse(new InputSource(new StringReader(this.renderTemplate())));
        }
        catch (Exception e) {
            throw new ProcessingException("Can't parse url connection " + this.url, (Throwable)e);
        }
    }

    public void setup(Map<String, Object> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    public void setConfiguration(Map<String, ? extends Object> parameters) {
        this.url = (URL)parameters.get("source");
        this.setup(parameters);
    }
}

