/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.xml.impl;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cocoon.core.xml.DOMParser;
import org.apache.cocoon.core.xml.impl.AbstractJaxpParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JaxpDOMParser
extends AbstractJaxpParser
implements DOMParser {
    protected DocumentBuilderFactory factory;
    protected String documentBuilderFactoryName = "javax.xml.parsers.DocumentBuilderFactory";

    public String getDocumentBuilderFactoryName() {
        return this.documentBuilderFactoryName;
    }

    public void setDocumentBuilderFactoryName(String documentBuilderFactoryName) {
        this.documentBuilderFactoryName = documentBuilderFactoryName;
    }

    protected synchronized void initDomBuilderFactory() throws Exception {
        if (this.factory == null) {
            if ("javax.xml.parsers.DocumentBuilderFactory".equals(this.documentBuilderFactoryName)) {
                this.factory = DocumentBuilderFactory.newInstance();
            } else {
                Class factoryClass = this.loadClass(this.documentBuilderFactoryName);
                this.factory = (DocumentBuilderFactory)factoryClass.newInstance();
            }
            this.factory.setNamespaceAware(true);
            this.factory.setValidating(this.validate);
        }
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        DocumentBuilder tmpBuilder = this.setupDocumentBuilder();
        Document result = tmpBuilder.parse(input);
        return result;
    }

    protected DocumentBuilder setupDocumentBuilder() throws SAXException {
        DocumentBuilder docBuilder;
        if (this.factory == null) {
            try {
                this.initDomBuilderFactory();
            }
            catch (Exception e) {
                String message = "Cannot initialize dom builder factory";
                throw new SAXException("Cannot initialize dom builder factory", e);
            }
        }
        try {
            docBuilder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String message = "Could not create DocumentBuilder";
            throw new SAXException("Could not create DocumentBuilder", pce);
        }
        if (this.resolver != null) {
            docBuilder.setEntityResolver(this.resolver);
        }
        return docBuilder;
    }

    public Document createDocument() throws SAXException {
        return this.setupDocumentBuilder().newDocument();
    }
}

