/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.thread.impl;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import org.apache.cocoon.thread.ThreadFactory;
import org.apache.cocoon.thread.ThreadPool;
import org.apache.cocoon.thread.impl.BoundedQueue;
import org.apache.cocoon.thread.impl.ChannelWrapper;
import org.apache.cocoon.thread.impl.DefaultThreadFactory;
import org.apache.cocoon.thread.impl.LinkedQueue;
import org.apache.cocoon.thread.impl.Queue;
import org.apache.cocoon.thread.impl.SynchronousChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultThreadPool
extends PooledExecutor
implements ThreadPool {
    public static final String POLICY_DEFAULT = "RUN";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String name = "default";
    private boolean daemon = false;
    private int priority = this.convertPriority("NORM");
    private int queueSize = -1;
    private int maxPoolSize = 5;
    private int minPoolSize = 5;
    private long keepAliveTime = 60000L;
    private String blockPolicy = "RUN";
    private boolean shutdownGraceful = false;
    private int shutdownWaitTimeMs = -1;
    private ThreadFactory factory;
    private ChannelWrapper channelWrapper;
    private Queue queue;

    private DefaultThreadPool(ChannelWrapper channel) {
        super((Channel)channel);
        this.channelWrapper = channel;
    }

    DefaultThreadPool() {
        this(new ChannelWrapper());
    }

    public void init() throws IllegalArgumentException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ThreadPool [" + this.name + "] initializing ..."));
        }
        this.initFactory();
        this.setThreadFactory((EDU.oswego.cs.dl.util.concurrent.ThreadFactory)this.factory);
        this.initMinPoolSize();
        this.initPriority();
        this.initDaemon();
        this.initQueueSize();
        this.initMaxPoolSize();
        this.initKeepAliveTime();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.toString());
            this.logger.info((Object)("ThreadPool [" + this.name + "] initialized"));
        }
    }

    public String getBlockPolicy() {
        return this.blockPolicy;
    }

    public int getMaxQueueSize() {
        return this.queueSize < 0 ? Integer.MAX_VALUE : this.queueSize;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return ((ThreadFactory)super.getThreadFactory()).getPriority();
    }

    public int getQueueSize() {
        return this.queue.getQueueSize();
    }

    public boolean isQueued() {
        return this.queueSize != 0;
    }

    public void execute(Runnable command) throws InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing Command: " + command.toString() + ",pool=" + this.getName()));
        }
        super.execute(command);
    }

    public void shutdown() {
        if (this.shutdownGraceful) {
            this.shutdownAfterProcessingCurrentlyQueuedTasks();
        } else {
            this.shutdownNow();
        }
        try {
            if (this.getShutdownWaitTimeMs() > 0 && !this.awaitTerminationAfterShutdown(this.getShutdownWaitTimeMs())) {
                this.logger.warn((Object)("running commands have not terminated within " + this.getShutdownWaitTimeMs() + "ms. Will shut them down by interruption"));
                this.interruptAll();
                this.shutdownNow();
            }
            this.awaitTerminationAfterShutdown();
        }
        catch (InterruptedException ie) {
            this.logger.error((Object)"cannot shutdown ThreadPool", (Throwable)ie);
        }
    }

    public void setBlockPolicy(String blockPolicy) {
        this.blockPolicy = blockPolicy;
        if ("ABORT".equalsIgnoreCase(blockPolicy)) {
            this.abortWhenBlocked();
        } else if ("DISCARD".equalsIgnoreCase(blockPolicy)) {
            this.discardWhenBlocked();
        } else if ("DISCARDOLDEST".equalsIgnoreCase(blockPolicy)) {
            this.discardOldestWhenBlocked();
        } else if (POLICY_DEFAULT.equalsIgnoreCase(blockPolicy)) {
            this.runWhenBlocked();
        } else if ("WAIT".equalsIgnoreCase(blockPolicy)) {
            this.waitWhenBlocked();
        } else {
            StringBuffer msg = new StringBuffer();
            msg.append("WARNING: Unknown block-policy configuration \"").append(blockPolicy);
            msg.append("\". Should be one of \"").append("ABORT");
            msg.append("\",\"").append("DISCARD");
            msg.append("\",\"").append("DISCARDOLDEST");
            msg.append("\",\"").append(POLICY_DEFAULT);
            msg.append("\",\"").append("WAIT");
            msg.append("\". Will use \"").append(POLICY_DEFAULT).append("\"");
            this.logger.warn((Object)msg.toString());
            this.setBlockPolicy(POLICY_DEFAULT);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShutdownGraceful(boolean shutdownGraceful) {
        this.shutdownGraceful = shutdownGraceful;
    }

    public boolean isShutdownGraceful() {
        return this.shutdownGraceful;
    }

    public void setShutdownWaitTimeMs(int shutdownWaitTimeMs) {
        this.shutdownWaitTimeMs = shutdownWaitTimeMs;
    }

    public int getShutdownWaitTimeMs() {
        return this.shutdownWaitTimeMs;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public ThreadFactory getFactory() {
        return this.factory;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPoolPriority(String poolPriority) {
        this.setPriority(this.convertPriority(poolPriority));
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String toString() {
        if (this.isQueued()) {
            StringBuffer msg = new StringBuffer();
            msg.append("ThreadPool named \"").append(this.name);
            msg.append("\" created with maximum queue-size=").append(this.queueSize);
            msg.append(",max-pool-size=").append(this.maximumPoolSize_);
            msg.append(",min-pool-size=").append(this.minimumPoolSize_);
            msg.append(",priority=").append(this.priority);
            msg.append(",isDaemon=").append(((ThreadFactory)this.getThreadFactory()).isDaemon());
            msg.append(",keep-alive-time-ms=").append(this.keepAliveTime_);
            msg.append(",block-policy=\"").append(this.blockPolicy);
            msg.append("\",shutdown-wait-time-ms=").append(this.shutdownWaitTimeMs);
            return msg.toString();
        }
        StringBuffer msg = new StringBuffer();
        msg.append("ThreadPool named \"").append(this.name);
        msg.append("\" created with no queue,max-pool-size=").append(this.maximumPoolSize_);
        msg.append(",min-pool-size=").append(this.minimumPoolSize_);
        msg.append(",priority=").append(this.priority);
        msg.append(",isDaemon=").append(((ThreadFactory)this.getThreadFactory()).isDaemon());
        msg.append(",keep-alive-time-ms=").append(this.keepAliveTime_);
        msg.append(",block-policy=\"").append(this.blockPolicy);
        msg.append("\",shutdown-wait-time-ms=").append(this.shutdownWaitTimeMs);
        return msg.toString();
    }

    private int convertPriority(String priority) {
        if ("MIN".equalsIgnoreCase(priority)) {
            return 1;
        }
        if ("NORM".equalsIgnoreCase(priority)) {
            return 5;
        }
        if ("MAX".equalsIgnoreCase(priority)) {
            return 10;
        }
        this.logger.warn((Object)("Unknown thread priority \"" + priority + "\". Set to \"NORM\"."));
        return 5;
    }

    public void setFactory(ThreadFactory factory) {
        this.factory = factory;
    }

    private void initFactory() {
        if (this.factory == null) {
            this.logger.warn((Object)("No ThreadFactory is configured. Will use a " + ThreadFactoryUser.DefaultThreadFactory.class.getName()));
            this.factory = new DefaultThreadFactory();
        }
    }

    private void initMinPoolSize() {
        if ("default".equals(this.name) && this.minPoolSize > 0 && this.minPoolSize < 5) {
            this.minPoolSize = 5;
        }
        if (this.minPoolSize < 1) {
            this.minPoolSize = this.minPoolSize < 1 ? 1 : this.minPoolSize;
            this.logger.warn((Object)("min-pool-size < 1 for pool \"" + this.name + "\". Set to 1"));
        }
        super.setMinimumPoolSize(this.minPoolSize);
    }

    private void initPriority() {
        this.priority = this.factory.getPriority() != 5 ? this.factory.getPriority() : this.priority;
        this.factory.setPriority(this.priority);
    }

    private void initDaemon() {
        this.daemon = this.factory.isDaemon() ? this.factory.isDaemon() : this.daemon;
        this.factory.setDaemon(this.daemon);
    }

    private void initMaxPoolSize() {
        this.maxPoolSize = this.maxPoolSize < 0 ? Integer.MAX_VALUE : this.maxPoolSize;
        super.setMaximumPoolSize(this.maxPoolSize);
    }

    private void initKeepAliveTime() {
        if (this.keepAliveTime < 0L) {
            this.keepAliveTime = 1000L;
            this.logger.warn((Object)("keep-alive-time-ms < 0 for pool \"" + this.name + "\". Set to 1000"));
        }
        super.setKeepAliveTime(this.keepAliveTime);
    }

    private void initQueueSize() {
        this.queue = this.queueSize != 0 ? (this.queueSize > 0 ? new BoundedQueue(this.queueSize) : new LinkedQueue()) : new SynchronousChannel();
        this.channelWrapper.setChannel(this.queue);
    }
}

