/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.script.event;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.expression.Substitutions;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.event.AttributeEvent;
import org.apache.cocoon.template.script.event.CopyAttribute;
import org.apache.cocoon.template.script.event.EndElement;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.SubstituteAttribute;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StartElement
extends Event {
    final String namespaceURI;
    final String localName;
    final String raw;
    private final String qname;
    private final List attributeEvents = new LinkedList();
    final Attributes attributes;
    EndElement endElement;

    public StartElement(ParsingContext parsingContext, Locator location, String namespaceURI, String localName, String raw, Attributes attrs) throws SAXException {
        super(location);
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        this.raw = raw;
        this.qname = "{" + namespaceURI + "}" + localName;
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            String uri = attrs.getURI(i);
            String local = attrs.getLocalName(i);
            String qname = attrs.getQName(i);
            String type = attrs.getType(i);
            String value = attrs.getValue(i);
            Substitutions substitutions = new Substitutions(parsingContext.getStringTemplateParser(), this.getLocation(), value);
            if (substitutions.hasSubstitutions()) {
                this.getAttributeEvents().add(new SubstituteAttribute(uri, local, qname, type, substitutions));
                continue;
            }
            this.getAttributeEvents().add(new CopyAttribute(uri, local, qname, type, value));
        }
        this.attributes = new AttributesImpl(attrs);
    }

    public EndElement getEndElement() {
        return this.endElement;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getQname() {
        return this.qname;
    }

    public List getAttributeEvents() {
        return this.attributeEvents;
    }

    public void setEndElement(EndElement endElement) {
        this.endElement = endElement;
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        Iterator i = this.getAttributeEvents().iterator();
        AttributesImpl attrs = new AttributesImpl();
        while (i.hasNext()) {
            AttributeEvent attrEvent = (AttributeEvent)i.next();
            if (attrEvent instanceof CopyAttribute) {
                CopyAttribute copy = (CopyAttribute)attrEvent;
                attrs.addAttribute(copy.getNamespaceURI(), copy.getLocalName(), copy.getRaw(), copy.getType(), copy.getValue());
                continue;
            }
            if (!(attrEvent instanceof SubstituteAttribute)) continue;
            SubstituteAttribute substEvent = (SubstituteAttribute)attrEvent;
            String attributeValue = substEvent.getSubstitutions().toString(this.getLocation(), objectModel);
            attrs.addAttribute(attrEvent.getNamespaceURI(), attrEvent.getLocalName(), attrEvent.getRaw(), attrEvent.getType(), attributeValue);
        }
        namespaces.enterScope((ContentHandler)consumer);
        consumer.startElement(this.getNamespaceURI(), this.getLocalName(), this.getRaw(), (Attributes)attrs);
        return this.getNext();
    }
}

