/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.script;

import java.util.Stack;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.script.InstructionFactory;
import org.apache.cocoon.template.script.event.Characters;
import org.apache.cocoon.template.script.event.EndCDATA;
import org.apache.cocoon.template.script.event.EndDTD;
import org.apache.cocoon.template.script.event.EndDocument;
import org.apache.cocoon.template.script.event.EndElement;
import org.apache.cocoon.template.script.event.EndEntity;
import org.apache.cocoon.template.script.event.EndInstruction;
import org.apache.cocoon.template.script.event.EndPrefixMapping;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.IgnorableWhitespace;
import org.apache.cocoon.template.script.event.ProcessingInstruction;
import org.apache.cocoon.template.script.event.SkippedEntity;
import org.apache.cocoon.template.script.event.StartCDATA;
import org.apache.cocoon.template.script.event.StartDTD;
import org.apache.cocoon.template.script.event.StartDocument;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.template.script.event.StartEntity;
import org.apache.cocoon.template.script.event.StartPrefixMapping;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class Parser
implements ContentHandler,
LexicalHandler {
    StartDocument startEvent;
    Event lastEvent;
    Stack stack = new Stack();
    Locator locator;
    Locator charLocation;
    StringBuffer charBuf;
    public static final Locator NULL_LOCATOR = new LocatorImpl();
    protected ParsingContext parsingContext;

    public Parser() {
    }

    public Parser(ParsingContext parsingContext) {
        this.parsingContext = parsingContext;
    }

    public void setParsingContext(ParsingContext parsingContext) {
        this.parsingContext = parsingContext;
    }

    public StartDocument getStartEvent() {
        return this.startEvent;
    }

    protected void recycle() {
        this.startEvent = null;
        this.lastEvent = null;
        this.stack.clear();
        this.locator = null;
        this.charLocation = null;
        this.charBuf = null;
    }

    private void addEvent(Event ev) throws SAXException {
        if (ev != null) {
            if (this.lastEvent == null) {
                this.startEvent = new StartDocument(this.locator);
                this.lastEvent = this.startEvent;
            } else {
                this.flushChars();
            }
        } else {
            throw new NullPointerException("null event");
        }
        this.lastEvent.setNext(ev);
        this.lastEvent = ev;
    }

    void flushChars() throws SAXException {
        if (this.charBuf != null) {
            char[] chars = new char[this.charBuf.length()];
            this.charBuf.getChars(0, this.charBuf.length(), chars, 0);
            Characters ev = new Characters(this.parsingContext, this.charLocation, chars, 0, chars.length);
            this.lastEvent.setNext(ev);
            this.lastEvent = ev;
            this.charLocation = null;
            this.charBuf = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.charBuf == null) {
            this.charBuf = new StringBuffer(length);
            this.charLocation = this.locator != null ? new LocatorImpl(this.locator) : NULL_LOCATOR;
        }
        this.charBuf.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        StartDocument startDoc = (StartDocument)this.stack.pop();
        EndDocument endDoc = new EndDocument(this.locator);
        startDoc.setEndDocument(endDoc);
        this.addEvent(endDoc);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
        Event start = (Event)this.stack.pop();
        Event newEvent = null;
        if (start instanceof Instruction) {
            Instruction startInstruction = (Instruction)start;
            EndInstruction endInstruction = new EndInstruction(this.locator, startInstruction);
            newEvent = endInstruction;
            this.addEvent(newEvent);
            startInstruction.endNotify();
        } else {
            StartElement startElement = (StartElement)start;
            newEvent = new EndElement(this.locator, startElement);
            startElement.setEndElement((EndElement)newEvent);
            this.addEvent(newEvent);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        EndPrefixMapping endPrefixMapping = new EndPrefixMapping(this.locator, prefix);
        this.addEvent(endPrefixMapping);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        IgnorableWhitespace ev = new IgnorableWhitespace(this.parsingContext, this.locator, ch, start, length);
        this.addEvent(ev);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction pi = new ProcessingInstruction(this.locator, target, data);
        this.addEvent(pi);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.addEvent(new SkippedEntity(this.locator, name));
    }

    @Override
    public void startDocument() {
        this.startEvent = new StartDocument(this.locator);
        this.lastEvent = this.startEvent;
        this.stack.push(this.lastEvent);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attrs) throws SAXException {
        Event newEvent = null;
        AttributesImpl elementAttributes = new AttributesImpl(attrs);
        int attributeCount = elementAttributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeURI = elementAttributes.getURI(i);
            if (!StringUtils.equals((String)attributeURI, (String)"http://apache.org/cocoon/templates/jx/1.0")) continue;
            this.getStartEvent().getTemplateProperties().put(elementAttributes.getLocalName(i), this.parsingContext.getStringTemplateParser().compileExpr(elementAttributes.getValue(i), null, this.locator));
            elementAttributes.removeAttribute(i--);
        }
        StartElement startElement = new StartElement(this.parsingContext, this.locator, namespaceURI, localName, qname, elementAttributes);
        InstructionFactory instructionFactory = this.parsingContext.getInstructionFactory();
        newEvent = instructionFactory.isInstruction(startElement) ? instructionFactory.createInstruction(this.parsingContext, startElement, attrs, this.stack) : startElement;
        this.stack.push(newEvent);
        this.addEvent(newEvent);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.addEvent(new StartPrefixMapping(this.locator, prefix, uri));
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
        this.addEvent(new EndCDATA(this.locator));
    }

    @Override
    public void endDTD() throws SAXException {
        this.addEvent(new EndDTD(this.locator));
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.addEvent(new EndEntity(this.locator, name));
    }

    @Override
    public void startCDATA() throws SAXException {
        this.addEvent(new StartCDATA(this.locator));
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.addEvent(new StartDTD(this.locator, name, publicId, systemId));
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.addEvent(new StartEntity(this.locator, name));
    }
}

