/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class If
extends Instruction {
    private final Subst test;

    public If(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        Locator locator = this.getLocation();
        String test = attrs.getValue("test");
        if (test == null) {
            throw new SAXParseException("if: \"test\" is required", locator, null);
        }
        this.test = parsingContext.getStringTemplateParser().compileExpr(test, "if: \"test\": ", locator);
        this.test.setLenient(Boolean.TRUE);
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        Object val;
        try {
            val = this.test.getValue(objectModel);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getLocation(), e);
        }
        catch (Error err) {
            throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
        }
        boolean result = false;
        if (val instanceof Boolean) {
            result = (Boolean)val;
        } else {
            boolean bl = result = val != null;
        }
        if (!result) {
            return this.getEndInstruction().getNext();
        }
        return this.getNext();
    }
}

