/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Define;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.instruction.Parameter;
import org.apache.cocoon.template.instruction.ParameterInstance;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.AttributeEvent;
import org.apache.cocoon.template.script.event.Characters;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.IgnorableWhitespace;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.template.script.event.TextEvent;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Call
extends Instruction {
    private Object macro;
    private Subst targetNamespace;
    private Map parameters = new HashMap();
    private Event body;

    public Call(Define definition, StartElement startElement) throws SAXException {
        super(startElement);
        this.setBody(startElement);
        this.setNext(startElement.getNext());
        this.setDefinition(definition);
        for (AttributeEvent attrEvent : startElement.getAttributeEvents()) {
            this.addParameterInstance(attrEvent);
        }
    }

    public Call(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        Locator locator = this.getLocation();
        String name = attrs.getValue("macro");
        if (name == null) {
            throw new SAXParseException("if: \"test\" is required", locator, null);
        }
        this.macro = parsingContext.getStringTemplateParser().compileExpr(name, "call: \"macro\": ", locator);
        String namespace = StringUtils.defaultString((String)attrs.getValue("targetNamespace"));
        this.targetNamespace = parsingContext.getStringTemplateParser().compileExpr(namespace, "call: \"targetNamespace\": ", locator);
    }

    public void setDefinition(Define definition) {
        this.macro = definition;
    }

    public void addParameterInstance(AttributeEvent attributeEvent) throws SAXException {
        ParameterInstance parameter = new ParameterInstance(attributeEvent);
        this.parameters.put(parameter.getName(), parameter);
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String parameterName : this.parameters.keySet()) {
            ParameterInstance parameter = (ParameterInstance)this.parameters.get(parameterName);
            Object parameterValue = parameter.getValue(objectModel);
            attributeMap.put(parameterName, parameterValue);
        }
        objectModel.markLocalContext();
        HashMap<String, Object> macro = new HashMap<String, Object>();
        macro.put("body", this.body);
        macro.put("arguments", attributeMap);
        objectModel.put((Object)"macro", macro);
        Define definition = this.resolveMacroDefinition(objectModel, executionContext);
        for (Map.Entry e : definition.getParameters().entrySet()) {
            String key = (String)e.getKey();
            Parameter startParam = (Parameter)e.getValue();
            String default_ = startParam.getDefaultValue();
            Object val = attributeMap.get(key);
            if (val == null) {
                val = default_;
            }
            objectModel.put((Object)key, val);
        }
        Event macroBodyStart = this.getNext();
        Event macroBodyEnd = null;
        macroBodyEnd = this.getEndInstruction() != null ? this.getEndInstruction() : this.getStartElement().getEndElement();
        MacroContext newMacroContext = new MacroContext(definition.getQname(), macroBodyStart, macroBodyEnd);
        try {
            Invoker.execute(consumer, objectModel, executionContext, newMacroContext, namespaces, definition.getBody(), definition.getEndInstruction());
        }
        catch (SAXParseException exc) {
            throw new SAXParseException(newMacroContext.getMacroQName() + ": " + exc.getMessage(), this.location, exc);
        }
        objectModel.cleanupLocalContext();
        if (this.getEndInstruction() != null) {
            return this.getEndInstruction().getNext();
        }
        return this.getStartElement().getEndElement().getNext();
    }

    private Define resolveMacroDefinition(ObjectModel objectModel, ExecutionContext executionContext) throws SAXParseException {
        Object namespace;
        Object macroName;
        if (this.macro instanceof Define) {
            return (Define)this.macro;
        }
        Subst macroNameExpression = (Subst)this.macro;
        try {
            macroName = macroNameExpression.getValue(objectModel);
            namespace = this.targetNamespace.getValue(objectModel);
            if (namespace == null) {
                namespace = "";
            }
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getLocation(), e);
        }
        catch (Error err) {
            throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
        }
        Define definition = (Define)executionContext.getDefinitions().get("{" + namespace.toString() + "}" + macroName.toString());
        if (definition == null) {
            throw new SAXParseException("no macro definition: " + macroName, this.getLocation());
        }
        return definition;
    }

    public void setBody(Event body) {
        this.body = body;
    }

    @Override
    public void endNotify() throws SAXException {
        boolean params = true;
        block0: for (Event e = this.next; e != this.getEndInstruction(); e = e.getNext()) {
            if (e instanceof ParameterInstance) {
                ParameterInstance startParamInstance = (ParameterInstance)e;
                if (!params) {
                    throw new SAXParseException("<parameter value> not allowed here: \"" + startParamInstance.name + "\"", startParamInstance.getLocation(), null);
                }
                ParameterInstance prev = this.parameters.put(startParamInstance.name, startParamInstance);
                if (prev != null) {
                    throw new SAXParseException("duplicate parameter value: \"" + startParamInstance.name + "\"", this.location, null);
                }
                e = startParamInstance.getEndInstruction();
                continue;
            }
            if (e instanceof IgnorableWhitespace) continue;
            if (e instanceof Characters) {
                char[] ch = ((TextEvent)e).getRaw();
                int len = ch.length;
                for (int i = 0; i < len; ++i) {
                    if (Character.isWhitespace(ch[i])) continue;
                    if (!params) continue block0;
                    params = false;
                    this.body = e;
                    continue block0;
                }
                continue;
            }
            if (!params) continue;
            params = false;
            this.body = e;
        }
        if (this.body == null) {
            this.body = this.getEndInstruction();
        }
        this.setNext(this.body);
    }
}

