/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class InterpolatingConfigurationHandler
extends SAXConfigurationHandler {
    private final Map vars;
    private final String location;

    public InterpolatingConfigurationHandler(Map vars) {
        this.vars = vars;
        this.location = "Unknown";
    }

    public InterpolatingConfigurationHandler(Map vars, String location) {
        this.vars = vars;
        this.location = location;
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        AttributesImpl newAttr = new AttributesImpl(attr);
        for (int i = 0; i < attr.getLength(); ++i) {
            newAttr.setValue(i, this.interp(attr.getValue(i)));
        }
        super.startElement(uri, localName, qName, (Attributes)newAttr);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        StringBuffer buf = new StringBuffer();
        if (start != 0) {
            buf.append(ch, 0, start - 1);
        }
        String newVal = this.interp(new String(ch, start, len));
        buf.append(newVal);
        buf.append(ch, start + len, ch.length - (start + len));
        super.characters(buf.toString().toCharArray(), start, newVal.length());
    }

    protected String getLocationString() {
        return this.location;
    }

    private String interp(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 2);
        StringTokenizer tok = new StringTokenizer(str, "{}", true);
        boolean state = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!state && "{".equals(token)) {
                state = true;
                continue;
            }
            if (state && "}".equals(token)) {
                state = false;
                continue;
            }
            if (!state) {
                buf.append(token);
                continue;
            }
            if (!state) continue;
            String val = (String)this.vars.get(token);
            if (val == null) {
                buf.append("{").append(token).append("}");
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }
}

