/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.modules.input.InputModuleHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.helpers.VariableConfiguration;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkRewriterTransformer
extends AbstractSAXTransformer
implements Initializable,
Disposable {
    private static final String NAMESPACE = "";
    private static final Object NO_REGEXP = new Object();
    private Configuration origConf;
    private String origBadLinkStr;
    private String origInSchemes;
    private String origOutSchemes;
    private String origNamespaceURI;
    private Map origLinkAttrs;
    private Configuration conf;
    private String badLinkStr;
    private Set inSchemes;
    private Set outSchemes;
    private Map linkAttrs;
    private InputModuleHelper modHelper;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.origConf = conf;
        this.origBadLinkStr = conf.getChild("bad-link-str").getValue(null);
        this.origInSchemes = conf.getChild("schemes").getValue(NAMESPACE);
        this.origOutSchemes = conf.getChild("exclude-schemes").getValue("http https ftp news mailto");
        this.origNamespaceURI = conf.getChild("namespace-uri").getValue(NAMESPACE);
        String linkAttrsValue = conf.getChild("link-attrs").getValue(NAMESPACE);
        this.origLinkAttrs = this.split(linkAttrsValue, " ", NO_REGEXP);
        Configuration[] attrConfs = conf.getChildren("link-attr");
        if (attrConfs.length > 0) {
            RECompiler compiler = new RECompiler();
            for (int i = 0; i < attrConfs.length; ++i) {
                String pattern;
                String attr = attrConfs[i].getAttribute("name");
                if (this.getLogger().isWarnEnabled() && this.origLinkAttrs.containsKey(attr)) {
                    this.getLogger().warn((Object)("Duplicate configuration entry found for attribute '" + attr + "', overwriting previous configuration"));
                }
                if ((pattern = attrConfs[i].getAttribute("pattern", null)) == null) {
                    this.origLinkAttrs.put(attr, NO_REGEXP);
                    continue;
                }
                try {
                    this.origLinkAttrs.put(attr, compiler.compile(pattern));
                    continue;
                }
                catch (RESyntaxException e) {
                    String msg = "Invalid regexp pattern '" + pattern + "' specified for attribute '" + attr + "'";
                    throw new ConfigurationException(msg, attrConfs[i], (Throwable)e);
                }
            }
        }
        if (this.origLinkAttrs.size() == 0) {
            this.origLinkAttrs.put("href", NO_REGEXP);
        }
    }

    public void initialize() throws Exception {
        this.modHelper = new InputModuleHelper();
        this.modHelper.setup(this.manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.badLinkStr = parameters.getParameter("bad-link-str", this.origBadLinkStr);
        this.namespaceURI = parameters.getParameter("namespace-uri", this.origNamespaceURI);
        this.inSchemes = this.split(parameters.getParameter("schemes", this.origInSchemes), " ");
        this.outSchemes = this.split(parameters.getParameter("exclude-schemes", this.origOutSchemes), " ");
        this.linkAttrs = this.origLinkAttrs;
        if (parameters.isParameter("link-attrs")) {
            try {
                this.linkAttrs = this.split(parameters.getParameter("link-attrs"), " ", NO_REGEXP);
            }
            catch (ParameterException ex) {
                // empty catch block
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("bad-link-str = " + this.badLinkStr));
            this.getLogger().debug((Object)("link-attrs = " + this.linkAttrs));
            this.getLogger().debug((Object)("schemes = " + this.inSchemes));
            this.getLogger().debug((Object)("exclude-schemes = " + this.outSchemes));
            this.getLogger().debug((Object)("namespace-uri = " + this.namespaceURI));
        }
        VariableConfiguration varConf = new VariableConfiguration(this.origConf);
        varConf.addVariable("src", src);
        varConf.addVariables(parameters);
        try {
            this.conf = varConf.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new ProcessingException("Couldn't create dynamic config ", (Throwable)ce);
        }
    }

    public void recycle() {
        this.conf = null;
        this.badLinkStr = null;
        this.linkAttrs = null;
        this.inSchemes = null;
        this.outSchemes = null;
        super.recycle();
    }

    private Set split(String str, String delim) {
        if (str == null) {
            return null;
        }
        HashSet<String> tokens = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    private Map split(String str, String delim, Object valueObj) {
        if (str == null) {
            return null;
        }
        HashMap<String, Object> schemes = new HashMap<String, Object>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String pfx = st.nextToken();
            if (schemes.containsKey(pfx) && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)("Duplicate configuration entry found for attribute '" + pfx + "', overwriting previous configuration"));
            }
            schemes.put(pfx, valueObj);
        }
        return schemes;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        boolean matched = false;
        for (int attrIdx = 0; attrIdx < attr.getLength(); ++attrIdx) {
            String attrName = attr.getQName(attrIdx);
            String attrValue = this.createTransformedAttr(attrName, attr.getValue(attrIdx));
            if (attrValue == null) continue;
            if (!matched) {
                attr = new AttributesImpl(attr);
                matched = true;
            }
            ((AttributesImpl)attr).setValue(attrIdx, attrValue);
        }
        super.startTransformingElement(uri, name, raw, attr);
    }

    private String createTransformedAttr(String attrName, String oldAttrValue) {
        if (!this.linkAttrs.containsKey(attrName)) {
            return null;
        }
        String newAttrValue = null;
        Object reProgram = this.linkAttrs.get(attrName);
        if (reProgram == NO_REGEXP) {
            newAttrValue = this.createTransformedLink(oldAttrValue);
        } else {
            RE r = new RE((REProgram)reProgram);
            if (r.match(oldAttrValue)) {
                StringBuffer bufOut = new StringBuffer(oldAttrValue);
                int offset = 0;
                String link = null;
                String newLink = null;
                boolean modified = false;
                for (int i = 1; i < r.getParenCount(); ++i) {
                    link = r.getParen(i);
                    newLink = this.createTransformedLink(link);
                    if (newLink == null) continue;
                    bufOut.replace(r.getParenStart(i) + offset, r.getParenEnd(i) + offset, newLink);
                    offset += newLink.length() - r.getParenLength(i);
                    modified = true;
                }
                if (modified) {
                    newAttrValue = bufOut.toString();
                }
            }
        }
        return newAttrValue;
    }

    private String createTransformedLink(String oldLink) {
        String newLink;
        block9: {
            newLink = null;
            int i = oldLink.indexOf(":");
            if (i != -1) {
                String scheme = oldLink.substring(0, i);
                String addr = oldLink.substring(i + 1);
                if (this.outSchemes.contains(scheme)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Ignoring link '" + oldLink + "'"));
                    }
                } else if (this.inSchemes.contains(scheme) || this.inSchemes.size() == 0) {
                    try {
                        newLink = (String)this.modHelper.getAttribute(this.objectModel, this.getConf(scheme), scheme, addr, (Object)(this.badLinkStr != null ? this.badLinkStr : scheme + ":" + addr));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Converted link '" + oldLink + "' to '" + newLink + "'"));
                        }
                    }
                    catch (CascadingRuntimeException e) {
                        if (e.getCause() instanceof ConfigurationException) {
                            throw e;
                        }
                        if (!this.getLogger().isErrorEnabled()) break block9;
                        this.getLogger().error((Object)("Error rewriting link '" + oldLink + "': " + e.getMessage()));
                    }
                }
            }
        }
        return newLink;
    }

    private Configuration getConf(String scheme) {
        Configuration[] schemeConfs = this.conf.getChildren("input-module");
        for (int i = 0; i < schemeConfs.length; ++i) {
            if (!scheme.equals(schemeConfs[i].getAttribute("name", null))) continue;
            return schemeConfs[i];
        }
        return null;
    }

    public void dispose() {
        if (this.modHelper != null) {
            this.modHelper.releaseAll();
            this.modHelper = null;
        }
        super.dispose();
    }
}

