/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.javascript.JavaScriptFlowHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PipelineUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToStream(String uri, Object viewData, OutputStream output) throws IOException {
        Map objectModel = PipelineUtil.getObjectModel();
        ObjectModel newObjectModel = PipelineUtil.getNewObjectModel();
        SourceResolver resolver = PipelineUtil.getSourceResolver();
        Object oldViewData = FlowHelper.getContextObject((Map)objectModel);
        FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)JavaScriptFlowHelper.unwrap(viewData));
        Source src = null;
        InputStream input = null;
        try {
            src = resolver.resolveURI("cocoon:/" + uri);
            input = src.getInputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignored) {}
            }
            FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)oldViewData);
            resolver.release(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToSAX(String uri, Object viewData, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        Map objectModel = PipelineUtil.getObjectModel();
        ObjectModel newObjectModel = PipelineUtil.getNewObjectModel();
        SourceResolver resolver = PipelineUtil.getSourceResolver();
        Object oldViewData = FlowHelper.getContextObject((Map)objectModel);
        FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)JavaScriptFlowHelper.unwrap(viewData));
        Source src = null;
        try {
            src = resolver.resolveURI("cocoon:/" + uri);
            SourceUtil.toSAX((Source)src, (ContentHandler)handler);
        }
        catch (Throwable throwable) {
            FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)oldViewData);
            resolver.release(src);
            throw throwable;
        }
        FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)oldViewData);
        resolver.release(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document processToDOM(String uri, Object viewData) throws ProcessingException, SAXException, IOException {
        Document document;
        Map objectModel = PipelineUtil.getObjectModel();
        ObjectModel newObjectModel = PipelineUtil.getNewObjectModel();
        SourceResolver resolver = PipelineUtil.getSourceResolver();
        Object oldViewData = FlowHelper.getContextObject((Map)objectModel);
        FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)JavaScriptFlowHelper.unwrap(viewData));
        Source src = null;
        try {
            src = resolver.resolveURI("cocoon:/" + uri);
            document = SourceUtil.toDOM((Source)src);
        }
        catch (Throwable throwable) {
            FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)oldViewData);
            resolver.release(src);
            throw throwable;
        }
        FlowHelper.setContextObject((Map)objectModel, (ObjectModel)newObjectModel, (Object)oldViewData);
        resolver.release(src);
        return document;
    }

    protected static SourceResolver getSourceResolver() {
        WebApplicationContext webAppContext = WebAppContextUtils.getCurrentWebApplicationContext();
        return (SourceResolver)webAppContext.getBean(SourceResolver.ROLE);
    }

    protected static Map getObjectModel() {
        WebApplicationContext webAppContext = WebAppContextUtils.getCurrentWebApplicationContext();
        ProcessInfoProvider infoProvider = (ProcessInfoProvider)webAppContext.getBean(ProcessInfoProvider.ROLE);
        return infoProvider.getObjectModel();
    }

    protected static ObjectModel getNewObjectModel() {
        WebApplicationContext webAppContext = WebAppContextUtils.getCurrentWebApplicationContext();
        return (ObjectModel)webAppContext.getBean(ObjectModel.ROLE);
    }
}

