/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript.fom;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.flow.CompilingInterpreter;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.InvalidContinuationException;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.JSErrorReporter;
import org.apache.cocoon.components.flow.javascript.LocationTrackingDebugger;
import org.apache.cocoon.components.flow.javascript.ScriptablePointerFactory;
import org.apache.cocoon.components.flow.javascript.ScriptablePropertyHandler;
import org.apache.cocoon.components.flow.javascript.fom.FOM_Cocoon;
import org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptFlowHelper;
import org.apache.cocoon.components.flow.javascript.fom.FOM_WebContinuation;
import org.apache.cocoon.components.flow.util.PipelineUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.excalibur.source.Source;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.shell.Global;

public class FOM_JavaScriptInterpreter
extends CompilingInterpreter
implements Initializable {
    private static final String LAST_EXEC_TIME = "__PRIVATE_LAST_EXEC_TIME__";
    private static final String USER_GLOBAL_SCOPE = "FOM JavaScript GLOBAL SCOPE/";
    private static final int OPTIMIZATION_LEVEL = -1;
    private long lastReloadCheckTime;
    private Global scope;
    private List topLevelScripts = new ArrayList();
    private boolean enableDebugger;
    private static Main debugger;
    private static final int ENCODING_BUF_SIZE = 100;
    private static final REProgram encodingRE;

    static synchronized Main getDebugger() {
        if (debugger == null) {
            final Main db = new Main("Cocoon Flow Debugger");
            db.pack();
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            size.width = (int)((double)size.width * 0.75);
            size.height = (int)((double)size.height * 0.75);
            db.setSize(size.width, size.height);
            db.setExitAction(new Runnable(){

                @Override
                public void run() {
                    db.setVisible(false);
                }
            });
            db.setVisible(true);
            debugger = db;
            debugger.attachTo(ContextFactory.getGlobal());
        }
        return debugger;
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        String loadOnStartup = config.getChild("load-on-startup").getValue(null);
        if (loadOnStartup != null) {
            this.register(loadOnStartup);
        }
        String debugger = config.getChild("debugger").getValue(null);
        this.enableDebugger = "enabled".equalsIgnoreCase(debugger);
    }

    public void initialize() throws Exception {
        if (this.enableDebugger) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Flow debugger enabled, creating");
            }
            FOM_JavaScriptInterpreter.getDebugger().doBreak();
        }
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setGeneratingDebug(true);
        JXPathIntrospector.registerDynamicClass(Scriptable.class, ScriptablePropertyHandler.class);
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ScriptablePointerFactory());
        try {
            this.scope = new Global(context);
            FOM_Cocoon.init((Scriptable)this.scope);
        }
        catch (Exception e) {
            Context.exit();
            throw e;
        }
    }

    private ThreadScope getSessionScope() throws Exception {
        String scopeID = USER_GLOBAL_SCOPE + this.getInterpreterID();
        Request request = ObjectModelHelper.getRequest((Map)this.processInfoProvider.getObjectModel());
        HttpSession session = request.getSession(false);
        ThreadScope scope = session != null ? (ThreadScope)((Object)session.getAttribute(scopeID)) : (ThreadScope)((Object)request.getAttribute(scopeID));
        if (scope == null) {
            scope = this.createThreadScope();
            request.setAttribute(scopeID, (Object)scope);
        }
        return scope;
    }

    private void setSessionScope(ThreadScope scope) throws Exception {
        block3: {
            if (scope.useSession) {
                String scopeID = USER_GLOBAL_SCOPE + this.getInterpreterID();
                Request request = ObjectModelHelper.getRequest((Map)this.processInfoProvider.getObjectModel());
                try {
                    HttpSession session = request.getSession(true);
                    session.setAttribute(scopeID, (Object)scope);
                }
                catch (IllegalStateException e) {
                    if (!this.getLogger().isDebugEnabled()) break block3;
                    this.getLogger().debug((Object)("Got '" + e + "' while trying to set session scope."), (Throwable)e);
                }
            }
        }
    }

    private ThreadScope createThreadScope() throws Exception {
        return new ThreadScope(this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupContext(Redirector redirector, Context context, ThreadScope thrScope) throws Exception {
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        thrScope.setupPackages(contextClassloader);
        FOM_Cocoon cocoon = (FOM_Cocoon)((Object)thrScope.get("cocoon", (Scriptable)thrScope));
        cocoon.pushCallContext(this, redirector, this.avalonContext, null);
        long lastExecuted = (Long)thrScope.get(LAST_EXEC_TIME, (Scriptable)thrScope);
        ArrayList<CompilingInterpreter.ScriptSourceEntry> execList = new ArrayList<CompilingInterpreter.ScriptSourceEntry>();
        Map map = this.compiledScripts;
        synchronized (map) {
            CompilingInterpreter.ScriptSourceEntry entry;
            String sourceURI;
            int i;
            long now;
            boolean needsRefresh = false;
            if (this.reloadScripts && (now = System.currentTimeMillis()) >= this.lastReloadCheckTime + this.checkTime) {
                needsRefresh = true;
                this.lastReloadCheckTime = now;
            }
            ArrayList resolveList = new ArrayList();
            if (needsRefresh) {
                resolveList.addAll(this.topLevelScripts);
            }
            if (this.needResolve.size() > 0) {
                this.topLevelScripts.addAll(this.needResolve);
                resolveList.addAll(this.needResolve);
                this.needResolve.clear();
            }
            int size = resolveList.size();
            for (i = 0; i < size; ++i) {
                sourceURI = (String)resolveList.get(i);
                entry = (CompilingInterpreter.ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                if (entry == null) {
                    Source src = this.sourceresolver.resolveURI(sourceURI);
                    entry = new CompilingInterpreter.ScriptSourceEntry(this, src);
                    this.compiledScripts.put(sourceURI, entry);
                }
                entry.compile(context, (Scriptable)this.scope);
                if (lastExecuted == 0L) continue;
                execList.add(entry);
            }
            if (lastExecuted == 0L) {
                size = this.topLevelScripts.size();
                for (i = 0; i < size; ++i) {
                    sourceURI = (String)this.topLevelScripts.get(i);
                    entry = (CompilingInterpreter.ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                    if (entry == null) continue;
                    execList.add(entry);
                }
            }
        }
        boolean executed = false;
        int size = execList.size();
        for (int i = 0; i < size; ++i) {
            CompilingInterpreter.ScriptSourceEntry entry = (CompilingInterpreter.ScriptSourceEntry)execList.get(i);
            if (lastExecuted != 0L && entry.getCompileTime() <= lastExecuted) continue;
            entry.getScript().exec(context, (Scriptable)thrScope);
            executed = true;
        }
        if (executed) {
            thrScope.onExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Script compileScript(Context cx, String fileName) throws Exception {
        Source src = this.sourceresolver.resolveURI(fileName);
        Map map = this.compiledScripts;
        synchronized (map) {
            CompilingInterpreter.ScriptSourceEntry entry = (CompilingInterpreter.ScriptSourceEntry)this.compiledScripts.get(src.getURI());
            if (entry == null) {
                entry = new CompilingInterpreter.ScriptSourceEntry(this, src);
                this.compiledScripts.put(src.getURI(), entry);
            } else {
                this.sourceresolver.release(src);
            }
            long compileTime = entry.getCompileTime();
            if (compileTime == 0L || this.reloadScripts && compileTime + this.checkTime < System.currentTimeMillis()) {
                entry.compile(cx, (Scriptable)this.scope);
            }
            return entry.getScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Script compileScript(Context cx, Scriptable scope, Source src) throws Exception {
        PushbackInputStream is = new PushbackInputStream(src.getInputStream(), 100);
        try {
            String encoding = this.findEncoding(is);
            Reader reader = encoding == null ? new InputStreamReader(is) : new InputStreamReader((InputStream)is, encoding);
            reader = new BufferedReader(reader);
            Script script = cx.compileReader(reader, src.getURI(), 1, null);
            return script;
        }
        finally {
            is.close();
        }
    }

    String findEncoding(PushbackInputStream is) throws IOException {
        byte[] buffer = new byte[100];
        int len = is.read(buffer, 0, buffer.length);
        is.unread(buffer, 0, len);
        String str = new String(buffer, 0, len, "ASCII");
        RE re = new RE(encodingRE);
        if (re.match(str)) {
            return re.getParen(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callFunction(String funName, List params, Redirector redirector) throws Exception {
        ThreadScope thrScope;
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setErrorReporter((ErrorReporter)new JSErrorReporter());
        LocationTrackingDebugger locationTracker = new LocationTrackingDebugger();
        if (!this.enableDebugger) {
            context.setDebugger((Debugger)locationTracker, null);
        }
        ThreadScope threadScope = thrScope = this.getSessionScope();
        synchronized (threadScope) {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            FOM_Cocoon cocoon = null;
            try {
                try {
                    Object fun;
                    this.setupContext(redirector, context, thrScope);
                    cocoon = (FOM_Cocoon)((Object)thrScope.get("cocoon", (Scriptable)thrScope));
                    FOM_JavaScriptFlowHelper.setFOM_FlowScope(cocoon.getObjectModel(), (Scriptable)thrScope);
                    if (this.enableDebugger && !FOM_JavaScriptInterpreter.getDebugger().isVisible()) {
                        FOM_JavaScriptInterpreter.getDebugger().setVisible(true);
                    }
                    int size = params != null ? params.size() : 0;
                    Scriptable parameters = context.newObject((Scriptable)thrScope);
                    for (int i = 0; i < size; ++i) {
                        Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                        if (arg.name == null) {
                            arg.name = "";
                        }
                        parameters.put(arg.name, parameters, (Object)arg.value);
                    }
                    cocoon.setParameters(parameters);
                    try {
                        fun = context.compileString(funName, null, 1, null).exec(context, (Scriptable)thrScope);
                    }
                    catch (EcmaError ee) {
                        throw new ResourceNotFoundException("Function \"javascript:" + funName + "()\" not found");
                    }
                    thrScope.setLock(true);
                    ScriptRuntime.call((Context)context, (Object)fun, (Object)((Object)thrScope), (Object[])new Object[0], (Scriptable)thrScope);
                }
                catch (JavaScriptException e) {
                    throw locationTracker.getException("Error calling flowscript function " + funName, (Exception)((Object)e));
                }
                catch (EcmaError e) {
                    throw locationTracker.getException("Error calling function " + funName, (Exception)((Object)e));
                }
                catch (WrappedException e) {
                    throw locationTracker.getException("Error calling function " + funName, (Exception)((Object)e));
                }
            }
            finally {
                thrScope.setLock(false);
                this.setSessionScope(thrScope);
                if (cocoon != null) {
                    cocoon.popCallContext();
                }
                Context.exit();
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleContinuation(String id, List params, Redirector redirector) throws Exception {
        ThreadScope kScope;
        WebContinuation wk = this.continuationsMgr.lookupWebContinuation(id, this.getInterpreterID());
        if (wk == null) {
            throw new InvalidContinuationException("The continuation ID " + id + " is invalid.");
        }
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        LocationTrackingDebugger locationTracker = new LocationTrackingDebugger();
        if (!this.enableDebugger) {
            context.setDebugger((Debugger)locationTracker, null);
        }
        Continuation k = (Continuation)wk.getContinuation();
        ThreadScope threadScope = kScope = (ThreadScope)k.getParentScope();
        synchronized (threadScope) {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            FOM_Cocoon cocoon = null;
            try {
                Thread.currentThread().setContextClassLoader(kScope.getClassLoader());
                cocoon = (FOM_Cocoon)((Object)kScope.get("cocoon", (Scriptable)kScope));
                kScope.setLock(true);
                cocoon.pushCallContext(this, redirector, this.avalonContext, wk);
                FOM_JavaScriptFlowHelper.setFOM_FlowScope(cocoon.getObjectModel(), (Scriptable)kScope);
                if (this.enableDebugger) {
                    FOM_JavaScriptInterpreter.getDebugger().setVisible(true);
                }
                Scriptable parameters = context.newObject((Scriptable)kScope);
                int size = params != null ? params.size() : 0;
                for (int i = 0; i < size; ++i) {
                    Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                    parameters.put(arg.name, parameters, (Object)arg.value);
                }
                cocoon.setParameters(parameters);
                FOM_WebContinuation fom_wk = new FOM_WebContinuation(wk);
                fom_wk.setLogger(this.getLogger());
                fom_wk.setParentScope((Scriptable)kScope);
                fom_wk.setPrototype(ScriptableObject.getClassPrototype((Scriptable)kScope, (String)fom_wk.getClassName()));
                Object[] args = new Object[]{k, fom_wk};
                try {
                    ScriptableObject.callMethod((Scriptable)cocoon, (String)"handleContinuation", (Object[])args);
                }
                catch (JavaScriptException e) {
                    throw locationTracker.getException("Error calling continuation", (Exception)((Object)e));
                }
                catch (EcmaError e) {
                    throw locationTracker.getException("Error calling continuation", (Exception)((Object)e));
                }
                catch (WrappedException e) {
                    throw locationTracker.getException("Error calling continuation", (Exception)((Object)e));
                }
            }
            finally {
                kScope.setLock(false);
                this.setSessionScope(kScope);
                if (cocoon != null) {
                    cocoon.popCallContext();
                }
                Context.exit();
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    public void forwardTo(Scriptable scope, FOM_Cocoon cocoon, String uri, Object bizData, FOM_WebContinuation fom_wk, Redirector redirector) throws Exception {
        this.setupView(scope, cocoon, fom_wk);
        super.forwardTo(uri, bizData, fom_wk == null ? null : fom_wk.getWebContinuation(), redirector);
    }

    void process(Scriptable scope, FOM_Cocoon cocoon, String uri, Object bizData, OutputStream out) throws Exception {
        this.setupView(scope, cocoon, null);
        PipelineUtil pipeUtil = new PipelineUtil();
        pipeUtil.processToStream(uri, bizData, out);
    }

    private void setupView(Scriptable scope, FOM_Cocoon cocoon, FOM_WebContinuation kont) {
        Map objectModel = this.processInfoProvider.getObjectModel();
        FOM_JavaScriptFlowHelper.setPackages(objectModel, (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"Packages"));
        FOM_JavaScriptFlowHelper.setJavaPackage(objectModel, (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"java"));
        FOM_JavaScriptFlowHelper.setFOM_Request(objectModel, cocoon.jsGet_request());
        FOM_JavaScriptFlowHelper.setFOM_Response(objectModel, cocoon.jsGet_response());
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Scriptable session = null;
        if (request.getSession(false) != null) {
            session = cocoon.jsGet_session();
        }
        FOM_JavaScriptFlowHelper.setFOM_Session(objectModel, session);
        FOM_JavaScriptFlowHelper.setFOM_Context(objectModel, cocoon.jsGet_context());
        if (kont != null) {
            FOM_JavaScriptFlowHelper.setFOM_WebContinuation(objectModel, (Scriptable)kont);
        }
    }

    public String getScriptExtension() {
        return ".js";
    }

    static {
        encodingRE = new RECompiler().compile("encoding\\s*=\\s*([^\\s]*)");
    }

    public static class ThreadScope
    extends ScriptableObject {
        private static final String[] BUILTIN_PACKAGES = new String[]{"javax", "org", "com"};
        private static final String[] BUILTIN_FUNCTIONS = new String[]{"importClass"};
        private ClassLoader classLoader;
        boolean useSession;
        boolean locked;

        public ThreadScope(Global scope) throws Exception {
            Context context = Context.getCurrentContext();
            this.defineFunctionProperties(BUILTIN_FUNCTIONS, ThreadScope.class, 2);
            this.setPrototype((Scriptable)scope);
            this.setParentScope(null);
            Object[] args = new Object[]{};
            FOM_Cocoon cocoon = (FOM_Cocoon)context.newObject((Scriptable)this, "FOM_Cocoon", args);
            cocoon.setParentScope((Scriptable)this);
            super.put("cocoon", (Scriptable)this, (Object)cocoon);
            this.defineProperty(FOM_JavaScriptInterpreter.LAST_EXEC_TIME, new Long(0L), 6);
        }

        public String getClassName() {
            return "ThreadScope";
        }

        public void setLock(boolean lock) {
            this.locked = lock;
        }

        public void put(String name, Scriptable start, Object value) {
            if (this.locked && !this.has(name, start) && !(value instanceof NativeJavaClass) && !(value instanceof Function)) {
                throw new WrappedException((Throwable)new RuntimeException("Implicit declaration of global variable '" + name + "' forbidden. Please ensure all variables are explicitely declared with the 'var' keyword"));
            }
            this.useSession = true;
            super.put(name, start, value);
        }

        public void put(int index, Scriptable start, Object value) {
            if (this.locked && !this.has(index, start)) {
                throw new WrappedException((Throwable)new RuntimeException("Global scope locked. Cannot set value for index " + index));
            }
            this.useSession = true;
            super.put(index, start, value);
        }

        void onExec() {
            this.useSession = false;
            super.put(FOM_JavaScriptInterpreter.LAST_EXEC_TIME, (Scriptable)this, (Object)new Long(System.currentTimeMillis()));
        }

        public static void importClass(Context ctx, Scriptable thisObj, Object[] args, Function funObj) {
            for (int i = 0; i < args.length; ++i) {
                Object clazz = args[i];
                if (!(clazz instanceof NativeJavaClass)) {
                    throw Context.reportRuntimeError((String)("Not a Java class: " + Context.toString((Object)clazz)));
                }
                String s = ((NativeJavaClass)clazz).getClassObject().getName();
                String n = s.substring(s.lastIndexOf(46) + 1);
                thisObj.put(n, thisObj, clazz);
            }
        }

        public void setupPackages(ClassLoader cl) throws Exception {
            String JAVA_PACKAGE = "JavaPackage";
            if (this.classLoader != cl) {
                this.classLoader = cl;
                NativeJavaPackage newPackages = new NativeJavaPackage("", cl);
                newPackages.setParentScope((Scriptable)this);
                newPackages.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this, (String)"JavaPackage"));
                super.put("Packages", (Scriptable)this, (Object)newPackages);
                for (int i = 0; i < BUILTIN_PACKAGES.length; ++i) {
                    String pkgName = BUILTIN_PACKAGES[i];
                    NativeJavaPackage pkg = new NativeJavaPackage(pkgName, cl);
                    pkg.setParentScope((Scriptable)this);
                    pkg.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this, (String)"JavaPackage"));
                    super.put(pkgName, (Scriptable)this, (Object)pkg);
                }
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

