/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.expression;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.cocoon.el.ExpressionFactory;
import org.apache.cocoon.el.parsing.StringTemplateParser;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.expression.JXTExpression;
import org.apache.cocoon.template.expression.Literal;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractStringTemplateParser
implements StringTemplateParser {
    private ExpressionFactory expressionFactory;

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    protected Subst compile(String expression) throws Exception {
        return new JXTExpression(expression, this.expressionFactory.getExpression(expression));
    }

    protected Subst compile(String expression, String language) throws Exception {
        return new JXTExpression(expression, this.expressionFactory.getExpression(language, expression));
    }

    public Subst compileBoolean(String val, String msg, Locator location) throws SAXException {
        Subst res = this.compileExpr(val, msg, location);
        if (res instanceof Literal) {
            res = new Literal(Boolean.valueOf(res.getRaw()));
        }
        return res;
    }

    public Subst compileInt(String val, String msg, Locator location) throws SAXException {
        Subst res = this.compileExpr(val, msg, location);
        if (res instanceof Literal) {
            res = new Literal(Integer.valueOf(res.getRaw()));
        }
        return res;
    }

    public Subst compileExpr(String inStr, String errorPrefix, Locator location) throws SAXParseException {
        if (inStr == null) {
            return null;
        }
        StringReader in = new StringReader(inStr.trim());
        List substitutions = this.parseSubstitutions(in, errorPrefix, location);
        if (substitutions.size() == 0 || !(substitutions.get(0) instanceof JXTExpression)) {
            return new Literal(inStr);
        }
        return (JXTExpression)substitutions.get(0);
    }

    public List parseSubstitutions(Reader in, String errorPrefix, Locator location) throws SAXParseException {
        try {
            return this.parseSubstitutions(in);
        }
        catch (Exception e) {
            throw new SAXParseException(errorPrefix + e.getMessage(), location, e);
        }
    }

    protected abstract List parseSubstitutions(Reader var1) throws Exception;
}

