/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.blockdeployment;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.cocoon.blockdeployment.DeploymentUtil;

public class BlockDeploymentServletContextListener
implements ServletContextListener {
    public static final String BLOCK_CONTEXT_MAP = BlockDeploymentServletContextListener.class.getName() + "/" + "block-context-map";

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext servletContext = sce.getServletContext();
            Map<String, String> blocks = DeploymentUtil.deployBlockArtifacts(this.getWorkdir(servletContext).getAbsolutePath());
            servletContext.setAttribute(BLOCK_CONTEXT_MAP, blocks);
        }
        catch (IOException e) {
            throw new RuntimeException("The available Cocoon blocks can't be deployed.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        sce.getServletContext().removeAttribute(BLOCK_CONTEXT_MAP);
    }

    private File getWorkdir(ServletContext servletContext) {
        File workdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workdir == null) {
            workdir = new File("cocoon-files");
        }
        return workdir;
    }
}

