/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.blockdeployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.cocoon.blockdeployment.BlockContextInitializationException;
import org.apache.cocoon.blockdeployment.BlockDeploymentServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockContextURLConnection
extends URLConnection {
    private final Map<String, String> blockContexts;
    private URLConnection urlConnection;

    protected BlockContextURLConnection(URL url, Map<String, String> blockContexts) {
        super(url);
        if (blockContexts == null) {
            throw new BlockContextInitializationException("There are no block contexts available. Make sure that the " + BlockDeploymentServletContextListener.class.getName() + " is configured correctly in the web.xml.");
        }
        this.blockContexts = blockContexts;
        this.url = url;
    }

    @Override
    public void connect() throws IOException {
        this.getConnection().connect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getConnection().getInputStream();
    }

    private URLConnection getConnection() {
        if (this.urlConnection == null) {
            URL resolvedPath = null;
            String location = this.url.toExternalForm();
            int pos = location.indexOf(":/");
            String path = location.substring(pos + 2);
            if ((pos = path.indexOf(47)) != -1) {
                String blockName = path.substring(0, pos);
                path = path.substring(pos + 1);
                String blockContext = this.blockContexts.get(blockName);
                if (blockContext == null) {
                    throw new RuntimeException("There is no block '" + blockName + "' deployed. The available blocks are " + this.blockContexts + ".");
                }
                try {
                    resolvedPath = new URL(new URL(blockContext), path);
                    this.urlConnection = resolvedPath.openConnection();
                }
                catch (IOException e) {
                    throw new RuntimeException("Can create URL for '" + blockContext + path + "'.'");
                }
            } else {
                throw new RuntimeException("The block name part of a block context uri must end with a '/' in " + location);
            }
        }
        return this.urlConnection;
    }

    @Override
    public long getLastModified() {
        return this.getConnection().getLastModified();
    }
}

