/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.awt.Color;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.transcoder.ExtendableTranscoderFactory;
import org.apache.cocoon.components.transcoder.TranscoderFactory;
import org.apache.cocoon.components.url.ParsedContextURLProtocolHandler;
import org.apache.cocoon.components.url.ParsedResourceURLProtocolHandler;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.xml.dom.SVGBuilder;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SVGSerializer
extends SVGBuilder
implements Contextualizable,
Configurable,
CacheableProcessingComponent,
Serializer {
    private OutputStream output;
    private String mimetype;
    Transcoder transcoder;
    TranscoderFactory factory = ExtendableTranscoderFactory.getTranscoderFactoryImplementation();

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        ParsedContextURLProtocolHandler.setContext((Context)context.get((Object)"environment-context"));
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new ParsedContextURLProtocolHandler());
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new ParsedResourceURLProtocolHandler());
    }

    public void setOutputStream(OutputStream out) {
        this.output = out;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String name;
        int i;
        this.mimetype = conf.getAttribute("mime-type");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("mime-type: " + this.mimetype));
        }
        this.transcoder = this.factory.createTranscoder(this.mimetype);
        Configuration[] parameters = conf.getChildren("parameter");
        for (i = 0; i < parameters.length; ++i) {
            name = parameters[i].getAttribute("name");
            if (!"transcoder".equals(name)) continue;
            String transcoderName = parameters[i].getAttribute("value");
            try {
                this.transcoder = (Transcoder)ClassUtils.newInstance((String)transcoderName);
                continue;
            }
            catch (Exception ex) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Cannot load  class " + transcoderName), (Throwable)ex);
                }
                throw new ConfigurationException("Cannot load class " + transcoderName, (Throwable)ex);
            }
        }
        if (this.transcoder == null) {
            throw new ConfigurationException("Could not autodetect transcoder for SVGSerializer and no transcoder was specified in the sitemap configuration.");
        }
        for (i = 0; i < parameters.length; ++i) {
            name = parameters[i].getAttribute("name");
            if ("transcoder".equals(name)) continue;
            try {
                Object value;
                name = ("KEY_" + name).toUpperCase();
                TranscodingHints.Key key = (TranscodingHints.Key)this.transcoder.getClass().getField(name).get(this.transcoder);
                String keyType = parameters[i].getAttribute("type", "STRING").toUpperCase();
                if ("FLOAT".equals(keyType)) {
                    value = new Float(parameters[i].getAttributeAsFloat("value"));
                } else if ("INTEGER".equals(keyType)) {
                    value = new Integer(parameters[i].getAttributeAsInteger("value"));
                } else if ("BOOLEAN".equals(keyType)) {
                    value = parameters[i].getAttributeAsBoolean("value");
                } else if ("COLOR".equals(keyType)) {
                    String stringValue = parameters[i].getAttribute("value");
                    if (stringValue.startsWith("#")) {
                        stringValue = stringValue.substring(1);
                    }
                    value = new Color(Integer.parseInt(stringValue, 16));
                } else {
                    value = parameters[i].getAttribute("value", "");
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Adding hint \"" + name + "\" with value \"" + value.toString() + "\""));
                }
                this.transcoder.addTranscodingHint(key, value);
                continue;
            }
            catch (ClassCastException ex) {
                throw new ConfigurationException("Specified key (" + name + ") is not a valid Batik Transcoder key.", (Throwable)ex);
            }
            catch (ConfigurationException ex) {
                throw new ConfigurationException("Name or value not specified.", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Cannot access the key for parameter \"" + name + "\"", (Throwable)ex);
            }
            catch (NoSuchFieldException ex) {
                throw new ConfigurationException("No field available for parameter \"" + name + "\"", (Throwable)ex);
            }
        }
    }

    @Override
    public void notify(Document doc) throws SAXException {
        try {
            TranscoderInput transInput = new TranscoderInput(doc);
            TranscoderOutput transOutput = new TranscoderOutput(this.output);
            this.transcoder.transcode(transInput, transOutput);
        }
        catch (TranscoderException ex) {
            if (ex.getException() != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Got transcoder exception writing image, rethrowing nested exception", (Throwable)ex);
                }
                throw new SAXException("Exception writing image", ex.getException());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Got transcoder exception writing image, rethrowing", (Throwable)ex);
            }
            throw new SAXException("Exception writing image", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Got exception writing image, rethrowing", (Throwable)ex);
            }
            throw new SAXException("Exception writing image", ex);
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public boolean shouldSetContentLength() {
        return true;
    }
}

