/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.customproperty;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.apache.clerezza.platform.graphprovider.content.ContentGraphProvider;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.ontologies.DCTERMS;
import org.apache.clerezza.rdf.ontologies.RDF;
import org.apache.clerezza.utils.customproperty.ontology.CUSTOMPROPERTY;

public class CustomProperty {
    private ContentGraphProvider cgProvider;

    public boolean addSingleCustomField(UriRef dependency, String dependencyValue, String label, UriRef property, int length, int cardinality) {
        return this.addSingleCustomField(dependency, dependencyValue, label, null, null, property, length, cardinality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSingleCustomField(UriRef dependency, String dependencyValue, String label, String description, String config, UriRef property, int length, int cardinality) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        NonLiteral customfield = this.addBasicCustomField(contentGraph, property, cardinality, label, description, config, this.getCustomPropertyCollection(dependency, dependencyValue));
        Lock lock = contentGraph.getLock().writeLock();
        lock.lock();
        try {
            if (customfield != null) {
                contentGraph.add((Object)new TripleImpl(customfield, CUSTOMPROPERTY.length, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)length)));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean addMultipleCustomField(UriRef dependency, String dependencyValue, String label, UriRef property, String multiselect, String selectableValues, int cardinality) {
        return this.addMultipleCustomField(dependency, dependencyValue, label, null, null, property, multiselect, selectableValues, cardinality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMultipleCustomField(UriRef dependency, String dependencyValue, String label, String description, String config, UriRef property, String multiselect, String selectableValues, int cardinality) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        NonLiteral customfield = this.addBasicCustomField(contentGraph, property, cardinality, label, description, config, this.getCustomPropertyCollection(dependency, dependencyValue));
        Lock lock = contentGraph.getLock().writeLock();
        lock.lock();
        try {
            if (customfield != null) {
                ArrayList<TripleImpl> tripleArray = new ArrayList<TripleImpl>();
                String[] values = selectableValues.split(",");
                for (int i = 0; i < values.length; ++i) {
                    tripleArray.add(new TripleImpl(customfield, CUSTOMPROPERTY.value, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)values[i])));
                }
                tripleArray.add(new TripleImpl(customfield, CUSTOMPROPERTY.multiselectable, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)multiselect)));
                contentGraph.addAll(tripleArray);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NonLiteral addBasicCustomField(LockableMGraph contentGraph, UriRef property, int cardinality, String label, String description, String config, NonLiteral propertyCollection) {
        Lock lock = contentGraph.getLock().writeLock();
        lock.lock();
        try {
            if (contentGraph.filter(null, CUSTOMPROPERTY.property, (Resource)property).hasNext()) {
                NonLiteral nonLiteral = null;
                return nonLiteral;
            }
            ArrayList<TripleImpl> tripleArray = new ArrayList<TripleImpl>();
            BNode customField = new BNode();
            contentGraph.add((Object)new TripleImpl((NonLiteral)customField, CUSTOMPROPERTY.property, (Resource)property));
            tripleArray.add(new TripleImpl(propertyCollection, CUSTOMPROPERTY.customfield, (Resource)customField));
            tripleArray.add(new TripleImpl((NonLiteral)customField, RDF.type, (Resource)CUSTOMPROPERTY.CustomField));
            tripleArray.add(new TripleImpl((NonLiteral)customField, CUSTOMPROPERTY.cardinality, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)cardinality)));
            tripleArray.add(new TripleImpl((NonLiteral)customField, CUSTOMPROPERTY.presentationlabel, (Resource)new PlainLiteralImpl(label)));
            if (description != null && !description.isEmpty()) {
                tripleArray.add(new TripleImpl((NonLiteral)customField, DCTERMS.description, (Resource)new PlainLiteralImpl(description)));
            }
            if (config != null && !config.isEmpty()) {
                tripleArray.add(new TripleImpl((NonLiteral)customField, CUSTOMPROPERTY.configuration, (Resource)new PlainLiteralImpl(config)));
            }
            if (contentGraph.addAll(tripleArray)) {
                BNode bNode = customField;
                return bNode;
            }
            NonLiteral nonLiteral = null;
            return nonLiteral;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonLiteral getCustomPropertyCollection(UriRef dependency, String dependencyValue) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        Lock lock = contentGraph.getLock().readLock();
        lock.lock();
        try {
            Iterator collections = contentGraph.filter(null, RDF.type, (Resource)CUSTOMPROPERTY.CustomFieldCollection);
            while (collections.hasNext()) {
                Iterator collections2 = contentGraph.filter(((Triple)collections.next()).getSubject(), CUSTOMPROPERTY.dependency, (Resource)dependency);
                while (collections2.hasNext()) {
                    Iterator collections3 = contentGraph.filter(((Triple)collections2.next()).getSubject(), CUSTOMPROPERTY.dependencyvalue, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)dependencyValue));
                    if (!collections3.hasNext()) continue;
                    NonLiteral nonLiteral = ((Triple)collections3.next()).getSubject();
                    return nonLiteral;
                }
            }
        }
        finally {
            lock.unlock();
        }
        lock = contentGraph.getLock().writeLock();
        lock.lock();
        try {
            ArrayList<TripleImpl> tripleArray = new ArrayList<TripleImpl>();
            BNode cfc = new BNode();
            tripleArray.add(new TripleImpl((NonLiteral)cfc, RDF.type, (Resource)CUSTOMPROPERTY.CustomFieldCollection));
            tripleArray.add(new TripleImpl((NonLiteral)cfc, CUSTOMPROPERTY.dependency, (Resource)dependency));
            tripleArray.add(new TripleImpl((NonLiteral)cfc, CUSTOMPROPERTY.dependencyvalue, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)dependencyValue)));
            contentGraph.addAll(tripleArray);
            NonLiteral nonLiteral = this.getCustomPropertyCollection(dependency, dependencyValue);
            return nonLiteral;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NonLiteral> getCustomfieldsOfCollection(NonLiteral collection) {
        ArrayList<NonLiteral> customfields = new ArrayList<NonLiteral>();
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        Lock lock = contentGraph.getLock().readLock();
        lock.lock();
        try {
            Iterator result = contentGraph.filter(collection, CUSTOMPROPERTY.customfield, null);
            while (result.hasNext()) {
                customfields.add((NonLiteral)((Triple)result.next()).getObject());
            }
            ArrayList<NonLiteral> arrayList = customfields;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<UriRef> getPropertiesOfCollection(NonLiteral collection) {
        ArrayList<UriRef> customproperties = new ArrayList<UriRef>();
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        Lock lock = contentGraph.getLock().readLock();
        lock.lock();
        try {
            Iterator result = contentGraph.filter(collection, CUSTOMPROPERTY.customfield, null);
            while (result.hasNext()) {
                Iterator property = contentGraph.filter((NonLiteral)((Triple)result.next()).getObject(), CUSTOMPROPERTY.property, null);
                if (!property.hasNext()) continue;
                customproperties.add((UriRef)((Triple)property.next()).getObject());
            }
            ArrayList<UriRef> arrayList = customproperties;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCustomField(UriRef dependency, String dependencyValue, UriRef property) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        ArrayList allCustomFieldTriples = new ArrayList();
        Iterator customfields = contentGraph.filter(this.getCustomPropertyCollection(dependency, dependencyValue), CUSTOMPROPERTY.customfield, null);
        boolean customFieldDelete = false;
        Lock lock = contentGraph.getLock().writeLock();
        lock.lock();
        try {
            while (customfields.hasNext()) {
                Iterator customfields2 = contentGraph.filter((NonLiteral)((Triple)customfields.next()).getObject(), CUSTOMPROPERTY.property, (Resource)property);
                if (!customfields2.hasNext()) continue;
                NonLiteral customField = ((Triple)customfields2.next()).getSubject();
                Iterator someCustomfieldTriples = contentGraph.filter(customField, null, null);
                while (someCustomfieldTriples.hasNext()) {
                    allCustomFieldTriples.add(someCustomfieldTriples.next());
                }
                Iterator otherCustomFieldTriples = contentGraph.filter(null, null, (Resource)customField);
                while (otherCustomFieldTriples.hasNext()) {
                    allCustomFieldTriples.add(otherCustomFieldTriples.next());
                }
                customFieldDelete = true;
            }
            contentGraph.removeAll(allCustomFieldTriples);
        }
        finally {
            lock.unlock();
        }
        return customFieldDelete;
    }

    public UriRef getCustomFieldProperty(NonLiteral customfield) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        return (UriRef)((Triple)contentGraph.filter(customfield, CUSTOMPROPERTY.property, null).next()).getObject();
    }

    protected void bindCgProvider(ContentGraphProvider cgProvider) {
        this.cgProvider = cgProvider;
    }

    protected void unbindCgProvider(ContentGraphProvider cgProvider) {
        this.cgProvider = null;
    }
}

