/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.StringListBuilder;

public class QueryStatementImpl
implements QueryStatement,
Cloneable {
    private final Session session;
    private final String statement;
    private final Map<Integer, String> parametersMap = new HashMap<Integer, String>();

    public QueryStatementImpl(Session session, String statement) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Statement must be set!");
        }
        this.session = session;
        this.statement = statement.trim();
    }

    public QueryStatementImpl(Session session, Collection<String> selectPropertyIds, Map<String, String> fromTypes, String whereClause, List<String> orderByPropertyIds) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (CollectionsHelper.isNullOrEmpty(fromTypes)) {
            throw new IllegalArgumentException("Types must be set!");
        }
        this.session = session;
        StringBuilder stmt = new StringBuilder(1024);
        ObjectType primaryType = null;
        String primaryAlias = null;
        HashMap<String, ObjectType> types = new HashMap<String, ObjectType>();
        for (Map.Entry<String, String> entry : fromTypes.entrySet()) {
            ObjectType objectType = session.getTypeDefinition(entry.getValue());
            if (Boolean.FALSE.equals(objectType.isQueryable())) {
                throw new IllegalArgumentException("Type '" + entry.getValue() + "' is not queryable!");
            }
            String alias = entry.getKey().trim();
            if (alias.length() < 1) {
                throw new IllegalArgumentException("Invalid alias for type '" + entry.getValue() + "'!");
            }
            if (objectType.getBaseTypeId() != BaseTypeId.CMIS_SECONDARY) {
                if (primaryType == null) {
                    primaryType = objectType;
                    primaryAlias = alias;
                } else {
                    throw new IllegalArgumentException("Two primary types found: " + primaryType.getId() + " and " + objectType.getId());
                }
            }
            if (!CollectionsHelper.isNotEmpty((Map)objectType.getPropertyDefinitions())) continue;
            types.put(alias, objectType);
        }
        if (primaryType == null) {
            throw new IllegalArgumentException("No primary type found!");
        }
        stmt.append("SELECT ");
        StringListBuilder selectList = new StringListBuilder(",", stmt);
        if (CollectionsHelper.isNullOrEmpty(selectPropertyIds)) {
            for (String string : types.keySet()) {
                selectList.add(string + ".*");
            }
        } else {
            for (String string : selectPropertyIds) {
                String string2 = string.trim();
                if (string2.equals("*")) {
                    for (String alias : types.keySet()) {
                        selectList.add(alias + ".*");
                    }
                    continue;
                }
                if (string2.endsWith(".*")) {
                    String starAlias = string2.substring(0, string2.length() - 2);
                    if (types.containsKey(starAlias)) {
                        selectList.add(starAlias + ".*");
                        continue;
                    }
                    throw new IllegalArgumentException("Alias '" + starAlias + "' is not defined!");
                }
                PropertyDefinition propertyDef = null;
                String alias2 = null;
                for (Map.Entry te : types.entrySet()) {
                    propertyDef = (PropertyDefinition)((ObjectType)te.getValue()).getPropertyDefinitions().get(string2);
                    if (propertyDef == null) continue;
                    alias2 = (String)te.getKey();
                    break;
                }
                if (propertyDef == null) {
                    throw new IllegalArgumentException("Property '" + string2 + "' is not defined in the provided object types!");
                }
                if (propertyDef.getQueryName() == null) {
                    throw new IllegalArgumentException("Property '" + string2 + "' has no query name!");
                }
                selectList.add(alias2 + "." + propertyDef.getQueryName());
            }
        }
        stmt.append(" FROM ");
        stmt.append(primaryType.getQueryName());
        stmt.append(" AS ");
        stmt.append(primaryAlias);
        for (Map.Entry entry : types.entrySet()) {
            if (((String)entry.getKey()).equals(primaryAlias)) continue;
            stmt.append(" JOIN ");
            stmt.append(((ObjectType)entry.getValue()).getQueryName());
            stmt.append(" AS ");
            stmt.append((String)entry.getKey());
            stmt.append(" ON ");
            stmt.append(primaryAlias);
            stmt.append(".cmis:objectId=");
            stmt.append((String)entry.getKey());
            stmt.append(".cmis:objectId");
        }
        if (whereClause != null && whereClause.trim().length() > 0) {
            stmt.append(" WHERE ");
            stmt.append(whereClause.trim());
        }
        if (CollectionsHelper.isNotEmpty(orderByPropertyIds)) {
            stmt.append(" ORDER BY ");
            StringListBuilder stringListBuilder = new StringListBuilder(",", stmt);
            for (String propertyId : orderByPropertyIds) {
                String realPropertyId = propertyId.trim();
                String realPropertyIdLower = realPropertyId.toLowerCase(Locale.ENGLISH);
                boolean desc = false;
                if (realPropertyIdLower.endsWith(" asc")) {
                    realPropertyId = realPropertyId.substring(0, realPropertyId.length() - 4);
                }
                if (realPropertyIdLower.endsWith(" desc")) {
                    realPropertyId = realPropertyId.substring(0, realPropertyId.length() - 5);
                    desc = true;
                }
                PropertyDefinition propertyDef = null;
                String alias = null;
                for (Map.Entry te : types.entrySet()) {
                    propertyDef = (PropertyDefinition)((ObjectType)te.getValue()).getPropertyDefinitions().get(realPropertyId);
                    if (propertyDef == null) continue;
                    alias = (String)te.getKey();
                    break;
                }
                if (propertyDef == null) {
                    throw new IllegalArgumentException("Property '" + realPropertyId + "' is not defined in the provided object types!");
                }
                if (propertyDef.getQueryName() == null) {
                    throw new IllegalArgumentException("Property '" + realPropertyId + "' has no query name!");
                }
                if (Boolean.FALSE.equals(propertyDef.isOrderable())) {
                    throw new IllegalArgumentException("Property '" + realPropertyId + "' is not orderable!");
                }
                stringListBuilder.add(alias + "." + propertyDef.getQueryName() + (desc ? " DESC" : ""));
            }
        }
        this.statement = stmt.toString();
    }

    public void setType(int parameterIndex, String typeId) {
        this.setType(parameterIndex, this.session.getTypeDefinition(typeId));
    }

    public void setType(int parameterIndex, ObjectType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        String queryName = type.getQueryName();
        if (queryName == null) {
            throw new IllegalArgumentException("Type has no query name!");
        }
        this.parametersMap.put(parameterIndex, queryName);
    }

    public void setProperty(int parameterIndex, String typeId, String propertyId) {
        ObjectType type = this.session.getTypeDefinition(typeId);
        PropertyDefinition propertyDefinition = (PropertyDefinition)type.getPropertyDefinitions().get(propertyId);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Property does not exist!");
        }
        this.setProperty(parameterIndex, propertyDefinition);
    }

    public void setProperty(int parameterIndex, PropertyDefinition<?> propertyDefinition) {
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Property must be set!");
        }
        String queryName = propertyDefinition.getQueryName();
        if (queryName == null) {
            throw new IllegalArgumentException("Property has no query name!");
        }
        this.parametersMap.put(parameterIndex, queryName);
    }

    public void setNumber(int parameterIndex, Number ... num) {
        if (num == null || num.length == 0) {
            throw new IllegalArgumentException("Number must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (Number n : num) {
            if (n == null) {
                throw new IllegalArgumentException("Number is null!");
            }
            slb.add(n.toString());
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setString(int parameterIndex, String ... str) {
        if (str == null || str.length == 0) {
            throw new IllegalArgumentException("String must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (String s : str) {
            if (s == null) {
                throw new IllegalArgumentException("String is null!");
            }
            slb.add(QueryStatementImpl.escape(s));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setStringContains(int parameterIndex, String str) {
        if (str == null) {
            throw new IllegalArgumentException("String must be set!");
        }
        this.parametersMap.put(parameterIndex, QueryStatementImpl.escapeContains(str));
    }

    public void setStringLike(int parameterIndex, String str) {
        if (str == null) {
            throw new IllegalArgumentException("String must be set!");
        }
        this.parametersMap.put(parameterIndex, QueryStatementImpl.escapeLike(str));
    }

    public void setId(int parameterIndex, ObjectId ... id) {
        if (id == null || id.length == 0) {
            throw new IllegalArgumentException("Id must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (ObjectId oid : id) {
            if (oid == null || oid.getId() == null) {
                throw new IllegalArgumentException("Id is null!");
            }
            slb.add(QueryStatementImpl.escape(oid.getId()));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setUri(int parameterIndex, URI ... uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (URI u : uri) {
            if (u == null) {
                throw new IllegalArgumentException("URI is null!");
            }
            slb.add(QueryStatementImpl.escape(u.toString()));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setUrl(int parameterIndex, URL ... url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (URL u : url) {
            if (u == null) {
                throw new IllegalArgumentException("URI is null!");
            }
            slb.add(QueryStatementImpl.escape(u.toString()));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setBoolean(int parameterIndex, boolean ... bool) {
        if (bool == null || bool.length == 0) {
            throw new IllegalArgumentException("Boolean must not be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (boolean b : bool) {
            slb.add(b ? "TRUE" : "FALSE");
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setDateTime(int parameterIndex, Calendar ... cal) {
        this.setDateTime(parameterIndex, false, cal);
    }

    public void setDateTimeTimestamp(int parameterIndex, Calendar ... cal) {
        this.setDateTime(parameterIndex, true, cal);
    }

    protected void setDateTime(int parameterIndex, boolean prefix, Calendar ... cal) {
        if (cal == null || cal.length == 0) {
            throw new IllegalArgumentException("Calendar must be set!");
        }
        StringBuilder sb = new StringBuilder(64);
        for (Calendar c : cal) {
            if (c == null) {
                throw new IllegalArgumentException("DateTime is null!");
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (prefix) {
                sb.append("TIMESTAMP ");
            }
            sb.append(QueryStatementImpl.convert(c.getTime()));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setDateTime(int parameterIndex, Date ... date) {
        this.setDateTime(parameterIndex, false, date);
    }

    public void setDateTimeTimestamp(int parameterIndex, Date ... date) {
        this.setDateTime(parameterIndex, true, date);
    }

    protected void setDateTime(int parameterIndex, boolean prefix, Date ... date) {
        if (date == null || date.length == 0) {
            throw new IllegalArgumentException("Date must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (Date d : date) {
            if (d == null) {
                throw new IllegalArgumentException("DateTime is null!");
            }
            slb.add((prefix ? "TIMESTAMP " : "") + QueryStatementImpl.convert(d));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public void setDateTime(int parameterIndex, long ... ms) {
        this.setDateTime(parameterIndex, false, ms);
    }

    public void setDateTimeTimestamp(int parameterIndex, long ... ms) {
        this.setDateTime(parameterIndex, true, ms);
    }

    protected void setDateTime(int parameterIndex, boolean prefix, long ... ms) {
        if (ms == null || ms.length == 0) {
            throw new IllegalArgumentException("Timestamp must be set!");
        }
        StringListBuilder slb = new StringListBuilder(",");
        for (long l : ms) {
            slb.add((prefix ? "TIMESTAMP " : "") + QueryStatementImpl.convert(new Date(l)));
        }
        this.parametersMap.put(parameterIndex, slb.toString());
    }

    public String toQueryString() {
        boolean inStr = false;
        int parameterIndex = 0;
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < this.statement.length(); ++i) {
            char c = this.statement.charAt(i);
            if (c == '\'') {
                inStr = inStr && this.statement.charAt(i - 1) == '\\' ? true : !inStr;
                sb.append(c);
                continue;
            }
            if (c == '?' && !inStr) {
                String s;
                if ((s = this.parametersMap.get(++parameterIndex)) == null) {
                    sb.append(c);
                    continue;
                }
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public ItemIterable<QueryResult> query(boolean searchAllVersions) {
        return this.session.query(this.toQueryString(), searchAllVersions);
    }

    public ItemIterable<QueryResult> query(boolean searchAllVersions, OperationContext context) {
        return this.session.query(this.toQueryString(), searchAllVersions, context);
    }

    protected QueryStatementImpl clone() throws CloneNotSupportedException {
        QueryStatementImpl qs = new QueryStatementImpl(this.session, this.statement);
        qs.parametersMap.putAll(this.parametersMap);
        return qs;
    }

    public String toString() {
        return this.toQueryString();
    }

    private static String escape(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 16);
        sb.append('\'');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\'');
        return sb.toString();
    }

    private static String escapeLike(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 16);
        sb.append('\'');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                sb.append('\\');
            } else if (c == '\\' && (i + 1 >= str.length() || str.charAt(i + 1) != '%' && str.charAt(i + 1) != '_')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\'');
        return sb.toString();
    }

    private static String escapeContains(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 64);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                sb.append('\\');
            } else if (c == '\'' || c == '\"') {
                sb.append('\\');
            } else if (c == '-' && i > 0) {
                char cb = str.charAt(i - 1);
                if (cb == '\\') {
                    sb.deleteCharAt(sb.length() - 1);
                } else if (cb != ' ') {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return QueryStatementImpl.escape(sb.toString());
    }

    private static String convert(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return "'" + sdf.format(date) + "'";
    }
}

