/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.ItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.SecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtils {
    private TypeUtils() {
    }

    public static void writeToXML(TypeDefinition type, OutputStream stream) throws XMLStreamException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Output stream must be set!");
        }
        XMLStreamWriter writer = XMLUtils.createWriter((OutputStream)stream);
        XMLUtils.startXmlDocument((XMLStreamWriter)writer);
        XMLConverter.writeTypeDefinition((XMLStreamWriter)writer, (CmisVersion)CmisVersion.CMIS_1_1, (String)"http://docs.oasis-open.org/ns/cmis/core/200908/", (TypeDefinition)type);
        XMLUtils.endXmlDocument((XMLStreamWriter)writer);
        writer.close();
    }

    public static void writeToJSON(TypeDefinition type, OutputStream stream) throws IOException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Output stream must be set!");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        JSONConverter.convert((TypeDefinition)type).writeJSONString((Writer)writer);
        ((Writer)writer).flush();
    }

    public static TypeDefinition readFromXML(InputStream stream) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("Input stream must be set!");
        }
        XMLStreamReader parser = XMLUtils.createParser((InputStream)stream);
        if (!XMLUtils.findNextStartElemenet((XMLStreamReader)parser)) {
            return null;
        }
        TypeDefinition typeDef = XMLConverter.convertTypeDefinition((XMLStreamReader)parser);
        parser.close();
        return typeDef;
    }

    public static TypeDefinition readFromJSON(InputStream stream) throws IOException, JSONParseException {
        if (stream == null) {
            throw new IllegalArgumentException("Input stream must be set!");
        }
        JSONParser parser = new JSONParser();
        Object json = parser.parse((Reader)new InputStreamReader(stream, "UTF-8"));
        if (!(json instanceof Map)) {
            throw new CmisRuntimeException("Invalid stream! Not a type definition!");
        }
        return JSONConverter.convertTypeDefinition((Map)((Map)json));
    }

    private static boolean checkQueryName(String queryName) {
        return queryName != null && queryName.length() > 0 && queryName.indexOf(32) < 0 && queryName.indexOf(9) < 0 && queryName.indexOf(10) < 0 && queryName.indexOf(13) < 0 && queryName.indexOf(12) < 0 && queryName.indexOf(44) < 0 && queryName.indexOf(34) < 0 && queryName.indexOf(39) < 0 && queryName.indexOf(92) < 0 && queryName.indexOf(46) < 0 && queryName.indexOf(40) < 0 && queryName.indexOf(41) < 0;
    }

    public static List<ValidationError> validateTypeDefinition(TypeDefinition type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null!");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (type.getId() == null || type.getId().length() == 0) {
            errors.add(new ValidationError("id", "Type id must be set."));
        }
        if (type.getLocalName() == null || type.getLocalName().length() == 0) {
            errors.add(new ValidationError("localName", "Local name must be set."));
        }
        if (type.getQueryName() != null) {
            if (type.getQueryName().length() == 0) {
                errors.add(new ValidationError("queryName", "Query name must not be empty."));
            } else if (!TypeUtils.checkQueryName(type.getQueryName())) {
                errors.add(new ValidationError("queryName", "Query name contains invalid characters."));
            }
        }
        if (type.isCreatable() == null) {
            errors.add(new ValidationError("creatable", "Creatable flag must be set."));
        }
        if (type.isFileable() == null) {
            errors.add(new ValidationError("fileable", "Fileable flag must be set."));
        }
        if (type.isQueryable() == null) {
            errors.add(new ValidationError("queryable", "Queryable flag must be set."));
        } else if (type.isQueryable().booleanValue() && (type.getQueryName() == null || type.getQueryName().length() == 0)) {
            errors.add(new ValidationError("queryable", "Queryable flag is set to TRUE, but the query name is not set."));
        }
        if (type.isControllablePolicy() == null) {
            errors.add(new ValidationError("controllablePolicy", "ControllablePolicy flag must be set."));
        }
        if (type.isControllableAcl() == null) {
            errors.add(new ValidationError("controllableACL", "ControllableACL flag must be set."));
        }
        if (type.isFulltextIndexed() == null) {
            errors.add(new ValidationError("fulltextIndexed", "FulltextIndexed flag must be set."));
        }
        if (type.isIncludedInSupertypeQuery() == null) {
            errors.add(new ValidationError("includedInSupertypeQuery", "IncludedInSupertypeQuery flag must be set."));
        }
        if (type.getBaseTypeId() == null) {
            errors.add(new ValidationError("baseId", "Base type id must be set."));
        } else if (!(type.getBaseTypeId().value().equals(type.getParentTypeId()) || type.getParentTypeId() != null && type.getParentTypeId().length() != 0)) {
            errors.add(new ValidationError("parentTypeId", "Parent type id must be set."));
        }
        if (type instanceof DocumentTypeDefinition) {
            DocumentTypeDefinition docType;
            if (type.getBaseTypeId() != BaseTypeId.CMIS_DOCUMENT) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
            if ((docType = (DocumentTypeDefinition)type).isVersionable() == null) {
                errors.add(new ValidationError("versionable", "Versionable flag must be set."));
            }
            if (docType.getContentStreamAllowed() == null) {
                errors.add(new ValidationError("contentStreamAllowed", "ContentStreamAllowed flag must be set."));
            }
        } else if (type instanceof FolderTypeDefinition) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_FOLDER) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
        } else if (type instanceof RelationshipTypeDefinition) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_RELATIONSHIP) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
        } else if (type instanceof PolicyTypeDefinition) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_POLICY) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
        } else if (type instanceof ItemTypeDefinition) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_ITEM) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
        } else if (type instanceof SecondaryTypeDefinition) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_SECONDARY) {
                errors.add(new ValidationError("baseId", "Base type id does not match the type."));
            }
        } else {
            errors.add(new ValidationError("baseId", "Unknown base interface."));
        }
        return errors;
    }

    public static List<ValidationError> validatePropertyDefinition(PropertyDefinition<?> propDef) {
        if (propDef == null) {
            throw new IllegalArgumentException("Type is null!");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (propDef.getId() == null || propDef.getId().length() == 0) {
            errors.add(new ValidationError("id", "Type id must be set."));
        }
        if (propDef.getQueryName() != null) {
            if (propDef.getQueryName().length() == 0) {
                errors.add(new ValidationError("queryName", "Query name must not be empty."));
            } else if (!TypeUtils.checkQueryName(propDef.getQueryName())) {
                errors.add(new ValidationError("queryName", "Query name contains invalid characters."));
            }
        }
        if (propDef.getCardinality() == null) {
            errors.add(new ValidationError("cardinality", "Cardinality must be set."));
        }
        if (propDef.getUpdatability() == null) {
            errors.add(new ValidationError("updatability", "Updatability must be set."));
        }
        if (propDef.isInherited() == null) {
            errors.add(new ValidationError("inherited", "Inherited flag must be set."));
        }
        if (propDef.isRequired() == null) {
            errors.add(new ValidationError("required", "Required flag must be set."));
        }
        if (propDef.isQueryable() == null) {
            errors.add(new ValidationError("queryable", "Queryable flag must be set."));
        } else if (propDef.isQueryable().booleanValue() && (propDef.getQueryName() == null || propDef.getQueryName().length() == 0)) {
            errors.add(new ValidationError("queryable", "Queryable flag is set to TRUE, but the query name is not set."));
        }
        if (propDef.isOrderable() == null) {
            errors.add(new ValidationError("orderable", "Orderable flag must be set."));
        } else if (propDef.isOrderable().booleanValue() && propDef.getCardinality() == Cardinality.MULTI) {
            errors.add(new ValidationError("orderable", "Orderable flag is set to TRUE for a multi-value property."));
        }
        if (propDef.getPropertyType() == null) {
            errors.add(new ValidationError("propertyType", "Property type id must be set."));
        }
        if (propDef instanceof PropertyIdDefinition) {
            if (propDef.getPropertyType() != PropertyType.ID) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyStringDefinition) {
            if (propDef.getPropertyType() != PropertyType.STRING) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyIntegerDefinition) {
            if (propDef.getPropertyType() != PropertyType.INTEGER) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyDecimalDefinition) {
            if (propDef.getPropertyType() != PropertyType.DECIMAL) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyBooleanDefinition) {
            if (propDef.getPropertyType() != PropertyType.BOOLEAN) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyDateTimeDefinition) {
            if (propDef.getPropertyType() != PropertyType.DATETIME) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyHtmlDefinition) {
            if (propDef.getPropertyType() != PropertyType.HTML) {
                errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
            }
        } else if (propDef instanceof PropertyUriDefinition && propDef.getPropertyType() != PropertyType.URI) {
            errors.add(new ValidationError("propertyType", "Property type does not match the property definition."));
        }
        return errors;
    }

    public static class ValidationError {
        private final String attribute;
        private final String error;

        public ValidationError(String attribute, String error) {
            this.attribute = attribute;
            this.error = error;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getError() {
            return this.error;
        }

        public String toString() {
            return this.attribute + ": " + this.error;
        }
    }
}

