/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationContextUtils {
    public static final String PROPERTIES_STAR = "*";
    public static final String RENDITION_NONE = "cmis:none";

    private OperationContextUtils() {
    }

    public static OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public static OperationContext copyOperationContext(OperationContext context) {
        return new OperationContextImpl(context);
    }

    public static OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        return new OperationContextImpl(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public static OperationContext createMinimumOperationContext() {
        HashSet<String> filter = new HashSet<String>();
        filter.add("cmis:objectId");
        filter.add("cmis:objectTypeId");
        filter.add("cmis:baseTypeId");
        return new OperationContextImpl(filter, false, false, false, IncludeRelationships.NONE, Collections.singleton(RENDITION_NONE), false, null, true, 100);
    }

    public static OperationContext createMaximumOperationContext() {
        return new OperationContextImpl(Collections.singleton(PROPERTIES_STAR), true, true, true, IncludeRelationships.BOTH, Collections.singleton(PROPERTIES_STAR), false, null, true, 100);
    }
}

