/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpSorter;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;

public class DefaultDbRowOpSorter
implements DbRowOpSorter {
    protected final Provider<DataDomain> dataDomainProvider;
    protected volatile Comparator<DbRowOp> comparator;

    public DefaultDbRowOpSorter(@Inject Provider<DataDomain> dataDomainProvider) {
        this.dataDomainProvider = dataDomainProvider;
    }

    @Override
    public List<DbRowOp> sort(List<DbRowOp> dbRows) {
        dbRows.sort(this.getComparator());
        this.sortReflexive(dbRows);
        return dbRows;
    }

    protected void sortReflexive(List<DbRowOp> sortedDbRows) {
        DataDomain dataDomain = (DataDomain)this.dataDomainProvider.get();
        EntitySorter sorter = dataDomain.getEntitySorter();
        EntityResolver resolver = dataDomain.getEntityResolver();
        DbEntity lastEntity = null;
        int start = 0;
        int idx = 0;
        DbRowOp lastRow = null;
        for (int i = 0; i < sortedDbRows.size(); ++i) {
            DbRowOp row = sortedDbRows.get(i);
            if (row.getEntity() != lastEntity) {
                if (lastEntity != null && !(lastRow instanceof UpdateDbRowOp) && sorter.isReflexive(lastEntity)) {
                    ObjEntity objEntity = resolver.getObjEntity(lastRow.getObject().getObjectId().getEntityName());
                    List<DbRowOp> reflexiveSublist = sortedDbRows.subList(start, idx);
                    sorter.sortObjectsForEntity(objEntity, reflexiveSublist, lastRow instanceof DeleteDbRowOp);
                }
                start = idx;
                lastEntity = row.getEntity();
            }
            lastRow = row;
            ++idx;
        }
        if (lastEntity != null && !(lastRow instanceof UpdateDbRowOp) && sorter.isReflexive(lastEntity)) {
            ObjEntity objEntity = resolver.getObjEntity(lastRow.getObject().getObjectId().getEntityName());
            List<DbRowOp> reflexiveSublist = sortedDbRows.subList(start, idx);
            sorter.sortObjectsForEntity(objEntity, reflexiveSublist, lastRow instanceof DeleteDbRowOp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Comparator<DbRowOp> getComparator() {
        DbRowComparator local = this.comparator;
        if (local == null) {
            DefaultDbRowOpSorter defaultDbRowOpSorter = this;
            synchronized (defaultDbRowOpSorter) {
                local = this.comparator;
                if (local == null) {
                    this.comparator = local = new DbRowComparator(((DataDomain)this.dataDomainProvider.get()).getEntitySorter());
                }
            }
        }
        return local;
    }

    protected static class DbRowTypeVisitor
    implements DbRowOpVisitor<DbRowOpType> {
        private static final DbRowTypeVisitor INSTANCE = new DbRowTypeVisitor();

        protected DbRowTypeVisitor() {
        }

        @Override
        public DbRowOpType visitInsert(InsertDbRowOp diffSnapshot) {
            return DbRowOpType.INSERT;
        }

        @Override
        public DbRowOpType visitUpdate(UpdateDbRowOp diffSnapshot) {
            return DbRowOpType.UPDATE;
        }

        @Override
        public DbRowOpType visitDelete(DeleteDbRowOp diffSnapshot) {
            return DbRowOpType.DELETE;
        }
    }

    protected static class DbRowComparator
    implements Comparator<DbRowOp> {
        private final EntitySorter entitySorter;

        protected DbRowComparator(EntitySorter entitySorter) {
            this.entitySorter = entitySorter;
        }

        @Override
        public int compare(DbRowOp left, DbRowOp right) {
            DbRowOpType rightType;
            DbRowOpType leftType = left.accept(DbRowTypeVisitor.INSTANCE);
            int result = leftType.compareTo(rightType = right.accept(DbRowTypeVisitor.INSTANCE));
            if (result != 0) {
                return result;
            }
            result = this.entitySorter.getDbEntityComparator().compare(left.getEntity(), right.getEntity());
            if (result != 0) {
                return leftType == DbRowOpType.DELETE ? -result : result;
            }
            return result;
        }
    }
}

