/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.utils;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.Fail;

@Deprecated
public class ConditionChecker {
    private static final int DEFAULT_PERIOD_MILLIS = 500;
    private static final int DEFAULT_TIMEOUT_MILLIS = 60000;
    private final Object predicate;
    private final boolean expectedOutcome;
    private final String description;
    private final Lock lock;
    private final Condition condition;
    private final Timer timer;
    private Throwable lastFailure;

    public static ConditionCheckerBuilder checkThat(BooleanSupplier predicate) {
        return new ConditionCheckerBuilder(predicate);
    }

    public static ConditionCheckerBuilder checkThat(Runnable predicate) {
        return new ConditionCheckerBuilder(predicate);
    }

    public ConditionChecker(Object predicate, boolean expectedOutcome, long period, TimeUnit periodUnit, String description) {
        this.predicate = predicate;
        this.expectedOutcome = expectedOutcome;
        this.description = description != null ? description : this.toString();
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.timer = new Timer("condition-checker", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ConditionChecker.this.checkCondition();
            }
        }, 0L, periodUnit.toMillis(period));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit) {
        boolean interrupted = false;
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (!this.evalCondition()) {
                if (nanos <= 0L) {
                    String msg = String.format("Timeout after %s %s while waiting for '%s'", timeout, unit.toString().toLowerCase(), this.description);
                    if (this.lastFailure != null) {
                        Fail.fail((String)msg, (Throwable)this.lastFailure);
                    } else {
                        Fail.fail((String)msg);
                    }
                }
                try {
                    nanos = this.condition.awaitNanos(nanos);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            this.timer.cancel();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void checkCondition() {
        this.lock.lock();
        try {
            if (this.evalCondition()) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean evalCondition() {
        if (this.predicate instanceof BooleanSupplier) {
            return ((BooleanSupplier)this.predicate).getAsBoolean() == this.expectedOutcome;
        }
        if (this.predicate instanceof Runnable) {
            boolean succeeded = true;
            try {
                ((Runnable)this.predicate).run();
            }
            catch (Throwable t) {
                succeeded = false;
                this.lastFailure = t;
            }
            return succeeded == this.expectedOutcome;
        }
        throw new AssertionError((Object)("Unsupported predicate type " + this.predicate.getClass()));
    }

    @Deprecated
    public static class ConditionCheckerBuilder {
        private long timeout = 60000L;
        private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
        private long period = 500L;
        private TimeUnit periodUnit = TimeUnit.MILLISECONDS;
        private final Object predicate;
        private String description;

        ConditionCheckerBuilder(BooleanSupplier predicate) {
            this.predicate = predicate;
        }

        public ConditionCheckerBuilder(Runnable predicate) {
            this.predicate = predicate;
        }

        public ConditionCheckerBuilder every(long period, TimeUnit unit) {
            this.period = period;
            this.periodUnit = unit;
            return this;
        }

        public ConditionCheckerBuilder every(long periodMillis) {
            this.period = periodMillis;
            this.periodUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public ConditionCheckerBuilder before(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.timeoutUnit = unit;
            return this;
        }

        public ConditionCheckerBuilder before(long timeoutMillis) {
            this.timeout = timeoutMillis;
            this.timeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public ConditionCheckerBuilder as(String description) {
            this.description = description;
            return this;
        }

        public void becomesTrue() {
            new ConditionChecker(this.predicate, true, this.period, this.periodUnit, this.description).await(this.timeout, this.timeoutUnit);
        }

        public void becomesFalse() {
            new ConditionChecker(this.predicate, false, this.period, this.periodUnit, this.description).await(this.timeout, this.timeoutUnit);
        }
    }
}

