/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.schema;

import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.OptionProvider;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface RelationOptions<SelfT extends RelationOptions<SelfT>>
extends OptionProvider<SelfT> {
    @NonNull
    @CheckReturnValue
    default public SelfT withBloomFilterFpChance(double bloomFilterFpChance) {
        return (SelfT)((RelationOptions)this.withOption("bloom_filter_fp_chance", bloomFilterFpChance));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCDC(boolean enabled) {
        return (SelfT)((RelationOptions)this.withOption("cdc", enabled));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCRCCheckChance(double crcCheckChance) {
        return (SelfT)((RelationOptions)this.withOption("crc_check_chance", crcCheckChance));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCaching(boolean keys, @NonNull SchemaBuilder.RowsPerPartition rowsPerPartition) {
        return (SelfT)((RelationOptions)this.withOption("caching", ImmutableMap.of((Object)"keys", (Object)(keys ? "ALL" : "NONE"), (Object)"rows_per_partition", (Object)rowsPerPartition.getValue())));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withComment(@NonNull String comment) {
        return (SelfT)((RelationOptions)this.withOption("comment", comment));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCompaction(@NonNull CompactionStrategy<?> compactionStrategy) {
        return (SelfT)((RelationOptions)this.withOption("compaction", compactionStrategy.getOptions()));
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT withLZ4Compression(int chunkLengthKB, double crcCheckChance) {
        return this.withCompression("LZ4Compressor", chunkLengthKB, crcCheckChance);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withLZ4Compression(int chunkLengthKB) {
        return this.withCompression("LZ4Compressor", chunkLengthKB);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withLZ4Compression() {
        return this.withCompression("LZ4Compressor");
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withZstdCompression(int chunkLengthKB) {
        return this.withCompression("ZstdCompressor", chunkLengthKB);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withZstdCompression() {
        return this.withCompression("ZstdCompressor");
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT withSnappyCompression(int chunkLengthKB, double crcCheckChance) {
        return this.withCompression("SnappyCompressor", chunkLengthKB, crcCheckChance);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withSnappyCompression(int chunkLengthKB) {
        return this.withCompression("SnappyCompressor", chunkLengthKB);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withSnappyCompression() {
        return this.withCompression("SnappyCompressor");
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT withDeflateCompression(int chunkLengthKB, double crcCheckChance) {
        return this.withCompression("DeflateCompressor", chunkLengthKB, crcCheckChance);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withDeflateCompression(int chunkLengthKB) {
        return this.withCompression("DeflateCompressor", chunkLengthKB);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withDeflateCompression() {
        return this.withCompression("DeflateCompressor");
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCompression(@NonNull String compressionAlgorithmName) {
        return (SelfT)((RelationOptions)this.withOption("compression", ImmutableMap.of((Object)"class", (Object)compressionAlgorithmName)));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withCompression(@NonNull String compressionAlgorithmName, int chunkLengthKB) {
        return (SelfT)((RelationOptions)this.withOption("compression", ImmutableMap.of((Object)"class", (Object)compressionAlgorithmName, (Object)"chunk_length_in_kb", (Object)chunkLengthKB)));
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT withCompression(@NonNull String compressionAlgorithmName, int chunkLengthKB, double crcCheckChance) {
        return (SelfT)((RelationOptions)this.withOption("compression", ImmutableMap.of((Object)"class", (Object)compressionAlgorithmName, (Object)"chunk_length_kb", (Object)chunkLengthKB, (Object)"crc_check_chance", (Object)crcCheckChance)));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withNoCompression() {
        return (SelfT)((RelationOptions)this.withOption("compression", ImmutableMap.of((Object)"sstable_compression", (Object)"")));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withDcLocalReadRepairChance(double dcLocalReadRepairChance) {
        return (SelfT)((RelationOptions)this.withOption("dclocal_read_repair_chance", dcLocalReadRepairChance));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withDefaultTimeToLiveSeconds(int ttl) {
        return (SelfT)((RelationOptions)this.withOption("default_time_to_live", ttl));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withGcGraceSeconds(int gcGraceSeconds) {
        return (SelfT)((RelationOptions)this.withOption("gc_grace_seconds", gcGraceSeconds));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withMemtableFlushPeriodInMs(int memtableFlushPeriodInMs) {
        return (SelfT)((RelationOptions)this.withOption("memtable_flush_period_in_ms", memtableFlushPeriodInMs));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withMinIndexInterval(int min) {
        return (SelfT)((RelationOptions)this.withOption("min_index_interval", min));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withMaxIndexInterval(int max) {
        return (SelfT)((RelationOptions)this.withOption("max_index_interval", max));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withReadRepairChance(double readRepairChance) {
        return (SelfT)((RelationOptions)this.withOption("read_repair_chance", readRepairChance));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT withSpeculativeRetry(@NonNull String speculativeRetry) {
        return (SelfT)((RelationOptions)this.withOption("speculative_retry", speculativeRetry));
    }
}

