/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metrics.MetricPaths;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.util.concurrent.RunOrSchedule;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileNodeMetricUpdater;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileSessionMetricUpdater;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MicroProfileMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MicroProfileMetricsFactory.class);
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    private final SessionMetricUpdater sessionUpdater;

    public MicroProfileMetricsFactory(DriverContext context) {
        this.context = (InternalDriverContext)context;
        String logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set enabledSessionMetrics = MetricPaths.parseSessionMetricPaths((List)config.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED), (String)logPrefix);
        this.enabledNodeMetrics = MetricPaths.parseNodeMetricPaths((List)config.getStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED), (String)logPrefix);
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled.", (Object)logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
        } else {
            Object possibleMetricRegistry = this.context.getMetricRegistry();
            if (possibleMetricRegistry == null) {
                throw new IllegalArgumentException("No metric registry object found. Expected registry object to be of type '" + MetricRegistry.class.getName() + "'");
            }
            if (!(possibleMetricRegistry instanceof MetricRegistry)) {
                throw new IllegalArgumentException("Unexpected Metrics registry object. Expected registry object to be of type '" + MetricRegistry.class.getName() + "', but was '" + possibleMetricRegistry.getClass().getName() + "'");
            }
            this.registry = (MetricRegistry)possibleMetricRegistry;
            this.sessionUpdater = new MicroProfileSessionMetricUpdater(this.context, enabledSessionMetrics, this.registry);
            if (!this.enabledNodeMetrics.isEmpty()) {
                EventExecutor adminEventExecutor = this.context.getNettyOptions().adminEventExecutorGroup().next();
                this.context.getEventBus().register(NodeStateEvent.class, RunOrSchedule.on((EventExecutor)adminEventExecutor, this::processNodeStateEvent));
            }
        }
    }

    public Optional<Metrics> getMetrics() {
        return Optional.empty();
    }

    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    public NodeMetricUpdater newNodeUpdater(Node node) {
        if (this.registry == null) {
            return NoopNodeMetricUpdater.INSTANCE;
        }
        return new MicroProfileNodeMetricUpdater(node, this.context, this.enabledNodeMetrics, this.registry);
    }

    protected void processNodeStateEvent(NodeStateEvent event) {
        if (event.newState == NodeState.DOWN || event.newState == NodeState.FORCED_DOWN || event.newState == null) {
            ((MicroProfileNodeMetricUpdater)event.node.getMetricUpdater()).startMetricsExpirationTimeout();
        } else if (event.newState == NodeState.UP || event.newState == NodeState.UNKNOWN) {
            ((MicroProfileNodeMetricUpdater)event.node.getMetricUpdater()).cancelMetricsExpirationTimeout();
        }
    }
}

