/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.AbstractMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileTags;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@ThreadSafe
public abstract class MicroProfileMetricUpdater<MetricT>
extends AbstractMetricUpdater<MetricT> {
    protected final MetricRegistry registry;
    protected final ConcurrentMap<MetricT, Metric> metrics = new ConcurrentHashMap<MetricT, Metric>();

    protected MicroProfileMetricUpdater(InternalDriverContext context, Set<MetricT> enabledMetrics, MetricRegistry registry) {
        super(context, enabledMetrics);
        this.registry = registry;
    }

    public void incrementCounter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateCounterFor(metric).inc(amount);
        }
    }

    public void updateHistogram(MetricT metric, @Nullable String profileName, long value) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateHistogramFor(metric).update(value);
        }
    }

    public void markMeter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateMeterFor(metric).mark(amount);
        }
    }

    public void updateTimer(MetricT metric, @Nullable String profileName, long duration, TimeUnit unit) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateTimerFor(metric).update(Duration.ofNanos(unit.toNanos(duration)));
        }
    }

    public void clearMetrics() {
        for (Object metric : this.metrics.keySet()) {
            MetricId id = this.getMetricId(metric);
            Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
            this.registry.remove(new MetricID(id.getName(), tags));
        }
        this.metrics.clear();
    }

    protected abstract MetricId getMetricId(MetricT var1);

    protected void initializeGauge(MetricT metric, DriverExecutionProfile profile, Gauge<Number> supplier) {
        if (this.isEnabled(metric, profile.getName())) {
            this.metrics.computeIfAbsent(metric, m -> {
                MetricId id = this.getMetricId(m);
                String name = id.getName();
                Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
                Metadata metadata = Metadata.builder().withName(name).withType(MetricType.GAUGE).build();
                return this.registry.register(metadata, (Metric)supplier, tags);
            });
        }
    }

    protected void initializeCounter(MetricT metric, DriverExecutionProfile profile) {
        if (this.isEnabled(metric, profile.getName())) {
            this.getOrCreateCounterFor(metric);
        }
    }

    protected void initializeTimer(MetricT metric, DriverExecutionProfile profile) {
        if (this.isEnabled(metric, profile.getName())) {
            this.getOrCreateTimerFor(metric);
        }
    }

    protected Counter getOrCreateCounterFor(MetricT metric) {
        return (Counter)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
            return this.registry.counter(id.getName(), tags);
        });
    }

    protected Meter getOrCreateMeterFor(MetricT metric) {
        return (Meter)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
            return this.registry.meter(id.getName(), tags);
        });
    }

    protected Histogram getOrCreateHistogramFor(MetricT metric) {
        return (Histogram)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
            return this.registry.histogram(id.getName(), tags);
        });
    }

    protected Timer getOrCreateTimerFor(MetricT metric) {
        return (Timer)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Tag[] tags = MicroProfileTags.toMicroProfileTags(id.getTags());
            return this.registry.timer(id.getName(), tags);
        });
    }
}

