/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class CqlResult
implements TBase<CqlResult, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("CqlResult");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField ROWS_FIELD_DESC = new TField("rows", 15, 2);
    private static final TField NUM_FIELD_DESC = new TField("num", 8, 3);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 12, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public CqlResultType type;
    public List<CqlRow> rows;
    public int num;
    public CqlMetadata schema;
    private static final int __NUM_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.ROWS, _Fields.NUM, _Fields.SCHEMA};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CqlResult() {
    }

    public CqlResult(CqlResultType type) {
        this();
        this.type = type;
    }

    public CqlResult(CqlResult other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetRows()) {
            ArrayList<CqlRow> __this__rows = new ArrayList<CqlRow>();
            for (CqlRow other_element : other.rows) {
                __this__rows.add(new CqlRow(other_element));
            }
            this.rows = __this__rows;
        }
        this.num = other.num;
        if (other.isSetSchema()) {
            this.schema = new CqlMetadata(other.schema);
        }
    }

    public CqlResult deepCopy() {
        return new CqlResult(this);
    }

    public void clear() {
        this.type = null;
        this.rows = null;
        this.setNumIsSet(false);
        this.num = 0;
        this.schema = null;
    }

    public CqlResultType getType() {
        return this.type;
    }

    public CqlResult setType(CqlResultType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public int getRowsSize() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public Iterator<CqlRow> getRowsIterator() {
        return this.rows == null ? null : this.rows.iterator();
    }

    public void addToRows(CqlRow elem) {
        if (this.rows == null) {
            this.rows = new ArrayList<CqlRow>();
        }
        this.rows.add(elem);
    }

    public List<CqlRow> getRows() {
        return this.rows;
    }

    public CqlResult setRows(List<CqlRow> rows) {
        this.rows = rows;
        return this;
    }

    public void unsetRows() {
        this.rows = null;
    }

    public boolean isSetRows() {
        return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
        if (!value) {
            this.rows = null;
        }
    }

    public int getNum() {
        return this.num;
    }

    public CqlResult setNum(int num) {
        this.num = num;
        this.setNumIsSet(true);
        return this;
    }

    public void unsetNum() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetNum() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setNumIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public CqlMetadata getSchema() {
        return this.schema;
    }

    public CqlResult setSchema(CqlMetadata schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((CqlResultType)((Object)value));
                break;
            }
            case ROWS: {
                if (value == null) {
                    this.unsetRows();
                    break;
                }
                this.setRows((List)value);
                break;
            }
            case NUM: {
                if (value == null) {
                    this.unsetNum();
                    break;
                }
                this.setNum((Integer)value);
                break;
            }
            case SCHEMA: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((CqlMetadata)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case ROWS: {
                return this.getRows();
            }
            case NUM: {
                return this.getNum();
            }
            case SCHEMA: {
                return this.getSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case ROWS: {
                return this.isSetRows();
            }
            case NUM: {
                return this.isSetNum();
            }
            case SCHEMA: {
                return this.isSetSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof CqlResult) {
            return this.equals((CqlResult)that);
        }
        return false;
    }

    public boolean equals(CqlResult that) {
        if (that == null) {
            return false;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_rows = this.isSetRows();
        boolean that_present_rows = that.isSetRows();
        if (this_present_rows || that_present_rows) {
            if (!this_present_rows || !that_present_rows) {
                return false;
            }
            if (!this.rows.equals(that.rows)) {
                return false;
            }
        }
        boolean this_present_num = this.isSetNum();
        boolean that_present_num = that.isSetNum();
        if (this_present_num || that_present_num) {
            if (!this_present_num || !that_present_num) {
                return false;
            }
            if (this.num != that.num) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!this.schema.equals(that.schema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_type = this.isSetType();
        builder.append(present_type);
        if (present_type) {
            builder.append(this.type.getValue());
        }
        boolean present_rows = this.isSetRows();
        builder.append(present_rows);
        if (present_rows) {
            builder.append(this.rows);
        }
        boolean present_num = this.isSetNum();
        builder.append(present_num);
        if (present_num) {
            builder.append(this.num);
        }
        boolean present_schema = this.isSetSchema();
        builder.append(present_schema);
        if (present_schema) {
            builder.append((Object)this.schema);
        }
        return builder.toHashCode();
    }

    public int compareTo(CqlResult other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        CqlResult typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(typedOther.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)typedOther.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRows()).compareTo(typedOther.isSetRows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRows() && (lastComparison = TBaseHelper.compareTo(this.rows, typedOther.rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum()).compareTo(typedOther.isSetNum());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum() && (lastComparison = TBaseHelper.compareTo((int)this.num, (int)typedOther.num)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(typedOther.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchema() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.schema), (Comparable)((Object)typedOther.schema))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CqlResult(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetRows()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("rows:");
            if (this.rows == null) {
                sb.append("null");
            } else {
                sb.append(this.rows);
            }
            first = false;
        }
        if (this.isSetNum()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("num:");
            sb.append(this.num);
            first = false;
        }
        if (this.isSetSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("schema:");
            if (this.schema == null) {
                sb.append("null");
            } else {
                sb.append(this.schema);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.schema != null) {
            this.schema.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new CqlResultStandardSchemeFactory());
        schemes.put(TupleScheme.class, new CqlResultTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, CqlResultType.class)));
        tmpMap.put(_Fields.ROWS, new FieldMetaData("rows", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, CqlRow.class))));
        tmpMap.put(_Fields.NUM, new FieldMetaData("num", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SCHEMA, new FieldMetaData("schema", 2, (FieldValueMetaData)new StructMetaData(12, CqlMetadata.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CqlResult.class, metaDataMap);
    }

    private static class CqlResultTupleScheme
    extends TupleScheme<CqlResult> {
        private CqlResultTupleScheme() {
        }

        public void write(TProtocol prot, CqlResult struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetRows()) {
                optionals.set(0);
            }
            if (struct.isSetNum()) {
                optionals.set(1);
            }
            if (struct.isSetSchema()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetRows()) {
                oprot.writeI32(struct.rows.size());
                for (CqlRow _iter198 : struct.rows) {
                    _iter198.write((TProtocol)oprot);
                }
            }
            if (struct.isSetNum()) {
                oprot.writeI32(struct.num);
            }
            if (struct.isSetSchema()) {
                struct.schema.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, CqlResult struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = CqlResultType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TList _list199 = new TList(12, iprot.readI32());
                struct.rows = new ArrayList<CqlRow>(_list199.size);
                for (int _i200 = 0; _i200 < _list199.size; ++_i200) {
                    CqlRow _elem201 = new CqlRow();
                    _elem201.read((TProtocol)iprot);
                    struct.rows.add(_elem201);
                }
                struct.setRowsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.num = iprot.readI32();
                struct.setNumIsSet(true);
            }
            if (incoming.get(2)) {
                struct.schema = new CqlMetadata();
                struct.schema.read((TProtocol)iprot);
                struct.setSchemaIsSet(true);
            }
        }
    }

    private static class CqlResultTupleSchemeFactory
    implements SchemeFactory {
        private CqlResultTupleSchemeFactory() {
        }

        public CqlResultTupleScheme getScheme() {
            return new CqlResultTupleScheme();
        }
    }

    private static class CqlResultStandardScheme
    extends StandardScheme<CqlResult> {
        private CqlResultStandardScheme() {
        }

        public void read(TProtocol iprot, CqlResult struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.type = CqlResultType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list194 = iprot.readListBegin();
                            struct.rows = new ArrayList<CqlRow>(_list194.size);
                            for (int _i195 = 0; _i195 < _list194.size; ++_i195) {
                                CqlRow _elem196 = new CqlRow();
                                _elem196.read(iprot);
                                struct.rows.add(_elem196);
                            }
                            iprot.readListEnd();
                            struct.setRowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.num = iprot.readI32();
                            struct.setNumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.schema = new CqlMetadata();
                            struct.schema.read(iprot);
                            struct.setSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, CqlResult struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.rows != null && struct.isSetRows()) {
                oprot.writeFieldBegin(ROWS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.rows.size()));
                for (CqlRow _iter197 : struct.rows) {
                    _iter197.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetNum()) {
                oprot.writeFieldBegin(NUM_FIELD_DESC);
                oprot.writeI32(struct.num);
                oprot.writeFieldEnd();
            }
            if (struct.schema != null && struct.isSetSchema()) {
                oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
                struct.schema.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class CqlResultStandardSchemeFactory
    implements SchemeFactory {
        private CqlResultStandardSchemeFactory() {
        }

        public CqlResultStandardScheme getScheme() {
            return new CqlResultStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        ROWS(2, "rows"),
        NUM(3, "num"),
        SCHEMA(4, "schema");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return ROWS;
                }
                case 3: {
                    return NUM;
                }
                case 4: {
                    return SCHEMA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

