/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class CfDef
implements TBase<CfDef, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("CfDef");
    private static final TField KEYSPACE_FIELD_DESC = new TField("keyspace", 11, 1);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 2);
    private static final TField COLUMN_TYPE_FIELD_DESC = new TField("column_type", 11, 3);
    private static final TField COMPARATOR_TYPE_FIELD_DESC = new TField("comparator_type", 11, 5);
    private static final TField SUBCOMPARATOR_TYPE_FIELD_DESC = new TField("subcomparator_type", 11, 6);
    private static final TField COMMENT_FIELD_DESC = new TField("comment", 11, 8);
    private static final TField ROW_CACHE_SIZE_FIELD_DESC = new TField("row_cache_size", 4, 9);
    private static final TField KEY_CACHE_SIZE_FIELD_DESC = new TField("key_cache_size", 4, 11);
    private static final TField READ_REPAIR_CHANCE_FIELD_DESC = new TField("read_repair_chance", 4, 12);
    private static final TField COLUMN_METADATA_FIELD_DESC = new TField("column_metadata", 15, 13);
    private static final TField GC_GRACE_SECONDS_FIELD_DESC = new TField("gc_grace_seconds", 8, 14);
    private static final TField DEFAULT_VALIDATION_CLASS_FIELD_DESC = new TField("default_validation_class", 11, 15);
    private static final TField ID_FIELD_DESC = new TField("id", 8, 16);
    private static final TField MIN_COMPACTION_THRESHOLD_FIELD_DESC = new TField("min_compaction_threshold", 8, 17);
    private static final TField MAX_COMPACTION_THRESHOLD_FIELD_DESC = new TField("max_compaction_threshold", 8, 18);
    private static final TField ROW_CACHE_SAVE_PERIOD_IN_SECONDS_FIELD_DESC = new TField("row_cache_save_period_in_seconds", 8, 19);
    private static final TField KEY_CACHE_SAVE_PERIOD_IN_SECONDS_FIELD_DESC = new TField("key_cache_save_period_in_seconds", 8, 20);
    private static final TField REPLICATE_ON_WRITE_FIELD_DESC = new TField("replicate_on_write", 2, 24);
    private static final TField MERGE_SHARDS_CHANCE_FIELD_DESC = new TField("merge_shards_chance", 4, 25);
    private static final TField KEY_VALIDATION_CLASS_FIELD_DESC = new TField("key_validation_class", 11, 26);
    private static final TField ROW_CACHE_PROVIDER_FIELD_DESC = new TField("row_cache_provider", 11, 27);
    private static final TField KEY_ALIAS_FIELD_DESC = new TField("key_alias", 11, 28);
    private static final TField COMPACTION_STRATEGY_FIELD_DESC = new TField("compaction_strategy", 11, 29);
    private static final TField COMPACTION_STRATEGY_OPTIONS_FIELD_DESC = new TField("compaction_strategy_options", 13, 30);
    private static final TField ROW_CACHE_KEYS_TO_SAVE_FIELD_DESC = new TField("row_cache_keys_to_save", 8, 31);
    private static final TField COMPRESSION_OPTIONS_FIELD_DESC = new TField("compression_options", 13, 32);
    private static final TField BLOOM_FILTER_FP_CHANCE_FIELD_DESC = new TField("bloom_filter_fp_chance", 4, 33);
    public String keyspace;
    public String name;
    public String column_type;
    public String comparator_type;
    public String subcomparator_type;
    public String comment;
    public double row_cache_size;
    public double key_cache_size;
    public double read_repair_chance;
    public List<ColumnDef> column_metadata;
    public int gc_grace_seconds;
    public String default_validation_class;
    public int id;
    public int min_compaction_threshold;
    public int max_compaction_threshold;
    public int row_cache_save_period_in_seconds;
    public int key_cache_save_period_in_seconds;
    public boolean replicate_on_write;
    public double merge_shards_chance;
    public String key_validation_class;
    public String row_cache_provider;
    public ByteBuffer key_alias;
    public String compaction_strategy;
    public Map<String, String> compaction_strategy_options;
    public int row_cache_keys_to_save;
    public Map<String, String> compression_options;
    public double bloom_filter_fp_chance;
    private static final int __ROW_CACHE_SIZE_ISSET_ID = 0;
    private static final int __KEY_CACHE_SIZE_ISSET_ID = 1;
    private static final int __READ_REPAIR_CHANCE_ISSET_ID = 2;
    private static final int __GC_GRACE_SECONDS_ISSET_ID = 3;
    private static final int __ID_ISSET_ID = 4;
    private static final int __MIN_COMPACTION_THRESHOLD_ISSET_ID = 5;
    private static final int __MAX_COMPACTION_THRESHOLD_ISSET_ID = 6;
    private static final int __ROW_CACHE_SAVE_PERIOD_IN_SECONDS_ISSET_ID = 7;
    private static final int __KEY_CACHE_SAVE_PERIOD_IN_SECONDS_ISSET_ID = 8;
    private static final int __REPLICATE_ON_WRITE_ISSET_ID = 9;
    private static final int __MERGE_SHARDS_CHANCE_ISSET_ID = 10;
    private static final int __ROW_CACHE_KEYS_TO_SAVE_ISSET_ID = 11;
    private static final int __BLOOM_FILTER_FP_CHANCE_ISSET_ID = 12;
    private BitSet __isset_bit_vector = new BitSet(13);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CfDef() {
        this.column_type = "Standard";
        this.comparator_type = "BytesType";
        this.row_cache_size = 0.0;
        this.key_cache_size = 200000.0;
        this.read_repair_chance = 1.0;
    }

    public CfDef(String keyspace, String name) {
        this();
        this.keyspace = keyspace;
        this.name = name;
    }

    public CfDef(CfDef other) {
        String other_element_value;
        String other_element_key;
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        if (other.isSetKeyspace()) {
            this.keyspace = other.keyspace;
        }
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetColumn_type()) {
            this.column_type = other.column_type;
        }
        if (other.isSetComparator_type()) {
            this.comparator_type = other.comparator_type;
        }
        if (other.isSetSubcomparator_type()) {
            this.subcomparator_type = other.subcomparator_type;
        }
        if (other.isSetComment()) {
            this.comment = other.comment;
        }
        this.row_cache_size = other.row_cache_size;
        this.key_cache_size = other.key_cache_size;
        this.read_repair_chance = other.read_repair_chance;
        if (other.isSetColumn_metadata()) {
            ArrayList<ColumnDef> __this__column_metadata = new ArrayList<ColumnDef>();
            for (ColumnDef columnDef : other.column_metadata) {
                __this__column_metadata.add(new ColumnDef(columnDef));
            }
            this.column_metadata = __this__column_metadata;
        }
        this.gc_grace_seconds = other.gc_grace_seconds;
        if (other.isSetDefault_validation_class()) {
            this.default_validation_class = other.default_validation_class;
        }
        this.id = other.id;
        this.min_compaction_threshold = other.min_compaction_threshold;
        this.max_compaction_threshold = other.max_compaction_threshold;
        this.row_cache_save_period_in_seconds = other.row_cache_save_period_in_seconds;
        this.key_cache_save_period_in_seconds = other.key_cache_save_period_in_seconds;
        this.replicate_on_write = other.replicate_on_write;
        this.merge_shards_chance = other.merge_shards_chance;
        if (other.isSetKey_validation_class()) {
            this.key_validation_class = other.key_validation_class;
        }
        if (other.isSetRow_cache_provider()) {
            this.row_cache_provider = other.row_cache_provider;
        }
        if (other.isSetKey_alias()) {
            this.key_alias = TBaseHelper.copyBinary((ByteBuffer)other.key_alias);
        }
        if (other.isSetCompaction_strategy()) {
            this.compaction_strategy = other.compaction_strategy;
        }
        if (other.isSetCompaction_strategy_options()) {
            HashMap<String, String> __this__compaction_strategy_options = new HashMap<String, String>();
            for (Map.Entry entry : other.compaction_strategy_options.entrySet()) {
                other_element_key = (String)entry.getKey();
                other_element_value = (String)entry.getValue();
                String __this__compaction_strategy_options_copy_key = other_element_key;
                String __this__compaction_strategy_options_copy_value = other_element_value;
                __this__compaction_strategy_options.put(__this__compaction_strategy_options_copy_key, __this__compaction_strategy_options_copy_value);
            }
            this.compaction_strategy_options = __this__compaction_strategy_options;
        }
        this.row_cache_keys_to_save = other.row_cache_keys_to_save;
        if (other.isSetCompression_options()) {
            HashMap<String, String> __this__compression_options = new HashMap<String, String>();
            for (Map.Entry entry : other.compression_options.entrySet()) {
                other_element_key = (String)entry.getKey();
                other_element_value = (String)entry.getValue();
                String __this__compression_options_copy_key = other_element_key;
                String __this__compression_options_copy_value = other_element_value;
                __this__compression_options.put(__this__compression_options_copy_key, __this__compression_options_copy_value);
            }
            this.compression_options = __this__compression_options;
        }
        this.bloom_filter_fp_chance = other.bloom_filter_fp_chance;
    }

    public CfDef deepCopy() {
        return new CfDef(this);
    }

    public void clear() {
        this.keyspace = null;
        this.name = null;
        this.column_type = "Standard";
        this.comparator_type = "BytesType";
        this.subcomparator_type = null;
        this.comment = null;
        this.row_cache_size = 0.0;
        this.key_cache_size = 200000.0;
        this.read_repair_chance = 1.0;
        this.column_metadata = null;
        this.setGc_grace_secondsIsSet(false);
        this.gc_grace_seconds = 0;
        this.default_validation_class = null;
        this.setIdIsSet(false);
        this.id = 0;
        this.setMin_compaction_thresholdIsSet(false);
        this.min_compaction_threshold = 0;
        this.setMax_compaction_thresholdIsSet(false);
        this.max_compaction_threshold = 0;
        this.setRow_cache_save_period_in_secondsIsSet(false);
        this.row_cache_save_period_in_seconds = 0;
        this.setKey_cache_save_period_in_secondsIsSet(false);
        this.key_cache_save_period_in_seconds = 0;
        this.setReplicate_on_writeIsSet(false);
        this.replicate_on_write = false;
        this.setMerge_shards_chanceIsSet(false);
        this.merge_shards_chance = 0.0;
        this.key_validation_class = null;
        this.row_cache_provider = null;
        this.key_alias = null;
        this.compaction_strategy = null;
        this.compaction_strategy_options = null;
        this.setRow_cache_keys_to_saveIsSet(false);
        this.row_cache_keys_to_save = 0;
        this.compression_options = null;
        this.setBloom_filter_fp_chanceIsSet(false);
        this.bloom_filter_fp_chance = 0.0;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CfDef setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public void unsetKeyspace() {
        this.keyspace = null;
    }

    public boolean isSetKeyspace() {
        return this.keyspace != null;
    }

    public void setKeyspaceIsSet(boolean value) {
        if (!value) {
            this.keyspace = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public CfDef setName(String name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public String getColumn_type() {
        return this.column_type;
    }

    public CfDef setColumn_type(String column_type) {
        this.column_type = column_type;
        return this;
    }

    public void unsetColumn_type() {
        this.column_type = null;
    }

    public boolean isSetColumn_type() {
        return this.column_type != null;
    }

    public void setColumn_typeIsSet(boolean value) {
        if (!value) {
            this.column_type = null;
        }
    }

    public String getComparator_type() {
        return this.comparator_type;
    }

    public CfDef setComparator_type(String comparator_type) {
        this.comparator_type = comparator_type;
        return this;
    }

    public void unsetComparator_type() {
        this.comparator_type = null;
    }

    public boolean isSetComparator_type() {
        return this.comparator_type != null;
    }

    public void setComparator_typeIsSet(boolean value) {
        if (!value) {
            this.comparator_type = null;
        }
    }

    public String getSubcomparator_type() {
        return this.subcomparator_type;
    }

    public CfDef setSubcomparator_type(String subcomparator_type) {
        this.subcomparator_type = subcomparator_type;
        return this;
    }

    public void unsetSubcomparator_type() {
        this.subcomparator_type = null;
    }

    public boolean isSetSubcomparator_type() {
        return this.subcomparator_type != null;
    }

    public void setSubcomparator_typeIsSet(boolean value) {
        if (!value) {
            this.subcomparator_type = null;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public CfDef setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public void unsetComment() {
        this.comment = null;
    }

    public boolean isSetComment() {
        return this.comment != null;
    }

    public void setCommentIsSet(boolean value) {
        if (!value) {
            this.comment = null;
        }
    }

    public double getRow_cache_size() {
        return this.row_cache_size;
    }

    public CfDef setRow_cache_size(double row_cache_size) {
        this.row_cache_size = row_cache_size;
        this.setRow_cache_sizeIsSet(true);
        return this;
    }

    public void unsetRow_cache_size() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetRow_cache_size() {
        return this.__isset_bit_vector.get(0);
    }

    public void setRow_cache_sizeIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public double getKey_cache_size() {
        return this.key_cache_size;
    }

    public CfDef setKey_cache_size(double key_cache_size) {
        this.key_cache_size = key_cache_size;
        this.setKey_cache_sizeIsSet(true);
        return this;
    }

    public void unsetKey_cache_size() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetKey_cache_size() {
        return this.__isset_bit_vector.get(1);
    }

    public void setKey_cache_sizeIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public double getRead_repair_chance() {
        return this.read_repair_chance;
    }

    public CfDef setRead_repair_chance(double read_repair_chance) {
        this.read_repair_chance = read_repair_chance;
        this.setRead_repair_chanceIsSet(true);
        return this;
    }

    public void unsetRead_repair_chance() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetRead_repair_chance() {
        return this.__isset_bit_vector.get(2);
    }

    public void setRead_repair_chanceIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public int getColumn_metadataSize() {
        return this.column_metadata == null ? 0 : this.column_metadata.size();
    }

    public Iterator<ColumnDef> getColumn_metadataIterator() {
        return this.column_metadata == null ? null : this.column_metadata.iterator();
    }

    public void addToColumn_metadata(ColumnDef elem) {
        if (this.column_metadata == null) {
            this.column_metadata = new ArrayList<ColumnDef>();
        }
        this.column_metadata.add(elem);
    }

    public List<ColumnDef> getColumn_metadata() {
        return this.column_metadata;
    }

    public CfDef setColumn_metadata(List<ColumnDef> column_metadata) {
        this.column_metadata = column_metadata;
        return this;
    }

    public void unsetColumn_metadata() {
        this.column_metadata = null;
    }

    public boolean isSetColumn_metadata() {
        return this.column_metadata != null;
    }

    public void setColumn_metadataIsSet(boolean value) {
        if (!value) {
            this.column_metadata = null;
        }
    }

    public int getGc_grace_seconds() {
        return this.gc_grace_seconds;
    }

    public CfDef setGc_grace_seconds(int gc_grace_seconds) {
        this.gc_grace_seconds = gc_grace_seconds;
        this.setGc_grace_secondsIsSet(true);
        return this;
    }

    public void unsetGc_grace_seconds() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetGc_grace_seconds() {
        return this.__isset_bit_vector.get(3);
    }

    public void setGc_grace_secondsIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    public String getDefault_validation_class() {
        return this.default_validation_class;
    }

    public CfDef setDefault_validation_class(String default_validation_class) {
        this.default_validation_class = default_validation_class;
        return this;
    }

    public void unsetDefault_validation_class() {
        this.default_validation_class = null;
    }

    public boolean isSetDefault_validation_class() {
        return this.default_validation_class != null;
    }

    public void setDefault_validation_classIsSet(boolean value) {
        if (!value) {
            this.default_validation_class = null;
        }
    }

    public int getId() {
        return this.id;
    }

    public CfDef setId(int id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bit_vector.clear(4);
    }

    public boolean isSetId() {
        return this.__isset_bit_vector.get(4);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bit_vector.set(4, value);
    }

    public int getMin_compaction_threshold() {
        return this.min_compaction_threshold;
    }

    public CfDef setMin_compaction_threshold(int min_compaction_threshold) {
        this.min_compaction_threshold = min_compaction_threshold;
        this.setMin_compaction_thresholdIsSet(true);
        return this;
    }

    public void unsetMin_compaction_threshold() {
        this.__isset_bit_vector.clear(5);
    }

    public boolean isSetMin_compaction_threshold() {
        return this.__isset_bit_vector.get(5);
    }

    public void setMin_compaction_thresholdIsSet(boolean value) {
        this.__isset_bit_vector.set(5, value);
    }

    public int getMax_compaction_threshold() {
        return this.max_compaction_threshold;
    }

    public CfDef setMax_compaction_threshold(int max_compaction_threshold) {
        this.max_compaction_threshold = max_compaction_threshold;
        this.setMax_compaction_thresholdIsSet(true);
        return this;
    }

    public void unsetMax_compaction_threshold() {
        this.__isset_bit_vector.clear(6);
    }

    public boolean isSetMax_compaction_threshold() {
        return this.__isset_bit_vector.get(6);
    }

    public void setMax_compaction_thresholdIsSet(boolean value) {
        this.__isset_bit_vector.set(6, value);
    }

    public int getRow_cache_save_period_in_seconds() {
        return this.row_cache_save_period_in_seconds;
    }

    public CfDef setRow_cache_save_period_in_seconds(int row_cache_save_period_in_seconds) {
        this.row_cache_save_period_in_seconds = row_cache_save_period_in_seconds;
        this.setRow_cache_save_period_in_secondsIsSet(true);
        return this;
    }

    public void unsetRow_cache_save_period_in_seconds() {
        this.__isset_bit_vector.clear(7);
    }

    public boolean isSetRow_cache_save_period_in_seconds() {
        return this.__isset_bit_vector.get(7);
    }

    public void setRow_cache_save_period_in_secondsIsSet(boolean value) {
        this.__isset_bit_vector.set(7, value);
    }

    public int getKey_cache_save_period_in_seconds() {
        return this.key_cache_save_period_in_seconds;
    }

    public CfDef setKey_cache_save_period_in_seconds(int key_cache_save_period_in_seconds) {
        this.key_cache_save_period_in_seconds = key_cache_save_period_in_seconds;
        this.setKey_cache_save_period_in_secondsIsSet(true);
        return this;
    }

    public void unsetKey_cache_save_period_in_seconds() {
        this.__isset_bit_vector.clear(8);
    }

    public boolean isSetKey_cache_save_period_in_seconds() {
        return this.__isset_bit_vector.get(8);
    }

    public void setKey_cache_save_period_in_secondsIsSet(boolean value) {
        this.__isset_bit_vector.set(8, value);
    }

    public boolean isReplicate_on_write() {
        return this.replicate_on_write;
    }

    public CfDef setReplicate_on_write(boolean replicate_on_write) {
        this.replicate_on_write = replicate_on_write;
        this.setReplicate_on_writeIsSet(true);
        return this;
    }

    public void unsetReplicate_on_write() {
        this.__isset_bit_vector.clear(9);
    }

    public boolean isSetReplicate_on_write() {
        return this.__isset_bit_vector.get(9);
    }

    public void setReplicate_on_writeIsSet(boolean value) {
        this.__isset_bit_vector.set(9, value);
    }

    public double getMerge_shards_chance() {
        return this.merge_shards_chance;
    }

    public CfDef setMerge_shards_chance(double merge_shards_chance) {
        this.merge_shards_chance = merge_shards_chance;
        this.setMerge_shards_chanceIsSet(true);
        return this;
    }

    public void unsetMerge_shards_chance() {
        this.__isset_bit_vector.clear(10);
    }

    public boolean isSetMerge_shards_chance() {
        return this.__isset_bit_vector.get(10);
    }

    public void setMerge_shards_chanceIsSet(boolean value) {
        this.__isset_bit_vector.set(10, value);
    }

    public String getKey_validation_class() {
        return this.key_validation_class;
    }

    public CfDef setKey_validation_class(String key_validation_class) {
        this.key_validation_class = key_validation_class;
        return this;
    }

    public void unsetKey_validation_class() {
        this.key_validation_class = null;
    }

    public boolean isSetKey_validation_class() {
        return this.key_validation_class != null;
    }

    public void setKey_validation_classIsSet(boolean value) {
        if (!value) {
            this.key_validation_class = null;
        }
    }

    public String getRow_cache_provider() {
        return this.row_cache_provider;
    }

    public CfDef setRow_cache_provider(String row_cache_provider) {
        this.row_cache_provider = row_cache_provider;
        return this;
    }

    public void unsetRow_cache_provider() {
        this.row_cache_provider = null;
    }

    public boolean isSetRow_cache_provider() {
        return this.row_cache_provider != null;
    }

    public void setRow_cache_providerIsSet(boolean value) {
        if (!value) {
            this.row_cache_provider = null;
        }
    }

    public byte[] getKey_alias() {
        this.setKey_alias(TBaseHelper.rightSize((ByteBuffer)this.key_alias));
        return this.key_alias == null ? null : this.key_alias.array();
    }

    public ByteBuffer bufferForKey_alias() {
        return this.key_alias;
    }

    public CfDef setKey_alias(byte[] key_alias) {
        this.setKey_alias(key_alias == null ? (ByteBuffer)null : ByteBuffer.wrap(key_alias));
        return this;
    }

    public CfDef setKey_alias(ByteBuffer key_alias) {
        this.key_alias = key_alias;
        return this;
    }

    public void unsetKey_alias() {
        this.key_alias = null;
    }

    public boolean isSetKey_alias() {
        return this.key_alias != null;
    }

    public void setKey_aliasIsSet(boolean value) {
        if (!value) {
            this.key_alias = null;
        }
    }

    public String getCompaction_strategy() {
        return this.compaction_strategy;
    }

    public CfDef setCompaction_strategy(String compaction_strategy) {
        this.compaction_strategy = compaction_strategy;
        return this;
    }

    public void unsetCompaction_strategy() {
        this.compaction_strategy = null;
    }

    public boolean isSetCompaction_strategy() {
        return this.compaction_strategy != null;
    }

    public void setCompaction_strategyIsSet(boolean value) {
        if (!value) {
            this.compaction_strategy = null;
        }
    }

    public int getCompaction_strategy_optionsSize() {
        return this.compaction_strategy_options == null ? 0 : this.compaction_strategy_options.size();
    }

    public void putToCompaction_strategy_options(String key, String val) {
        if (this.compaction_strategy_options == null) {
            this.compaction_strategy_options = new HashMap<String, String>();
        }
        this.compaction_strategy_options.put(key, val);
    }

    public Map<String, String> getCompaction_strategy_options() {
        return this.compaction_strategy_options;
    }

    public CfDef setCompaction_strategy_options(Map<String, String> compaction_strategy_options) {
        this.compaction_strategy_options = compaction_strategy_options;
        return this;
    }

    public void unsetCompaction_strategy_options() {
        this.compaction_strategy_options = null;
    }

    public boolean isSetCompaction_strategy_options() {
        return this.compaction_strategy_options != null;
    }

    public void setCompaction_strategy_optionsIsSet(boolean value) {
        if (!value) {
            this.compaction_strategy_options = null;
        }
    }

    public int getRow_cache_keys_to_save() {
        return this.row_cache_keys_to_save;
    }

    public CfDef setRow_cache_keys_to_save(int row_cache_keys_to_save) {
        this.row_cache_keys_to_save = row_cache_keys_to_save;
        this.setRow_cache_keys_to_saveIsSet(true);
        return this;
    }

    public void unsetRow_cache_keys_to_save() {
        this.__isset_bit_vector.clear(11);
    }

    public boolean isSetRow_cache_keys_to_save() {
        return this.__isset_bit_vector.get(11);
    }

    public void setRow_cache_keys_to_saveIsSet(boolean value) {
        this.__isset_bit_vector.set(11, value);
    }

    public int getCompression_optionsSize() {
        return this.compression_options == null ? 0 : this.compression_options.size();
    }

    public void putToCompression_options(String key, String val) {
        if (this.compression_options == null) {
            this.compression_options = new HashMap<String, String>();
        }
        this.compression_options.put(key, val);
    }

    public Map<String, String> getCompression_options() {
        return this.compression_options;
    }

    public CfDef setCompression_options(Map<String, String> compression_options) {
        this.compression_options = compression_options;
        return this;
    }

    public void unsetCompression_options() {
        this.compression_options = null;
    }

    public boolean isSetCompression_options() {
        return this.compression_options != null;
    }

    public void setCompression_optionsIsSet(boolean value) {
        if (!value) {
            this.compression_options = null;
        }
    }

    public double getBloom_filter_fp_chance() {
        return this.bloom_filter_fp_chance;
    }

    public CfDef setBloom_filter_fp_chance(double bloom_filter_fp_chance) {
        this.bloom_filter_fp_chance = bloom_filter_fp_chance;
        this.setBloom_filter_fp_chanceIsSet(true);
        return this;
    }

    public void unsetBloom_filter_fp_chance() {
        this.__isset_bit_vector.clear(12);
    }

    public boolean isSetBloom_filter_fp_chance() {
        return this.__isset_bit_vector.get(12);
    }

    public void setBloom_filter_fp_chanceIsSet(boolean value) {
        this.__isset_bit_vector.set(12, value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEYSPACE: {
                if (value == null) {
                    this.unsetKeyspace();
                    break;
                }
                this.setKeyspace((String)value);
                break;
            }
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case COLUMN_TYPE: {
                if (value == null) {
                    this.unsetColumn_type();
                    break;
                }
                this.setColumn_type((String)value);
                break;
            }
            case COMPARATOR_TYPE: {
                if (value == null) {
                    this.unsetComparator_type();
                    break;
                }
                this.setComparator_type((String)value);
                break;
            }
            case SUBCOMPARATOR_TYPE: {
                if (value == null) {
                    this.unsetSubcomparator_type();
                    break;
                }
                this.setSubcomparator_type((String)value);
                break;
            }
            case COMMENT: {
                if (value == null) {
                    this.unsetComment();
                    break;
                }
                this.setComment((String)value);
                break;
            }
            case ROW_CACHE_SIZE: {
                if (value == null) {
                    this.unsetRow_cache_size();
                    break;
                }
                this.setRow_cache_size((Double)value);
                break;
            }
            case KEY_CACHE_SIZE: {
                if (value == null) {
                    this.unsetKey_cache_size();
                    break;
                }
                this.setKey_cache_size((Double)value);
                break;
            }
            case READ_REPAIR_CHANCE: {
                if (value == null) {
                    this.unsetRead_repair_chance();
                    break;
                }
                this.setRead_repair_chance((Double)value);
                break;
            }
            case COLUMN_METADATA: {
                if (value == null) {
                    this.unsetColumn_metadata();
                    break;
                }
                this.setColumn_metadata((List)value);
                break;
            }
            case GC_GRACE_SECONDS: {
                if (value == null) {
                    this.unsetGc_grace_seconds();
                    break;
                }
                this.setGc_grace_seconds((Integer)value);
                break;
            }
            case DEFAULT_VALIDATION_CLASS: {
                if (value == null) {
                    this.unsetDefault_validation_class();
                    break;
                }
                this.setDefault_validation_class((String)value);
                break;
            }
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Integer)value);
                break;
            }
            case MIN_COMPACTION_THRESHOLD: {
                if (value == null) {
                    this.unsetMin_compaction_threshold();
                    break;
                }
                this.setMin_compaction_threshold((Integer)value);
                break;
            }
            case MAX_COMPACTION_THRESHOLD: {
                if (value == null) {
                    this.unsetMax_compaction_threshold();
                    break;
                }
                this.setMax_compaction_threshold((Integer)value);
                break;
            }
            case ROW_CACHE_SAVE_PERIOD_IN_SECONDS: {
                if (value == null) {
                    this.unsetRow_cache_save_period_in_seconds();
                    break;
                }
                this.setRow_cache_save_period_in_seconds((Integer)value);
                break;
            }
            case KEY_CACHE_SAVE_PERIOD_IN_SECONDS: {
                if (value == null) {
                    this.unsetKey_cache_save_period_in_seconds();
                    break;
                }
                this.setKey_cache_save_period_in_seconds((Integer)value);
                break;
            }
            case REPLICATE_ON_WRITE: {
                if (value == null) {
                    this.unsetReplicate_on_write();
                    break;
                }
                this.setReplicate_on_write((Boolean)value);
                break;
            }
            case MERGE_SHARDS_CHANCE: {
                if (value == null) {
                    this.unsetMerge_shards_chance();
                    break;
                }
                this.setMerge_shards_chance((Double)value);
                break;
            }
            case KEY_VALIDATION_CLASS: {
                if (value == null) {
                    this.unsetKey_validation_class();
                    break;
                }
                this.setKey_validation_class((String)value);
                break;
            }
            case ROW_CACHE_PROVIDER: {
                if (value == null) {
                    this.unsetRow_cache_provider();
                    break;
                }
                this.setRow_cache_provider((String)value);
                break;
            }
            case KEY_ALIAS: {
                if (value == null) {
                    this.unsetKey_alias();
                    break;
                }
                this.setKey_alias((ByteBuffer)value);
                break;
            }
            case COMPACTION_STRATEGY: {
                if (value == null) {
                    this.unsetCompaction_strategy();
                    break;
                }
                this.setCompaction_strategy((String)value);
                break;
            }
            case COMPACTION_STRATEGY_OPTIONS: {
                if (value == null) {
                    this.unsetCompaction_strategy_options();
                    break;
                }
                this.setCompaction_strategy_options((Map)value);
                break;
            }
            case ROW_CACHE_KEYS_TO_SAVE: {
                if (value == null) {
                    this.unsetRow_cache_keys_to_save();
                    break;
                }
                this.setRow_cache_keys_to_save((Integer)value);
                break;
            }
            case COMPRESSION_OPTIONS: {
                if (value == null) {
                    this.unsetCompression_options();
                    break;
                }
                this.setCompression_options((Map)value);
                break;
            }
            case BLOOM_FILTER_FP_CHANCE: {
                if (value == null) {
                    this.unsetBloom_filter_fp_chance();
                    break;
                }
                this.setBloom_filter_fp_chance((Double)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEYSPACE: {
                return this.getKeyspace();
            }
            case NAME: {
                return this.getName();
            }
            case COLUMN_TYPE: {
                return this.getColumn_type();
            }
            case COMPARATOR_TYPE: {
                return this.getComparator_type();
            }
            case SUBCOMPARATOR_TYPE: {
                return this.getSubcomparator_type();
            }
            case COMMENT: {
                return this.getComment();
            }
            case ROW_CACHE_SIZE: {
                return new Double(this.getRow_cache_size());
            }
            case KEY_CACHE_SIZE: {
                return new Double(this.getKey_cache_size());
            }
            case READ_REPAIR_CHANCE: {
                return new Double(this.getRead_repair_chance());
            }
            case COLUMN_METADATA: {
                return this.getColumn_metadata();
            }
            case GC_GRACE_SECONDS: {
                return new Integer(this.getGc_grace_seconds());
            }
            case DEFAULT_VALIDATION_CLASS: {
                return this.getDefault_validation_class();
            }
            case ID: {
                return new Integer(this.getId());
            }
            case MIN_COMPACTION_THRESHOLD: {
                return new Integer(this.getMin_compaction_threshold());
            }
            case MAX_COMPACTION_THRESHOLD: {
                return new Integer(this.getMax_compaction_threshold());
            }
            case ROW_CACHE_SAVE_PERIOD_IN_SECONDS: {
                return new Integer(this.getRow_cache_save_period_in_seconds());
            }
            case KEY_CACHE_SAVE_PERIOD_IN_SECONDS: {
                return new Integer(this.getKey_cache_save_period_in_seconds());
            }
            case REPLICATE_ON_WRITE: {
                return new Boolean(this.isReplicate_on_write());
            }
            case MERGE_SHARDS_CHANCE: {
                return new Double(this.getMerge_shards_chance());
            }
            case KEY_VALIDATION_CLASS: {
                return this.getKey_validation_class();
            }
            case ROW_CACHE_PROVIDER: {
                return this.getRow_cache_provider();
            }
            case KEY_ALIAS: {
                return this.getKey_alias();
            }
            case COMPACTION_STRATEGY: {
                return this.getCompaction_strategy();
            }
            case COMPACTION_STRATEGY_OPTIONS: {
                return this.getCompaction_strategy_options();
            }
            case ROW_CACHE_KEYS_TO_SAVE: {
                return new Integer(this.getRow_cache_keys_to_save());
            }
            case COMPRESSION_OPTIONS: {
                return this.getCompression_options();
            }
            case BLOOM_FILTER_FP_CHANCE: {
                return new Double(this.getBloom_filter_fp_chance());
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEYSPACE: {
                return this.isSetKeyspace();
            }
            case NAME: {
                return this.isSetName();
            }
            case COLUMN_TYPE: {
                return this.isSetColumn_type();
            }
            case COMPARATOR_TYPE: {
                return this.isSetComparator_type();
            }
            case SUBCOMPARATOR_TYPE: {
                return this.isSetSubcomparator_type();
            }
            case COMMENT: {
                return this.isSetComment();
            }
            case ROW_CACHE_SIZE: {
                return this.isSetRow_cache_size();
            }
            case KEY_CACHE_SIZE: {
                return this.isSetKey_cache_size();
            }
            case READ_REPAIR_CHANCE: {
                return this.isSetRead_repair_chance();
            }
            case COLUMN_METADATA: {
                return this.isSetColumn_metadata();
            }
            case GC_GRACE_SECONDS: {
                return this.isSetGc_grace_seconds();
            }
            case DEFAULT_VALIDATION_CLASS: {
                return this.isSetDefault_validation_class();
            }
            case ID: {
                return this.isSetId();
            }
            case MIN_COMPACTION_THRESHOLD: {
                return this.isSetMin_compaction_threshold();
            }
            case MAX_COMPACTION_THRESHOLD: {
                return this.isSetMax_compaction_threshold();
            }
            case ROW_CACHE_SAVE_PERIOD_IN_SECONDS: {
                return this.isSetRow_cache_save_period_in_seconds();
            }
            case KEY_CACHE_SAVE_PERIOD_IN_SECONDS: {
                return this.isSetKey_cache_save_period_in_seconds();
            }
            case REPLICATE_ON_WRITE: {
                return this.isSetReplicate_on_write();
            }
            case MERGE_SHARDS_CHANCE: {
                return this.isSetMerge_shards_chance();
            }
            case KEY_VALIDATION_CLASS: {
                return this.isSetKey_validation_class();
            }
            case ROW_CACHE_PROVIDER: {
                return this.isSetRow_cache_provider();
            }
            case KEY_ALIAS: {
                return this.isSetKey_alias();
            }
            case COMPACTION_STRATEGY: {
                return this.isSetCompaction_strategy();
            }
            case COMPACTION_STRATEGY_OPTIONS: {
                return this.isSetCompaction_strategy_options();
            }
            case ROW_CACHE_KEYS_TO_SAVE: {
                return this.isSetRow_cache_keys_to_save();
            }
            case COMPRESSION_OPTIONS: {
                return this.isSetCompression_options();
            }
            case BLOOM_FILTER_FP_CHANCE: {
                return this.isSetBloom_filter_fp_chance();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof CfDef) {
            return this.equals((CfDef)that);
        }
        return false;
    }

    public boolean equals(CfDef that) {
        if (that == null) {
            return false;
        }
        boolean this_present_keyspace = this.isSetKeyspace();
        boolean that_present_keyspace = that.isSetKeyspace();
        if (this_present_keyspace || that_present_keyspace) {
            if (!this_present_keyspace || !that_present_keyspace) {
                return false;
            }
            if (!this.keyspace.equals(that.keyspace)) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_column_type = this.isSetColumn_type();
        boolean that_present_column_type = that.isSetColumn_type();
        if (this_present_column_type || that_present_column_type) {
            if (!this_present_column_type || !that_present_column_type) {
                return false;
            }
            if (!this.column_type.equals(that.column_type)) {
                return false;
            }
        }
        boolean this_present_comparator_type = this.isSetComparator_type();
        boolean that_present_comparator_type = that.isSetComparator_type();
        if (this_present_comparator_type || that_present_comparator_type) {
            if (!this_present_comparator_type || !that_present_comparator_type) {
                return false;
            }
            if (!this.comparator_type.equals(that.comparator_type)) {
                return false;
            }
        }
        boolean this_present_subcomparator_type = this.isSetSubcomparator_type();
        boolean that_present_subcomparator_type = that.isSetSubcomparator_type();
        if (this_present_subcomparator_type || that_present_subcomparator_type) {
            if (!this_present_subcomparator_type || !that_present_subcomparator_type) {
                return false;
            }
            if (!this.subcomparator_type.equals(that.subcomparator_type)) {
                return false;
            }
        }
        boolean this_present_comment = this.isSetComment();
        boolean that_present_comment = that.isSetComment();
        if (this_present_comment || that_present_comment) {
            if (!this_present_comment || !that_present_comment) {
                return false;
            }
            if (!this.comment.equals(that.comment)) {
                return false;
            }
        }
        boolean this_present_row_cache_size = this.isSetRow_cache_size();
        boolean that_present_row_cache_size = that.isSetRow_cache_size();
        if (this_present_row_cache_size || that_present_row_cache_size) {
            if (!this_present_row_cache_size || !that_present_row_cache_size) {
                return false;
            }
            if (this.row_cache_size != that.row_cache_size) {
                return false;
            }
        }
        boolean this_present_key_cache_size = this.isSetKey_cache_size();
        boolean that_present_key_cache_size = that.isSetKey_cache_size();
        if (this_present_key_cache_size || that_present_key_cache_size) {
            if (!this_present_key_cache_size || !that_present_key_cache_size) {
                return false;
            }
            if (this.key_cache_size != that.key_cache_size) {
                return false;
            }
        }
        boolean this_present_read_repair_chance = this.isSetRead_repair_chance();
        boolean that_present_read_repair_chance = that.isSetRead_repair_chance();
        if (this_present_read_repair_chance || that_present_read_repair_chance) {
            if (!this_present_read_repair_chance || !that_present_read_repair_chance) {
                return false;
            }
            if (this.read_repair_chance != that.read_repair_chance) {
                return false;
            }
        }
        boolean this_present_column_metadata = this.isSetColumn_metadata();
        boolean that_present_column_metadata = that.isSetColumn_metadata();
        if (this_present_column_metadata || that_present_column_metadata) {
            if (!this_present_column_metadata || !that_present_column_metadata) {
                return false;
            }
            if (!((Object)this.column_metadata).equals(that.column_metadata)) {
                return false;
            }
        }
        boolean this_present_gc_grace_seconds = this.isSetGc_grace_seconds();
        boolean that_present_gc_grace_seconds = that.isSetGc_grace_seconds();
        if (this_present_gc_grace_seconds || that_present_gc_grace_seconds) {
            if (!this_present_gc_grace_seconds || !that_present_gc_grace_seconds) {
                return false;
            }
            if (this.gc_grace_seconds != that.gc_grace_seconds) {
                return false;
            }
        }
        boolean this_present_default_validation_class = this.isSetDefault_validation_class();
        boolean that_present_default_validation_class = that.isSetDefault_validation_class();
        if (this_present_default_validation_class || that_present_default_validation_class) {
            if (!this_present_default_validation_class || !that_present_default_validation_class) {
                return false;
            }
            if (!this.default_validation_class.equals(that.default_validation_class)) {
                return false;
            }
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_min_compaction_threshold = this.isSetMin_compaction_threshold();
        boolean that_present_min_compaction_threshold = that.isSetMin_compaction_threshold();
        if (this_present_min_compaction_threshold || that_present_min_compaction_threshold) {
            if (!this_present_min_compaction_threshold || !that_present_min_compaction_threshold) {
                return false;
            }
            if (this.min_compaction_threshold != that.min_compaction_threshold) {
                return false;
            }
        }
        boolean this_present_max_compaction_threshold = this.isSetMax_compaction_threshold();
        boolean that_present_max_compaction_threshold = that.isSetMax_compaction_threshold();
        if (this_present_max_compaction_threshold || that_present_max_compaction_threshold) {
            if (!this_present_max_compaction_threshold || !that_present_max_compaction_threshold) {
                return false;
            }
            if (this.max_compaction_threshold != that.max_compaction_threshold) {
                return false;
            }
        }
        boolean this_present_row_cache_save_period_in_seconds = this.isSetRow_cache_save_period_in_seconds();
        boolean that_present_row_cache_save_period_in_seconds = that.isSetRow_cache_save_period_in_seconds();
        if (this_present_row_cache_save_period_in_seconds || that_present_row_cache_save_period_in_seconds) {
            if (!this_present_row_cache_save_period_in_seconds || !that_present_row_cache_save_period_in_seconds) {
                return false;
            }
            if (this.row_cache_save_period_in_seconds != that.row_cache_save_period_in_seconds) {
                return false;
            }
        }
        boolean this_present_key_cache_save_period_in_seconds = this.isSetKey_cache_save_period_in_seconds();
        boolean that_present_key_cache_save_period_in_seconds = that.isSetKey_cache_save_period_in_seconds();
        if (this_present_key_cache_save_period_in_seconds || that_present_key_cache_save_period_in_seconds) {
            if (!this_present_key_cache_save_period_in_seconds || !that_present_key_cache_save_period_in_seconds) {
                return false;
            }
            if (this.key_cache_save_period_in_seconds != that.key_cache_save_period_in_seconds) {
                return false;
            }
        }
        boolean this_present_replicate_on_write = this.isSetReplicate_on_write();
        boolean that_present_replicate_on_write = that.isSetReplicate_on_write();
        if (this_present_replicate_on_write || that_present_replicate_on_write) {
            if (!this_present_replicate_on_write || !that_present_replicate_on_write) {
                return false;
            }
            if (this.replicate_on_write != that.replicate_on_write) {
                return false;
            }
        }
        boolean this_present_merge_shards_chance = this.isSetMerge_shards_chance();
        boolean that_present_merge_shards_chance = that.isSetMerge_shards_chance();
        if (this_present_merge_shards_chance || that_present_merge_shards_chance) {
            if (!this_present_merge_shards_chance || !that_present_merge_shards_chance) {
                return false;
            }
            if (this.merge_shards_chance != that.merge_shards_chance) {
                return false;
            }
        }
        boolean this_present_key_validation_class = this.isSetKey_validation_class();
        boolean that_present_key_validation_class = that.isSetKey_validation_class();
        if (this_present_key_validation_class || that_present_key_validation_class) {
            if (!this_present_key_validation_class || !that_present_key_validation_class) {
                return false;
            }
            if (!this.key_validation_class.equals(that.key_validation_class)) {
                return false;
            }
        }
        boolean this_present_row_cache_provider = this.isSetRow_cache_provider();
        boolean that_present_row_cache_provider = that.isSetRow_cache_provider();
        if (this_present_row_cache_provider || that_present_row_cache_provider) {
            if (!this_present_row_cache_provider || !that_present_row_cache_provider) {
                return false;
            }
            if (!this.row_cache_provider.equals(that.row_cache_provider)) {
                return false;
            }
        }
        boolean this_present_key_alias = this.isSetKey_alias();
        boolean that_present_key_alias = that.isSetKey_alias();
        if (this_present_key_alias || that_present_key_alias) {
            if (!this_present_key_alias || !that_present_key_alias) {
                return false;
            }
            if (!this.key_alias.equals(that.key_alias)) {
                return false;
            }
        }
        boolean this_present_compaction_strategy = this.isSetCompaction_strategy();
        boolean that_present_compaction_strategy = that.isSetCompaction_strategy();
        if (this_present_compaction_strategy || that_present_compaction_strategy) {
            if (!this_present_compaction_strategy || !that_present_compaction_strategy) {
                return false;
            }
            if (!this.compaction_strategy.equals(that.compaction_strategy)) {
                return false;
            }
        }
        boolean this_present_compaction_strategy_options = this.isSetCompaction_strategy_options();
        boolean that_present_compaction_strategy_options = that.isSetCompaction_strategy_options();
        if (this_present_compaction_strategy_options || that_present_compaction_strategy_options) {
            if (!this_present_compaction_strategy_options || !that_present_compaction_strategy_options) {
                return false;
            }
            if (!((Object)this.compaction_strategy_options).equals(that.compaction_strategy_options)) {
                return false;
            }
        }
        boolean this_present_row_cache_keys_to_save = this.isSetRow_cache_keys_to_save();
        boolean that_present_row_cache_keys_to_save = that.isSetRow_cache_keys_to_save();
        if (this_present_row_cache_keys_to_save || that_present_row_cache_keys_to_save) {
            if (!this_present_row_cache_keys_to_save || !that_present_row_cache_keys_to_save) {
                return false;
            }
            if (this.row_cache_keys_to_save != that.row_cache_keys_to_save) {
                return false;
            }
        }
        boolean this_present_compression_options = this.isSetCompression_options();
        boolean that_present_compression_options = that.isSetCompression_options();
        if (this_present_compression_options || that_present_compression_options) {
            if (!this_present_compression_options || !that_present_compression_options) {
                return false;
            }
            if (!((Object)this.compression_options).equals(that.compression_options)) {
                return false;
            }
        }
        boolean this_present_bloom_filter_fp_chance = this.isSetBloom_filter_fp_chance();
        boolean that_present_bloom_filter_fp_chance = that.isSetBloom_filter_fp_chance();
        if (this_present_bloom_filter_fp_chance || that_present_bloom_filter_fp_chance) {
            if (!this_present_bloom_filter_fp_chance || !that_present_bloom_filter_fp_chance) {
                return false;
            }
            if (this.bloom_filter_fp_chance != that.bloom_filter_fp_chance) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_keyspace = this.isSetKeyspace();
        builder.append(present_keyspace);
        if (present_keyspace) {
            builder.append((Object)this.keyspace);
        }
        boolean present_name = this.isSetName();
        builder.append(present_name);
        if (present_name) {
            builder.append((Object)this.name);
        }
        boolean present_column_type = this.isSetColumn_type();
        builder.append(present_column_type);
        if (present_column_type) {
            builder.append((Object)this.column_type);
        }
        boolean present_comparator_type = this.isSetComparator_type();
        builder.append(present_comparator_type);
        if (present_comparator_type) {
            builder.append((Object)this.comparator_type);
        }
        boolean present_subcomparator_type = this.isSetSubcomparator_type();
        builder.append(present_subcomparator_type);
        if (present_subcomparator_type) {
            builder.append((Object)this.subcomparator_type);
        }
        boolean present_comment = this.isSetComment();
        builder.append(present_comment);
        if (present_comment) {
            builder.append((Object)this.comment);
        }
        boolean present_row_cache_size = this.isSetRow_cache_size();
        builder.append(present_row_cache_size);
        if (present_row_cache_size) {
            builder.append(this.row_cache_size);
        }
        boolean present_key_cache_size = this.isSetKey_cache_size();
        builder.append(present_key_cache_size);
        if (present_key_cache_size) {
            builder.append(this.key_cache_size);
        }
        boolean present_read_repair_chance = this.isSetRead_repair_chance();
        builder.append(present_read_repair_chance);
        if (present_read_repair_chance) {
            builder.append(this.read_repair_chance);
        }
        boolean present_column_metadata = this.isSetColumn_metadata();
        builder.append(present_column_metadata);
        if (present_column_metadata) {
            builder.append(this.column_metadata);
        }
        boolean present_gc_grace_seconds = this.isSetGc_grace_seconds();
        builder.append(present_gc_grace_seconds);
        if (present_gc_grace_seconds) {
            builder.append(this.gc_grace_seconds);
        }
        boolean present_default_validation_class = this.isSetDefault_validation_class();
        builder.append(present_default_validation_class);
        if (present_default_validation_class) {
            builder.append((Object)this.default_validation_class);
        }
        boolean present_id = this.isSetId();
        builder.append(present_id);
        if (present_id) {
            builder.append(this.id);
        }
        boolean present_min_compaction_threshold = this.isSetMin_compaction_threshold();
        builder.append(present_min_compaction_threshold);
        if (present_min_compaction_threshold) {
            builder.append(this.min_compaction_threshold);
        }
        boolean present_max_compaction_threshold = this.isSetMax_compaction_threshold();
        builder.append(present_max_compaction_threshold);
        if (present_max_compaction_threshold) {
            builder.append(this.max_compaction_threshold);
        }
        boolean present_row_cache_save_period_in_seconds = this.isSetRow_cache_save_period_in_seconds();
        builder.append(present_row_cache_save_period_in_seconds);
        if (present_row_cache_save_period_in_seconds) {
            builder.append(this.row_cache_save_period_in_seconds);
        }
        boolean present_key_cache_save_period_in_seconds = this.isSetKey_cache_save_period_in_seconds();
        builder.append(present_key_cache_save_period_in_seconds);
        if (present_key_cache_save_period_in_seconds) {
            builder.append(this.key_cache_save_period_in_seconds);
        }
        boolean present_replicate_on_write = this.isSetReplicate_on_write();
        builder.append(present_replicate_on_write);
        if (present_replicate_on_write) {
            builder.append(this.replicate_on_write);
        }
        boolean present_merge_shards_chance = this.isSetMerge_shards_chance();
        builder.append(present_merge_shards_chance);
        if (present_merge_shards_chance) {
            builder.append(this.merge_shards_chance);
        }
        boolean present_key_validation_class = this.isSetKey_validation_class();
        builder.append(present_key_validation_class);
        if (present_key_validation_class) {
            builder.append((Object)this.key_validation_class);
        }
        boolean present_row_cache_provider = this.isSetRow_cache_provider();
        builder.append(present_row_cache_provider);
        if (present_row_cache_provider) {
            builder.append((Object)this.row_cache_provider);
        }
        boolean present_key_alias = this.isSetKey_alias();
        builder.append(present_key_alias);
        if (present_key_alias) {
            builder.append((Object)this.key_alias);
        }
        boolean present_compaction_strategy = this.isSetCompaction_strategy();
        builder.append(present_compaction_strategy);
        if (present_compaction_strategy) {
            builder.append((Object)this.compaction_strategy);
        }
        boolean present_compaction_strategy_options = this.isSetCompaction_strategy_options();
        builder.append(present_compaction_strategy_options);
        if (present_compaction_strategy_options) {
            builder.append(this.compaction_strategy_options);
        }
        boolean present_row_cache_keys_to_save = this.isSetRow_cache_keys_to_save();
        builder.append(present_row_cache_keys_to_save);
        if (present_row_cache_keys_to_save) {
            builder.append(this.row_cache_keys_to_save);
        }
        boolean present_compression_options = this.isSetCompression_options();
        builder.append(present_compression_options);
        if (present_compression_options) {
            builder.append(this.compression_options);
        }
        boolean present_bloom_filter_fp_chance = this.isSetBloom_filter_fp_chance();
        builder.append(present_bloom_filter_fp_chance);
        if (present_bloom_filter_fp_chance) {
            builder.append(this.bloom_filter_fp_chance);
        }
        return builder.toHashCode();
    }

    public int compareTo(CfDef other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        CfDef typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetKeyspace()).compareTo(typedOther.isSetKeyspace());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyspace() && (lastComparison = TBaseHelper.compareTo((String)this.keyspace, (String)typedOther.keyspace)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(typedOther.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)typedOther.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_type()).compareTo(typedOther.isSetColumn_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_type() && (lastComparison = TBaseHelper.compareTo((String)this.column_type, (String)typedOther.column_type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetComparator_type()).compareTo(typedOther.isSetComparator_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetComparator_type() && (lastComparison = TBaseHelper.compareTo((String)this.comparator_type, (String)typedOther.comparator_type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSubcomparator_type()).compareTo(typedOther.isSetSubcomparator_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSubcomparator_type() && (lastComparison = TBaseHelper.compareTo((String)this.subcomparator_type, (String)typedOther.subcomparator_type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetComment()).compareTo(typedOther.isSetComment());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetComment() && (lastComparison = TBaseHelper.compareTo((String)this.comment, (String)typedOther.comment)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow_cache_size()).compareTo(typedOther.isSetRow_cache_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow_cache_size() && (lastComparison = TBaseHelper.compareTo((double)this.row_cache_size, (double)typedOther.row_cache_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_cache_size()).compareTo(typedOther.isSetKey_cache_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_cache_size() && (lastComparison = TBaseHelper.compareTo((double)this.key_cache_size, (double)typedOther.key_cache_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRead_repair_chance()).compareTo(typedOther.isSetRead_repair_chance());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRead_repair_chance() && (lastComparison = TBaseHelper.compareTo((double)this.read_repair_chance, (double)typedOther.read_repair_chance)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_metadata()).compareTo(typedOther.isSetColumn_metadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_metadata() && (lastComparison = TBaseHelper.compareTo(this.column_metadata, typedOther.column_metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGc_grace_seconds()).compareTo(typedOther.isSetGc_grace_seconds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGc_grace_seconds() && (lastComparison = TBaseHelper.compareTo((int)this.gc_grace_seconds, (int)typedOther.gc_grace_seconds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefault_validation_class()).compareTo(typedOther.isSetDefault_validation_class());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefault_validation_class() && (lastComparison = TBaseHelper.compareTo((String)this.default_validation_class, (String)typedOther.default_validation_class)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(typedOther.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((int)this.id, (int)typedOther.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMin_compaction_threshold()).compareTo(typedOther.isSetMin_compaction_threshold());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMin_compaction_threshold() && (lastComparison = TBaseHelper.compareTo((int)this.min_compaction_threshold, (int)typedOther.min_compaction_threshold)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMax_compaction_threshold()).compareTo(typedOther.isSetMax_compaction_threshold());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMax_compaction_threshold() && (lastComparison = TBaseHelper.compareTo((int)this.max_compaction_threshold, (int)typedOther.max_compaction_threshold)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow_cache_save_period_in_seconds()).compareTo(typedOther.isSetRow_cache_save_period_in_seconds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow_cache_save_period_in_seconds() && (lastComparison = TBaseHelper.compareTo((int)this.row_cache_save_period_in_seconds, (int)typedOther.row_cache_save_period_in_seconds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_cache_save_period_in_seconds()).compareTo(typedOther.isSetKey_cache_save_period_in_seconds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_cache_save_period_in_seconds() && (lastComparison = TBaseHelper.compareTo((int)this.key_cache_save_period_in_seconds, (int)typedOther.key_cache_save_period_in_seconds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicate_on_write()).compareTo(typedOther.isSetReplicate_on_write());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicate_on_write() && (lastComparison = TBaseHelper.compareTo((boolean)this.replicate_on_write, (boolean)typedOther.replicate_on_write)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMerge_shards_chance()).compareTo(typedOther.isSetMerge_shards_chance());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMerge_shards_chance() && (lastComparison = TBaseHelper.compareTo((double)this.merge_shards_chance, (double)typedOther.merge_shards_chance)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_validation_class()).compareTo(typedOther.isSetKey_validation_class());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_validation_class() && (lastComparison = TBaseHelper.compareTo((String)this.key_validation_class, (String)typedOther.key_validation_class)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow_cache_provider()).compareTo(typedOther.isSetRow_cache_provider());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow_cache_provider() && (lastComparison = TBaseHelper.compareTo((String)this.row_cache_provider, (String)typedOther.row_cache_provider)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_alias()).compareTo(typedOther.isSetKey_alias());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey_alias() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key_alias, (Comparable)typedOther.key_alias)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCompaction_strategy()).compareTo(typedOther.isSetCompaction_strategy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCompaction_strategy() && (lastComparison = TBaseHelper.compareTo((String)this.compaction_strategy, (String)typedOther.compaction_strategy)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCompaction_strategy_options()).compareTo(typedOther.isSetCompaction_strategy_options());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCompaction_strategy_options() && (lastComparison = TBaseHelper.compareTo(this.compaction_strategy_options, typedOther.compaction_strategy_options)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRow_cache_keys_to_save()).compareTo(typedOther.isSetRow_cache_keys_to_save());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow_cache_keys_to_save() && (lastComparison = TBaseHelper.compareTo((int)this.row_cache_keys_to_save, (int)typedOther.row_cache_keys_to_save)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCompression_options()).compareTo(typedOther.isSetCompression_options());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCompression_options() && (lastComparison = TBaseHelper.compareTo(this.compression_options, typedOther.compression_options)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBloom_filter_fp_chance()).compareTo(typedOther.isSetBloom_filter_fp_chance());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBloom_filter_fp_chance() && (lastComparison = TBaseHelper.compareTo((double)this.bloom_filter_fp_chance, (double)typedOther.bloom_filter_fp_chance)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.keyspace = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.name = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.column_type = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 11) {
                        this.comparator_type = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 11) {
                        this.subcomparator_type = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 8: {
                    if (field.type == 11) {
                        this.comment = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 9: {
                    if (field.type == 4) {
                        this.row_cache_size = iprot.readDouble();
                        this.setRow_cache_sizeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 11: {
                    if (field.type == 4) {
                        this.key_cache_size = iprot.readDouble();
                        this.setKey_cache_sizeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 12: {
                    if (field.type == 4) {
                        this.read_repair_chance = iprot.readDouble();
                        this.setRead_repair_chanceIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 13: {
                    if (field.type == 15) {
                        TList _list42 = iprot.readListBegin();
                        this.column_metadata = new ArrayList<ColumnDef>(_list42.size);
                        for (int _i43 = 0; _i43 < _list42.size; ++_i43) {
                            ColumnDef _elem44 = new ColumnDef();
                            _elem44.read(iprot);
                            this.column_metadata.add(_elem44);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 14: {
                    if (field.type == 8) {
                        this.gc_grace_seconds = iprot.readI32();
                        this.setGc_grace_secondsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 15: {
                    if (field.type == 11) {
                        this.default_validation_class = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 16: {
                    if (field.type == 8) {
                        this.id = iprot.readI32();
                        this.setIdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 17: {
                    if (field.type == 8) {
                        this.min_compaction_threshold = iprot.readI32();
                        this.setMin_compaction_thresholdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 18: {
                    if (field.type == 8) {
                        this.max_compaction_threshold = iprot.readI32();
                        this.setMax_compaction_thresholdIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 19: {
                    if (field.type == 8) {
                        this.row_cache_save_period_in_seconds = iprot.readI32();
                        this.setRow_cache_save_period_in_secondsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 20: {
                    if (field.type == 8) {
                        this.key_cache_save_period_in_seconds = iprot.readI32();
                        this.setKey_cache_save_period_in_secondsIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 24: {
                    if (field.type == 2) {
                        this.replicate_on_write = iprot.readBool();
                        this.setReplicate_on_writeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 25: {
                    if (field.type == 4) {
                        this.merge_shards_chance = iprot.readDouble();
                        this.setMerge_shards_chanceIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 26: {
                    if (field.type == 11) {
                        this.key_validation_class = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 27: {
                    if (field.type == 11) {
                        this.row_cache_provider = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 28: {
                    if (field.type == 11) {
                        this.key_alias = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 29: {
                    if (field.type == 11) {
                        this.compaction_strategy = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 30: {
                    if (field.type == 13) {
                        TMap _map45 = iprot.readMapBegin();
                        this.compaction_strategy_options = new HashMap<String, String>(2 * _map45.size);
                        for (int _i46 = 0; _i46 < _map45.size; ++_i46) {
                            String _key47 = iprot.readString();
                            String _val48 = iprot.readString();
                            this.compaction_strategy_options.put(_key47, _val48);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 31: {
                    if (field.type == 8) {
                        this.row_cache_keys_to_save = iprot.readI32();
                        this.setRow_cache_keys_to_saveIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 32: {
                    if (field.type == 13) {
                        TMap _map49 = iprot.readMapBegin();
                        this.compression_options = new HashMap<String, String>(2 * _map49.size);
                        for (int _i50 = 0; _i50 < _map49.size; ++_i50) {
                            String _key51 = iprot.readString();
                            String _val52 = iprot.readString();
                            this.compression_options.put(_key51, _val52);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 33: {
                    if (field.type == 4) {
                        this.bloom_filter_fp_chance = iprot.readDouble();
                        this.setBloom_filter_fp_chanceIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.keyspace != null) {
            oprot.writeFieldBegin(KEYSPACE_FIELD_DESC);
            oprot.writeString(this.keyspace);
            oprot.writeFieldEnd();
        }
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeString(this.name);
            oprot.writeFieldEnd();
        }
        if (this.column_type != null && this.isSetColumn_type()) {
            oprot.writeFieldBegin(COLUMN_TYPE_FIELD_DESC);
            oprot.writeString(this.column_type);
            oprot.writeFieldEnd();
        }
        if (this.comparator_type != null && this.isSetComparator_type()) {
            oprot.writeFieldBegin(COMPARATOR_TYPE_FIELD_DESC);
            oprot.writeString(this.comparator_type);
            oprot.writeFieldEnd();
        }
        if (this.subcomparator_type != null && this.isSetSubcomparator_type()) {
            oprot.writeFieldBegin(SUBCOMPARATOR_TYPE_FIELD_DESC);
            oprot.writeString(this.subcomparator_type);
            oprot.writeFieldEnd();
        }
        if (this.comment != null && this.isSetComment()) {
            oprot.writeFieldBegin(COMMENT_FIELD_DESC);
            oprot.writeString(this.comment);
            oprot.writeFieldEnd();
        }
        if (this.isSetRow_cache_size()) {
            oprot.writeFieldBegin(ROW_CACHE_SIZE_FIELD_DESC);
            oprot.writeDouble(this.row_cache_size);
            oprot.writeFieldEnd();
        }
        if (this.isSetKey_cache_size()) {
            oprot.writeFieldBegin(KEY_CACHE_SIZE_FIELD_DESC);
            oprot.writeDouble(this.key_cache_size);
            oprot.writeFieldEnd();
        }
        if (this.isSetRead_repair_chance()) {
            oprot.writeFieldBegin(READ_REPAIR_CHANCE_FIELD_DESC);
            oprot.writeDouble(this.read_repair_chance);
            oprot.writeFieldEnd();
        }
        if (this.column_metadata != null && this.isSetColumn_metadata()) {
            oprot.writeFieldBegin(COLUMN_METADATA_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.column_metadata.size()));
            for (ColumnDef columnDef : this.column_metadata) {
                columnDef.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetGc_grace_seconds()) {
            oprot.writeFieldBegin(GC_GRACE_SECONDS_FIELD_DESC);
            oprot.writeI32(this.gc_grace_seconds);
            oprot.writeFieldEnd();
        }
        if (this.default_validation_class != null && this.isSetDefault_validation_class()) {
            oprot.writeFieldBegin(DEFAULT_VALIDATION_CLASS_FIELD_DESC);
            oprot.writeString(this.default_validation_class);
            oprot.writeFieldEnd();
        }
        if (this.isSetId()) {
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI32(this.id);
            oprot.writeFieldEnd();
        }
        if (this.isSetMin_compaction_threshold()) {
            oprot.writeFieldBegin(MIN_COMPACTION_THRESHOLD_FIELD_DESC);
            oprot.writeI32(this.min_compaction_threshold);
            oprot.writeFieldEnd();
        }
        if (this.isSetMax_compaction_threshold()) {
            oprot.writeFieldBegin(MAX_COMPACTION_THRESHOLD_FIELD_DESC);
            oprot.writeI32(this.max_compaction_threshold);
            oprot.writeFieldEnd();
        }
        if (this.isSetRow_cache_save_period_in_seconds()) {
            oprot.writeFieldBegin(ROW_CACHE_SAVE_PERIOD_IN_SECONDS_FIELD_DESC);
            oprot.writeI32(this.row_cache_save_period_in_seconds);
            oprot.writeFieldEnd();
        }
        if (this.isSetKey_cache_save_period_in_seconds()) {
            oprot.writeFieldBegin(KEY_CACHE_SAVE_PERIOD_IN_SECONDS_FIELD_DESC);
            oprot.writeI32(this.key_cache_save_period_in_seconds);
            oprot.writeFieldEnd();
        }
        if (this.isSetReplicate_on_write()) {
            oprot.writeFieldBegin(REPLICATE_ON_WRITE_FIELD_DESC);
            oprot.writeBool(this.replicate_on_write);
            oprot.writeFieldEnd();
        }
        if (this.isSetMerge_shards_chance()) {
            oprot.writeFieldBegin(MERGE_SHARDS_CHANCE_FIELD_DESC);
            oprot.writeDouble(this.merge_shards_chance);
            oprot.writeFieldEnd();
        }
        if (this.key_validation_class != null && this.isSetKey_validation_class()) {
            oprot.writeFieldBegin(KEY_VALIDATION_CLASS_FIELD_DESC);
            oprot.writeString(this.key_validation_class);
            oprot.writeFieldEnd();
        }
        if (this.row_cache_provider != null && this.isSetRow_cache_provider()) {
            oprot.writeFieldBegin(ROW_CACHE_PROVIDER_FIELD_DESC);
            oprot.writeString(this.row_cache_provider);
            oprot.writeFieldEnd();
        }
        if (this.key_alias != null && this.isSetKey_alias()) {
            oprot.writeFieldBegin(KEY_ALIAS_FIELD_DESC);
            oprot.writeBinary(this.key_alias);
            oprot.writeFieldEnd();
        }
        if (this.compaction_strategy != null && this.isSetCompaction_strategy()) {
            oprot.writeFieldBegin(COMPACTION_STRATEGY_FIELD_DESC);
            oprot.writeString(this.compaction_strategy);
            oprot.writeFieldEnd();
        }
        if (this.compaction_strategy_options != null && this.isSetCompaction_strategy_options()) {
            oprot.writeFieldBegin(COMPACTION_STRATEGY_OPTIONS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.compaction_strategy_options.size()));
            for (Map.Entry entry : this.compaction_strategy_options.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetRow_cache_keys_to_save()) {
            oprot.writeFieldBegin(ROW_CACHE_KEYS_TO_SAVE_FIELD_DESC);
            oprot.writeI32(this.row_cache_keys_to_save);
            oprot.writeFieldEnd();
        }
        if (this.compression_options != null && this.isSetCompression_options()) {
            oprot.writeFieldBegin(COMPRESSION_OPTIONS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.compression_options.size()));
            for (Map.Entry entry : this.compression_options.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.isSetBloom_filter_fp_chance()) {
            oprot.writeFieldBegin(BLOOM_FILTER_FP_CHANCE_FIELD_DESC);
            oprot.writeDouble(this.bloom_filter_fp_chance);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CfDef(");
        boolean first = true;
        sb.append("keyspace:");
        if (this.keyspace == null) {
            sb.append("null");
        } else {
            sb.append(this.keyspace);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (this.isSetColumn_type()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_type:");
            if (this.column_type == null) {
                sb.append("null");
            } else {
                sb.append(this.column_type);
            }
            first = false;
        }
        if (this.isSetComparator_type()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("comparator_type:");
            if (this.comparator_type == null) {
                sb.append("null");
            } else {
                sb.append(this.comparator_type);
            }
            first = false;
        }
        if (this.isSetSubcomparator_type()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("subcomparator_type:");
            if (this.subcomparator_type == null) {
                sb.append("null");
            } else {
                sb.append(this.subcomparator_type);
            }
            first = false;
        }
        if (this.isSetComment()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("comment:");
            if (this.comment == null) {
                sb.append("null");
            } else {
                sb.append(this.comment);
            }
            first = false;
        }
        if (this.isSetRow_cache_size()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("row_cache_size:");
            sb.append(this.row_cache_size);
            first = false;
        }
        if (this.isSetKey_cache_size()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_cache_size:");
            sb.append(this.key_cache_size);
            first = false;
        }
        if (this.isSetRead_repair_chance()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("read_repair_chance:");
            sb.append(this.read_repair_chance);
            first = false;
        }
        if (this.isSetColumn_metadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_metadata:");
            if (this.column_metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.column_metadata);
            }
            first = false;
        }
        if (this.isSetGc_grace_seconds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("gc_grace_seconds:");
            sb.append(this.gc_grace_seconds);
            first = false;
        }
        if (this.isSetDefault_validation_class()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("default_validation_class:");
            if (this.default_validation_class == null) {
                sb.append("null");
            } else {
                sb.append(this.default_validation_class);
            }
            first = false;
        }
        if (this.isSetId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("id:");
            sb.append(this.id);
            first = false;
        }
        if (this.isSetMin_compaction_threshold()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("min_compaction_threshold:");
            sb.append(this.min_compaction_threshold);
            first = false;
        }
        if (this.isSetMax_compaction_threshold()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("max_compaction_threshold:");
            sb.append(this.max_compaction_threshold);
            first = false;
        }
        if (this.isSetRow_cache_save_period_in_seconds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("row_cache_save_period_in_seconds:");
            sb.append(this.row_cache_save_period_in_seconds);
            first = false;
        }
        if (this.isSetKey_cache_save_period_in_seconds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_cache_save_period_in_seconds:");
            sb.append(this.key_cache_save_period_in_seconds);
            first = false;
        }
        if (this.isSetReplicate_on_write()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicate_on_write:");
            sb.append(this.replicate_on_write);
            first = false;
        }
        if (this.isSetMerge_shards_chance()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("merge_shards_chance:");
            sb.append(this.merge_shards_chance);
            first = false;
        }
        if (this.isSetKey_validation_class()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_validation_class:");
            if (this.key_validation_class == null) {
                sb.append("null");
            } else {
                sb.append(this.key_validation_class);
            }
            first = false;
        }
        if (this.isSetRow_cache_provider()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("row_cache_provider:");
            if (this.row_cache_provider == null) {
                sb.append("null");
            } else {
                sb.append(this.row_cache_provider);
            }
            first = false;
        }
        if (this.isSetKey_alias()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_alias:");
            if (this.key_alias == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.key_alias, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetCompaction_strategy()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("compaction_strategy:");
            if (this.compaction_strategy == null) {
                sb.append("null");
            } else {
                sb.append(this.compaction_strategy);
            }
            first = false;
        }
        if (this.isSetCompaction_strategy_options()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("compaction_strategy_options:");
            if (this.compaction_strategy_options == null) {
                sb.append("null");
            } else {
                sb.append(this.compaction_strategy_options);
            }
            first = false;
        }
        if (this.isSetRow_cache_keys_to_save()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("row_cache_keys_to_save:");
            sb.append(this.row_cache_keys_to_save);
            first = false;
        }
        if (this.isSetCompression_options()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("compression_options:");
            if (this.compression_options == null) {
                sb.append("null");
            } else {
                sb.append(this.compression_options);
            }
            first = false;
        }
        if (this.isSetBloom_filter_fp_chance()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bloom_filter_fp_chance:");
            sb.append(this.bloom_filter_fp_chance);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.keyspace == null) {
            throw new TProtocolException("Required field 'keyspace' was not present! Struct: " + this.toString());
        }
        if (this.name == null) {
            throw new TProtocolException("Required field 'name' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bit_vector = new BitSet(1);
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEYSPACE, new FieldMetaData("keyspace", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COLUMN_TYPE, new FieldMetaData("column_type", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COMPARATOR_TYPE, new FieldMetaData("comparator_type", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SUBCOMPARATOR_TYPE, new FieldMetaData("subcomparator_type", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COMMENT, new FieldMetaData("comment", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ROW_CACHE_SIZE, new FieldMetaData("row_cache_size", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.KEY_CACHE_SIZE, new FieldMetaData("key_cache_size", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.READ_REPAIR_CHANCE, new FieldMetaData("read_repair_chance", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.COLUMN_METADATA, new FieldMetaData("column_metadata", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnDef.class))));
        tmpMap.put(_Fields.GC_GRACE_SECONDS, new FieldMetaData("gc_grace_seconds", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DEFAULT_VALIDATION_CLASS, new FieldMetaData("default_validation_class", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MIN_COMPACTION_THRESHOLD, new FieldMetaData("min_compaction_threshold", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_COMPACTION_THRESHOLD, new FieldMetaData("max_compaction_threshold", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ROW_CACHE_SAVE_PERIOD_IN_SECONDS, new FieldMetaData("row_cache_save_period_in_seconds", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.KEY_CACHE_SAVE_PERIOD_IN_SECONDS, new FieldMetaData("key_cache_save_period_in_seconds", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.REPLICATE_ON_WRITE, new FieldMetaData("replicate_on_write", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.MERGE_SHARDS_CHANCE, new FieldMetaData("merge_shards_chance", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.KEY_VALIDATION_CLASS, new FieldMetaData("key_validation_class", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ROW_CACHE_PROVIDER, new FieldMetaData("row_cache_provider", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.KEY_ALIAS, new FieldMetaData("key_alias", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COMPACTION_STRATEGY, new FieldMetaData("compaction_strategy", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COMPACTION_STRATEGY_OPTIONS, new FieldMetaData("compaction_strategy_options", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ROW_CACHE_KEYS_TO_SAVE, new FieldMetaData("row_cache_keys_to_save", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COMPRESSION_OPTIONS, new FieldMetaData("compression_options", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.BLOOM_FILTER_FP_CHANCE, new FieldMetaData("bloom_filter_fp_chance", 2, new FieldValueMetaData(4)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CfDef.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEYSPACE(1, "keyspace"),
        NAME(2, "name"),
        COLUMN_TYPE(3, "column_type"),
        COMPARATOR_TYPE(5, "comparator_type"),
        SUBCOMPARATOR_TYPE(6, "subcomparator_type"),
        COMMENT(8, "comment"),
        ROW_CACHE_SIZE(9, "row_cache_size"),
        KEY_CACHE_SIZE(11, "key_cache_size"),
        READ_REPAIR_CHANCE(12, "read_repair_chance"),
        COLUMN_METADATA(13, "column_metadata"),
        GC_GRACE_SECONDS(14, "gc_grace_seconds"),
        DEFAULT_VALIDATION_CLASS(15, "default_validation_class"),
        ID(16, "id"),
        MIN_COMPACTION_THRESHOLD(17, "min_compaction_threshold"),
        MAX_COMPACTION_THRESHOLD(18, "max_compaction_threshold"),
        ROW_CACHE_SAVE_PERIOD_IN_SECONDS(19, "row_cache_save_period_in_seconds"),
        KEY_CACHE_SAVE_PERIOD_IN_SECONDS(20, "key_cache_save_period_in_seconds"),
        REPLICATE_ON_WRITE(24, "replicate_on_write"),
        MERGE_SHARDS_CHANCE(25, "merge_shards_chance"),
        KEY_VALIDATION_CLASS(26, "key_validation_class"),
        ROW_CACHE_PROVIDER(27, "row_cache_provider"),
        KEY_ALIAS(28, "key_alias"),
        COMPACTION_STRATEGY(29, "compaction_strategy"),
        COMPACTION_STRATEGY_OPTIONS(30, "compaction_strategy_options"),
        ROW_CACHE_KEYS_TO_SAVE(31, "row_cache_keys_to_save"),
        COMPRESSION_OPTIONS(32, "compression_options"),
        BLOOM_FILTER_FP_CHANCE(33, "bloom_filter_fp_chance");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEYSPACE;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return COLUMN_TYPE;
                }
                case 5: {
                    return COMPARATOR_TYPE;
                }
                case 6: {
                    return SUBCOMPARATOR_TYPE;
                }
                case 8: {
                    return COMMENT;
                }
                case 9: {
                    return ROW_CACHE_SIZE;
                }
                case 11: {
                    return KEY_CACHE_SIZE;
                }
                case 12: {
                    return READ_REPAIR_CHANCE;
                }
                case 13: {
                    return COLUMN_METADATA;
                }
                case 14: {
                    return GC_GRACE_SECONDS;
                }
                case 15: {
                    return DEFAULT_VALIDATION_CLASS;
                }
                case 16: {
                    return ID;
                }
                case 17: {
                    return MIN_COMPACTION_THRESHOLD;
                }
                case 18: {
                    return MAX_COMPACTION_THRESHOLD;
                }
                case 19: {
                    return ROW_CACHE_SAVE_PERIOD_IN_SECONDS;
                }
                case 20: {
                    return KEY_CACHE_SAVE_PERIOD_IN_SECONDS;
                }
                case 24: {
                    return REPLICATE_ON_WRITE;
                }
                case 25: {
                    return MERGE_SHARDS_CHANCE;
                }
                case 26: {
                    return KEY_VALIDATION_CLASS;
                }
                case 27: {
                    return ROW_CACHE_PROVIDER;
                }
                case 28: {
                    return KEY_ALIAS;
                }
                case 29: {
                    return COMPACTION_STRATEGY;
                }
                case 30: {
                    return COMPACTION_STRATEGY_OPTIONS;
                }
                case 31: {
                    return ROW_CACHE_KEYS_TO_SAVE;
                }
                case 32: {
                    return COMPRESSION_OPTIONS;
                }
                case 33: {
                    return BLOOM_FILTER_FP_CHANCE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

