/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.SkinnyPrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.bitpack.BlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookup;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;

@NotThreadSafe
public class WidePrimaryKeyMap
extends SkinnyPrimaryKeyMap {
    private final LongArray partitionIdToSizeArray;
    private final ClusteringComparator clusteringComparator;
    private final KeyLookup.Cursor clusteringKeyCursor;

    private WidePrimaryKeyMap(LongArray rowIdToTokenArray, LongArray rowIdToPartitionIdArray, LongArray partitionIdToSizeArray, KeyLookup.Cursor partitionKeyCursor, KeyLookup.Cursor clusteringKeyCursor, PrimaryKey.Factory primaryKeyFactory, ClusteringComparator clusteringComparator) {
        super(rowIdToTokenArray, rowIdToPartitionIdArray, partitionKeyCursor, primaryKeyFactory);
        this.partitionIdToSizeArray = partitionIdToSizeArray;
        this.clusteringComparator = clusteringComparator;
        this.clusteringKeyCursor = clusteringKeyCursor;
    }

    @Override
    public PrimaryKey primaryKeyFromRowId(long sstableRowId) {
        return this.primaryKeyFactory.create(this.readPartitionKey(sstableRowId), this.readClusteringKey(sstableRowId));
    }

    @Override
    public long rowIdFromPrimaryKey(PrimaryKey primaryKey) {
        long rowId = this.rowIdToTokenArray.indexOf(primaryKey.token().getLongValue());
        if (primaryKey.kind() == PrimaryKey.Kind.TOKEN || rowId < 0L || this.rowIdToTokenArray.get(rowId) != primaryKey.token().getLongValue()) {
            return rowId;
        }
        rowId = this.tokenCollisionDetection(primaryKey, rowId);
        return this.clusteringKeyCursor.clusteredSeekToKey(this.clusteringComparator.asByteComparable(primaryKey.clustering()), rowId, this.startOfNextPartition(rowId));
    }

    @Override
    public long floor(Token token) {
        if (token.isMinimum()) {
            return Long.MIN_VALUE;
        }
        long rowId = this.rowIdToTokenArray.indexOf(token.getLongValue());
        return rowId < 0L ? rowId : this.startOfNextPartition(rowId) - 1L;
    }

    @Override
    public void close() {
        super.close();
        FileUtils.closeQuietly(this.clusteringKeyCursor);
    }

    private Clustering<?> readClusteringKey(long sstableRowId) {
        return this.primaryKeyFactory.clusteringFromByteComparable(this.clusteringKeyCursor.seekToPointId(sstableRowId));
    }

    private long startOfNextPartition(long rowId) {
        long partitionSize = this.partitionIdToSizeArray.get(this.rowIdToPartitionIdArray.get(rowId));
        return partitionSize == -1L ? this.rowIdToPartitionIdArray.length() : rowId + partitionSize;
    }

    @ThreadSafe
    public static class Factory
    extends SkinnyPrimaryKeyMap.Factory {
        private final ClusteringComparator clusteringComparator;
        private final KeyLookup clusteringKeyReader;
        private final LongArray.Factory partitionToSizeReaderFactory;
        private final FileHandle clusteringKeyBlockOffsetsFile;
        private final FileHandle clustingingKeyBlocksFile;
        private final FileHandle partitionToSizeFile;

        public Factory(IndexDescriptor indexDescriptor, SSTableReader sstable) {
            super(indexDescriptor);
            this.clusteringKeyBlockOffsetsFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS, this::close);
            this.clustingingKeyBlocksFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.CLUSTERING_KEY_BLOCKS, this::close);
            this.partitionToSizeFile = indexDescriptor.createPerSSTableFileHandle(IndexComponent.PARTITION_TO_SIZE, this::close);
            try {
                this.clusteringComparator = indexDescriptor.clusteringComparator;
                NumericValuesMeta partitionSizeMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.PARTITION_TO_SIZE)));
                this.partitionToSizeReaderFactory = new BlockPackedReader(this.partitionToSizeFile, partitionSizeMeta);
                NumericValuesMeta clusteringKeyBlockOffsetsMeta = new NumericValuesMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS)));
                KeyLookupMeta clusteringKeyMeta = new KeyLookupMeta(this.metadataSource.get(indexDescriptor.componentName(IndexComponent.CLUSTERING_KEY_BLOCKS)));
                this.clusteringKeyReader = new KeyLookup(this.clustingingKeyBlocksFile, this.clusteringKeyBlockOffsetsFile, clusteringKeyMeta, clusteringKeyBlockOffsetsMeta);
            }
            catch (Throwable t) {
                throw Throwables.unchecked(t);
            }
        }

        @Override
        public PrimaryKeyMap newPerSSTablePrimaryKeyMap() throws IOException {
            LongArray.DeferredLongArray rowIdToToken = new LongArray.DeferredLongArray(this.rowToTokenReaderFactory::open);
            LongArray.DeferredLongArray partitionIdToToken = new LongArray.DeferredLongArray(this.rowToPartitionReaderFactory::open);
            LongArray.DeferredLongArray partitionIdToSize = new LongArray.DeferredLongArray(this.partitionToSizeReaderFactory::open);
            return new WidePrimaryKeyMap(rowIdToToken, partitionIdToToken, partitionIdToSize, this.partitionKeyReader.openCursor(), this.clusteringKeyReader.openCursor(), this.primaryKeyFactory, this.clusteringComparator);
        }

        @Override
        public void close() {
            super.close();
            FileUtils.closeQuietly(Arrays.asList(this.clustingingKeyBlocksFile, this.clusteringKeyBlockOffsetsFile, this.partitionToSizeFile));
        }
    }
}

