/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

final class WritetimeOrTTLSelector
extends Selector {
    static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            Selector selected = Selector.serializer.deserialize(in, version, metadata);
            int idx = in.readInt();
            byte ordinal = in.readByte();
            Selectable.WritetimeOrTTL.Kind kind = Selectable.WritetimeOrTTL.Kind.fromOrdinal(ordinal);
            boolean isMultiCell = in.readBoolean();
            return new WritetimeOrTTLSelector(selected, idx, kind, isMultiCell);
        }
    };
    private final Selector selected;
    private final int columnIndex;
    private final Selectable.WritetimeOrTTL.Kind kind;
    private ByteBuffer current;
    private final boolean isMultiCell;
    private boolean isSet;

    public static Selector.Factory newFactory(final Selector.Factory factory, final int columnIndex, final Selectable.WritetimeOrTTL.Kind kind, final boolean isMultiCell) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return String.format("%s(%s)", kind.name, factory.getColumnName());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                AbstractType type = kind.returnType;
                return isMultiCell && !kind.aggregatesMultiCell() ? ListType.getInstance(type, false) : type;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                factory.addColumnMapping(mapping, resultsColumn);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new WritetimeOrTTLSelector(factory.newInstance(options), columnIndex, kind, isMultiCell);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return kind != Selectable.WritetimeOrTTL.Kind.TTL;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return kind == Selectable.WritetimeOrTTL.Kind.TTL;
            }

            @Override
            public boolean isMaxWritetimeSelectorFactory() {
                return kind == Selectable.WritetimeOrTTL.Kind.MAX_WRITE_TIME;
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return true;
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                factory.addFetchedColumns(builder);
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        this.selected.addFetchedColumns(builder);
    }

    @Override
    public void addInput(Selector.InputRow input) {
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.selected.addInput(input);
        ProtocolVersion protocolVersion = input.getProtocolVersion();
        switch (this.kind) {
            case WRITE_TIME: {
                this.current = this.selected.getWritetimes(protocolVersion).toByteBuffer(protocolVersion);
                break;
            }
            case MAX_WRITE_TIME: {
                this.current = this.selected.getWritetimes(protocolVersion).max().toByteBuffer(protocolVersion);
                break;
            }
            case TTL: {
                this.current = this.selected.getTTLs(protocolVersion).toByteBuffer(protocolVersion);
            }
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        return this.current;
    }

    @Override
    public void reset() {
        this.selected.reset();
        this.isSet = false;
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        AbstractType type = this.kind.returnType;
        return this.isMultiCell ? ListType.getInstance(type, false) : type;
    }

    public String toString() {
        return this.selected.toString();
    }

    private WritetimeOrTTLSelector(Selector selected, int idx, Selectable.WritetimeOrTTL.Kind kind, boolean isMultiCell) {
        super(Selector.Kind.WRITETIME_OR_TTL_SELECTOR);
        this.selected = selected;
        this.columnIndex = idx;
        this.kind = kind;
        this.isMultiCell = isMultiCell;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WritetimeOrTTLSelector)) {
            return false;
        }
        WritetimeOrTTLSelector s = (WritetimeOrTTLSelector)o;
        return Objects.equal((Object)this.selected, (Object)s.selected) && this.kind == s.kind;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.selected, this.kind});
    }

    @Override
    protected int serializedSize(int version) {
        return serializer.serializedSize(this.selected, version) + TypeSizes.sizeof(this.columnIndex) + TypeSizes.sizeofUnsignedVInt(this.kind.ordinal()) + TypeSizes.sizeof(this.isMultiCell);
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        serializer.serialize(this.selected, out, version);
        out.writeInt(this.columnIndex);
        out.writeByte(this.kind.ordinal());
        out.writeBoolean(this.isMultiCell);
    }
}

