/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import io.airlift.airline.Arguments;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileInputStreamPlus;
import org.apache.cassandra.utils.JsonUtils;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class JMXTool {
    private static final List<String> METRIC_PACKAGES = Arrays.asList("org.apache.cassandra.metrics", "org.apache.cassandra.db", "org.apache.cassandra.hints", "org.apache.cassandra.internal", "org.apache.cassandra.net", "org.apache.cassandra.request", "org.apache.cassandra.service");
    private static final Comparator<MBeanOperationInfo> OPERATOR_COMPARATOR = (a, b) -> {
        String[] bSig;
        int rc = a.getName().compareTo(b.getName());
        if (rc != 0) {
            return rc;
        }
        String[] aSig = (String[])Stream.of(a.getSignature()).map(MBeanFeatureInfo::getName).toArray(String[]::new);
        rc = Integer.compare(aSig.length, (bSig = (String[])Stream.of(b.getSignature()).map(MBeanFeatureInfo::getName).toArray(String[]::new)).length);
        if (rc != 0) {
            return rc;
        }
        for (int i = 0; i < aSig.length; ++i) {
            rc = aSig[i].compareTo(bSig[i]);
            if (rc == 0) continue;
            return rc;
        }
        return rc;
    };
    private static final StringBuilder ROW_BUFFER = new StringBuilder();

    private static Map<String, Info> load(JMXServiceURL url) throws IOException, MalformedObjectNameException, IntrospectionException, InstanceNotFoundException, ReflectionException {
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, null);){
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            TreeMap<String, Info> map = new TreeMap<String, Info>();
            for (String pkg : new TreeSet<String>(METRIC_PACKAGES)) {
                TreeSet<ObjectName> metricNames = new TreeSet<ObjectName>(mbsc.queryNames(new ObjectName(pkg + ":*"), null));
                for (ObjectName name : metricNames) {
                    if (!mbsc.isRegistered(name)) continue;
                    MBeanInfo info = mbsc.getMBeanInfo(name);
                    map.put(name.toString(), Info.from(info));
                }
            }
            TreeMap<String, Info> treeMap = map;
            return treeMap;
        }
    }

    private static String getAccess(MBeanAttributeInfo a) {
        String access = a.isReadable() ? (a.isWritable() ? "read/write" : "read-only") : (a.isWritable() ? "write-only" : "no-access");
        return access;
    }

    private static String normalizeType(String type) {
        switch (type) {
            case "[Z": {
                return "boolean[]";
            }
            case "[B": {
                return "byte[]";
            }
            case "[S": {
                return "short[]";
            }
            case "[I": {
                return "int[]";
            }
            case "[J": {
                return "long[]";
            }
            case "[F": {
                return "float[]";
            }
            case "[D": {
                return "double[]";
            }
            case "[C": {
                return "char[]";
            }
        }
        if (type.startsWith("[L")) {
            return type.substring(2, type.length() - 1) + "[]";
        }
        return type;
    }

    private static void printRow(PrintStream out, String ... args) {
        ROW_BUFFER.setLength(0);
        ROW_BUFFER.append("\t\t");
        for (String a : args) {
            ROW_BUFFER.append(a).append("\t");
        }
        out.println(ROW_BUFFER);
    }

    public static void main(String[] args) throws Exception {
        Cli.CliBuilder builder = Cli.builder((String)"jmxtool");
        builder.withDefaultCommand(Help.class);
        builder.withCommands(Help.class, new Class[]{Dump.class, Diff.class});
        Cli parser = builder.build();
        Callable command = (Callable)parser.parse(args);
        command.call();
    }

    public static final class CliPattern {
        private final Pattern pattern;

        public CliPattern(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }
    }

    public static final class Parameter {
        private String name;
        private String type;

        public Parameter() {
        }

        public Parameter(String name, String type) {
            this.name = name;
            this.type = type;
        }

        private static Parameter from(MBeanParameterInfo info) {
            return new Parameter(info.getName(), JMXTool.normalizeType(info.getType()));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.type, parameter.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public String toString() {
            return this.name + ": " + this.type;
        }
    }

    public static final class Operation
    implements Comparable<Operation> {
        private String name;
        private Parameter[] parameters;
        private String returnType;

        public Operation() {
        }

        public Operation(String name, Parameter[] parameters, String returnType) {
            this.name = name;
            this.parameters = parameters;
            this.returnType = returnType;
        }

        private static Operation from(MBeanOperationInfo info) {
            Parameter[] params = (Parameter[])Stream.of(info.getSignature()).map(x$0 -> Parameter.from(x$0)).toArray(Parameter[]::new);
            return new Operation(info.getName(), params, JMXTool.normalizeType(info.getReturnType()));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Parameter[] getParameters() {
            return this.parameters;
        }

        public void setParameters(Parameter[] parameters) {
            this.parameters = parameters;
        }

        public List<String> parameterTypes() {
            return Stream.of(this.parameters).map(p -> p.type).collect(Collectors.toList());
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Operation operation = (Operation)o;
            return Objects.equals(this.name, operation.name) && Arrays.equals(this.parameters, operation.parameters) && Objects.equals(this.returnType, operation.returnType);
        }

        public int hashCode() {
            int result = Objects.hash(this.name, this.returnType);
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }

        public String toString() {
            return this.name + Stream.of(this.parameters).map(Parameter::toString).collect(Collectors.joining(", ", "(", ")")) + ": " + this.returnType;
        }

        @Override
        public int compareTo(Operation o) {
            int rc = this.name.compareTo(o.name);
            if (rc != 0) {
                return rc;
            }
            rc = Integer.compare(this.parameters.length, o.parameters.length);
            if (rc != 0) {
                return rc;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                rc = this.parameters[i].type.compareTo(o.parameters[i].type);
                if (rc == 0) continue;
                return rc;
            }
            return this.returnType.compareTo(o.returnType);
        }
    }

    public static final class Attribute
    implements Comparable<Attribute> {
        private String name;
        private String type;
        private String access;

        public Attribute() {
        }

        public Attribute(String name, String type, String access) {
            this.name = name;
            this.type = type;
            this.access = access;
        }

        private static Attribute from(MBeanAttributeInfo info) {
            return new Attribute(info.getName(), JMXTool.normalizeType(info.getType()), JMXTool.getAccess(info));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAccess() {
            return this.access;
        }

        public void setAccess(String access) {
            this.access = access;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return Objects.equals(this.name, attribute.name) && Objects.equals(this.type, attribute.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return this.name + ": " + this.type;
        }

        @Override
        public int compareTo(Attribute o) {
            int rc = this.name.compareTo(o.name);
            if (rc != 0) {
                return rc;
            }
            return this.type.compareTo(o.type);
        }
    }

    public static final class Info {
        private Attribute[] attributes;
        private Operation[] operations;

        public Info() {
        }

        public Info(Attribute[] attributes, Operation[] operations) {
            this.attributes = attributes;
            this.operations = operations;
        }

        private static Info from(MBeanInfo info) {
            Attribute[] attributes = (Attribute[])Stream.of(info.getAttributes()).sorted(Comparator.comparing(MBeanFeatureInfo::getName)).map(x$0 -> Attribute.from(x$0)).toArray(Attribute[]::new);
            Operation[] operations = (Operation[])Stream.of(info.getOperations()).sorted(OPERATOR_COMPARATOR).map(x$0 -> Operation.from(x$0)).toArray(Operation[]::new);
            return new Info(attributes, operations);
        }

        public Attribute[] getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Attribute[] attributes) {
            this.attributes = attributes;
        }

        public Set<String> attributeNames() {
            return Stream.of(this.attributes).map(a -> a.name).collect(Collectors.toSet());
        }

        public Set<Attribute> attributeSet() {
            return new HashSet<Attribute>(Arrays.asList(this.attributes));
        }

        public Operation[] getOperations() {
            return this.operations;
        }

        public void setOperations(Operation[] operations) {
            this.operations = operations;
        }

        public Set<String> operationNames() {
            return Stream.of(this.operations).map(o -> o.name).collect(Collectors.toSet());
        }

        public Set<Operation> operationSet() {
            return new HashSet<Operation>(Arrays.asList(this.operations));
        }

        public Optional<Attribute> getAttribute(String name) {
            return Stream.of(this.attributes).filter(a -> a.name.equals(name)).findFirst();
        }

        public Attribute getAttributePresent(String name) {
            return this.getAttribute(name).orElseThrow(AssertionError::new);
        }

        public Optional<Operation> getOperation(String name) {
            return Stream.of(this.operations).filter(o -> o.name.equals(name)).findFirst();
        }

        public Operation getOperationPresent(String name) {
            return this.getOperation(name).orElseThrow(AssertionError::new);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Arrays.equals(this.attributes, info.attributes) && Arrays.equals(this.operations, info.operations);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.attributes);
            result = 31 * result + Arrays.hashCode(this.operations);
            return result;
        }
    }

    @Command(name="diff", description="Diff two jmx dump files and report their differences")
    public static final class Diff
    implements Callable<Void> {
        @Inject
        private HelpOption helpOption;
        @Arguments(title="files", usage="<left> <right>", description="Files to diff")
        private List<File> files;
        @Option(title="format", name={"-f", "--format"}, description="What format the files are in; only support json and yaml as format")
        private Format format = Format.yaml;
        @Option(title="ignore left", name={"--ignore-missing-on-left"}, description="Ignore results missing on the left")
        private boolean ignoreMissingLeft;
        @Option(title="ignore right", name={"--ignore-missing-on-right"}, description="Ignore results missing on the right")
        private boolean ignoreMissingRight;
        @Option(title="exclude objects", name={"--exclude-object"}, description="Ignores processing specific objects. Each usage should take a single object, but can use this flag multiple times.")
        private List<CliPattern> excludeObjects = new ArrayList<CliPattern>();
        @Option(title="exclude attributes", name={"--exclude-attribute"}, description="Ignores processing specific attributes. Each usage should take a single attribute, but can use this flag multiple times.")
        private List<CliPattern> excludeAttributes = new ArrayList<CliPattern>();
        @Option(title="exclude operations", name={"--exclude-operation"}, description="Ignores processing specific operations. Each usage should take a single operation, but can use this flag multiple times.")
        private List<CliPattern> excludeOperations = new ArrayList<CliPattern>();

        @Override
        public Void call() throws Exception {
            Map<String, Info> right;
            Map<String, Info> left;
            Preconditions.checkArgument((this.files.size() == 2 ? 1 : 0) != 0, (String)"files requires 2 arguments but given %s", this.files);
            try (FileInputStreamPlus leftStream = new FileInputStreamPlus(this.files.get(0));
                 FileInputStreamPlus rightStream = new FileInputStreamPlus(this.files.get(1));){
                left = this.format.load(leftStream);
                right = this.format.load(rightStream);
            }
            this.diff(left, right);
            return null;
        }

        private void diff(Map<String, Info> left, Map<String, Info> right) {
            DiffResult<String> objectNames = Diff.diff(left.keySet(), right.keySet(), name -> {
                for (CliPattern p : this.excludeObjects) {
                    if (!p.pattern.matcher((CharSequence)name).matches()) continue;
                    return false;
                }
                return true;
            });
            if (!this.ignoreMissingRight && !objectNames.notInRight.isEmpty()) {
                System.out.println("Objects not in right:");
                Diff.printSet(0, objectNames.notInRight);
            }
            if (!this.ignoreMissingLeft && !objectNames.notInLeft.isEmpty()) {
                System.out.println("Objects not in left: ");
                Diff.printSet(0, objectNames.notInLeft);
            }
            Runnable printHeader = new Runnable(){
                boolean printedHeader = false;

                @Override
                public void run() {
                    if (!this.printedHeader) {
                        System.out.println("Difference found in attribute or operation");
                        this.printedHeader = true;
                    }
                }
            };
            for (String key : objectNames.shared) {
                Info leftInfo = left.get(key);
                Info rightInfo = right.get(key);
                DiffResult<Attribute> attributes = Diff.diff(leftInfo.attributeSet(), rightInfo.attributeSet(), attribute -> {
                    for (CliPattern p : this.excludeAttributes) {
                        if (!p.pattern.matcher(attribute.name).matches()) continue;
                        return false;
                    }
                    return true;
                });
                if (!this.ignoreMissingRight && !attributes.notInRight.isEmpty()) {
                    printHeader.run();
                    System.out.println(key + "\tattribute not in right:");
                    Diff.printSet(1, attributes.notInRight);
                }
                if (!this.ignoreMissingLeft && !attributes.notInLeft.isEmpty()) {
                    printHeader.run();
                    System.out.println(key + "\tattribute not in left:");
                    Diff.printSet(1, attributes.notInLeft);
                }
                DiffResult<Operation> operations = Diff.diff(leftInfo.operationSet(), rightInfo.operationSet(), operation -> {
                    for (CliPattern p : this.excludeOperations) {
                        if (!p.pattern.matcher(operation.name).matches() && !p.pattern.matcher(operation.toString().replaceAll(" +", "")).matches()) continue;
                        return false;
                    }
                    return true;
                });
                if (!this.ignoreMissingRight && !operations.notInRight.isEmpty()) {
                    printHeader.run();
                    System.out.println(key + "\toperation not in right:");
                    Diff.printSet(1, operations.notInRight, (sb, o) -> rightInfo.getOperation(o.name).ifPresent(match -> sb.append("\t").append("similar in right: ").append(match)));
                }
                if (this.ignoreMissingLeft || operations.notInLeft.isEmpty()) continue;
                printHeader.run();
                System.out.println(key + "\toperation not in left:");
                Diff.printSet(1, operations.notInLeft, (sb, o) -> leftInfo.getOperation(o.name).ifPresent(match -> sb.append("\t").append("similar in left: ").append(match)));
            }
        }

        private static <T extends Comparable<T>> void printSet(int indent, Set<T> set) {
            Diff.printSet(indent, set, (i1, i2) -> {});
        }

        private static <T extends Comparable<T>> void printSet(int indent, Set<T> set, BiConsumer<StringBuilder, T> fn) {
            StringBuilder sb = new StringBuilder();
            for (Comparable t : new TreeSet<T>(set)) {
                sb.setLength(0);
                for (int i = 0; i < indent; ++i) {
                    sb.append('\t');
                }
                sb.append(t);
                fn.accept(sb, (StringBuilder)t);
                System.out.println(sb);
            }
        }

        private static <T> DiffResult<T> diff(Set<T> left, Set<T> right, Predicate<T> fn) {
            left = Sets.filter(left, fn);
            right = Sets.filter(right, fn);
            return new DiffResult(Sets.difference((Set)left, (Set)right), Sets.difference((Set)right, (Set)left), Sets.intersection((Set)left, (Set)right));
        }

        private static final class CustomConstructor
        extends Constructor {
            private static final String ROOT = "__root__";
            private static final TypeDescription INFO_TYPE = new TypeDescription(Info.class);

            public CustomConstructor() {
                this.rootTag = new Tag(ROOT);
                this.addTypeDescription(INFO_TYPE);
            }

            protected Object constructObject(Node node) {
                if (ROOT.equals(node.getTag().getValue()) && node instanceof MappingNode) {
                    MappingNode mn = (MappingNode)node;
                    return mn.getValue().stream().collect(Collectors.toMap(t -> super.constructObject(t.getKeyNode()), t -> {
                        Node child = t.getValueNode();
                        child.setType(INFO_TYPE.getType());
                        return super.constructObject(child);
                    }));
                }
                return super.constructObject(node);
            }
        }

        public static enum Format {
            json{

                @Override
                Map<String, Info> load(InputStream input) throws IOException {
                    return (Map)JsonUtils.JSON_OBJECT_MAPPER.readValue(input, (TypeReference)new TypeReference<Map<String, Info>>(){});
                }
            }
            ,
            yaml{

                @Override
                Map<String, Info> load(InputStream input) throws IOException {
                    Yaml yaml = new Yaml((BaseConstructor)new CustomConstructor());
                    return (Map)yaml.load(input);
                }
            };


            abstract Map<String, Info> load(InputStream var1) throws IOException;
        }

        private static final class DiffResult<T> {
            private final Sets.SetView<T> notInRight;
            private final Sets.SetView<T> notInLeft;
            private final Sets.SetView<T> shared;

            private DiffResult(Sets.SetView<T> notInRight, Sets.SetView<T> notInLeft, Sets.SetView<T> shared) {
                this.notInRight = notInRight;
                this.notInLeft = notInLeft;
                this.shared = shared;
            }
        }
    }

    @Command(name="dump", description="Dump the Apache Cassandra JMX objects and metadata.")
    public static final class Dump
    implements Callable<Void> {
        @Inject
        private HelpOption helpOption;
        @Option(title="url", name={"-u", "--url"}, description="JMX url to target")
        private String targetUrl = "service:jmx:rmi:///jndi/rmi://localhost:7199/jmxrmi";
        @Option(title="format", name={"-f", "--format"}, description="What format to dump content as; supported values are console (default), json, and yaml")
        private Format format = Format.console;

        @Override
        public Void call() throws Exception {
            Map<String, Info> map = JMXTool.load(new JMXServiceURL(this.targetUrl));
            this.format.dump(System.out, map);
            return null;
        }

        public static enum Format {
            console{

                @Override
                void dump(OutputStream output, Map<String, Info> map) {
                    PrintStream out = Format.toPrintStream(output);
                    for (Map.Entry<String, Info> e : map.entrySet()) {
                        String name = e.getKey();
                        Info info = e.getValue();
                        out.println(name);
                        out.println("\tAttributes");
                        Stream.of(info.attributes).forEach(a -> JMXTool.printRow(out, a.name, a.type, a.access));
                        out.println("\tOperations");
                        Stream.of(info.operations).forEach(o -> {
                            String args = Stream.of(o.parameters).map(i -> i.name + ": " + i.type).collect(Collectors.joining(",", "(", ")"));
                            JMXTool.printRow(out, o.name, o.returnType, args);
                        });
                    }
                }
            }
            ,
            json{

                @Override
                void dump(OutputStream output, Map<String, Info> map) throws IOException {
                    JsonUtils.JSON_OBJECT_PRETTY_WRITER.writeValue(output, map);
                }
            }
            ,
            yaml{

                @Override
                void dump(OutputStream output, Map<String, Info> map) throws IOException {
                    Representer representer = new Representer();
                    representer.addClassTag(Info.class, Tag.MAP);
                    Yaml yaml = new Yaml(representer);
                    yaml.dump(map, (Writer)new OutputStreamWriter(output));
                }
            };


            private static PrintStream toPrintStream(OutputStream output) {
                try {
                    return output instanceof PrintStream ? (PrintStream)output : new PrintStream(output, true, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
            }

            abstract void dump(OutputStream var1, Map<String, Info> var2) throws IOException;
        }
    }
}

