/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.SSTableContextManager;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.StorageAttachedIndexWriter;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.metrics.IndexGroupMetrics;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.metrics.TableStateMetrics;
import org.apache.cassandra.index.sai.plan.StorageAttachedIndexQueryPlan;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.MemtableDiscardedNotification;
import org.apache.cassandra.notifications.MemtableRenewedNotification;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StorageAttachedIndexGroup
implements Index.Group,
INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(StorageAttachedIndexGroup.class);
    public static final Index.Group.Key GROUP_KEY = new Index.Group.Key(StorageAttachedIndexGroup.class);
    private final TableQueryMetrics queryMetrics;
    private final TableStateMetrics stateMetrics;
    private final IndexGroupMetrics groupMetrics;
    private final Set<StorageAttachedIndex> indexes = ConcurrentHashMap.newKeySet();
    private final ColumnFamilyStore baseCfs;
    private final SSTableContextManager contextManager;

    StorageAttachedIndexGroup(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.queryMetrics = new TableQueryMetrics(baseCfs.metadata());
        this.stateMetrics = new TableStateMetrics(baseCfs.metadata(), this);
        this.groupMetrics = new IndexGroupMetrics(baseCfs.metadata(), this);
        this.contextManager = new SSTableContextManager();
        Tracker tracker = baseCfs.getTracker();
        tracker.subscribe(this);
    }

    @Nullable
    public static StorageAttachedIndexGroup getIndexGroup(ColumnFamilyStore cfs) {
        return (StorageAttachedIndexGroup)cfs.indexManager.getIndexGroup(GROUP_KEY);
    }

    @Override
    public Set<Index> getIndexes() {
        return ImmutableSet.copyOf(this.indexes);
    }

    @Override
    public void addIndex(Index index) {
        assert (index instanceof StorageAttachedIndex);
        this.indexes.add((StorageAttachedIndex)index);
    }

    @Override
    public void removeIndex(Index index) {
        assert (index instanceof StorageAttachedIndex);
        boolean removed = this.indexes.remove(index);
        assert (removed) : "Cannot remove non-existing index " + index;
        if (this.indexes.isEmpty()) {
            for (SSTableReader sstable : this.contextManager.sstables()) {
                sstable.unregisterComponents(IndexDescriptor.create(sstable).getLivePerSSTableComponents(), this.baseCfs.getTracker());
            }
            this.deletePerSSTableFiles(this.baseCfs.getLiveSSTables());
        }
    }

    @Override
    public void invalidate() {
        this.queryMetrics.release();
        this.groupMetrics.release();
        this.stateMetrics.release();
        this.baseCfs.getTracker().unsubscribe(this);
    }

    @Override
    public boolean containsIndex(Index index) {
        return this.indexes.contains(index);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Index.Indexer indexerFor(Predicate<Index> indexSelector, DecoratedKey key, RegularAndStaticColumns columns, long nowInSec, WriteContext ctx, IndexTransaction.Type transactionType, Memtable memtable) {
        final Set indexers = this.indexes.stream().filter(indexSelector).map(i -> i.indexerFor(key, columns, nowInSec, ctx, transactionType, memtable)).filter(Objects::nonNull).collect(Collectors.toSet());
        return indexers.isEmpty() ? null : new Index.Indexer(){

            @Override
            public void insertRow(Row row) {
                if (row.deletion().isLive()) {
                    for (Index.Indexer indexer : indexers) {
                        indexer.insertRow(row);
                    }
                }
            }

            @Override
            public void updateRow(Row oldRow, Row newRow) {
                for (Index.Indexer indexer : indexers) {
                    indexer.updateRow(oldRow, newRow);
                }
            }
        };
    }

    @Override
    public StorageAttachedIndexQueryPlan queryPlanFor(RowFilter rowFilter) {
        return StorageAttachedIndexQueryPlan.create(this.baseCfs, this.queryMetrics, this.indexes, rowFilter);
    }

    @Override
    public SSTableFlushObserver getFlushObserver(Descriptor descriptor, LifecycleNewTracker tracker, TableMetadata tableMetadata) {
        IndexDescriptor indexDescriptor = IndexDescriptor.create(descriptor, tableMetadata.partitioner, tableMetadata.comparator);
        try {
            return StorageAttachedIndexWriter.createFlushObserverWriter(indexDescriptor, this.indexes, tracker);
        }
        catch (Throwable t) {
            String message = "Unable to create storage-attached index writer on SSTable flush. All indexes from this table are going to be marked as non-queryable and will need to be rebuilt.";
            logger.error(indexDescriptor.logMessage(message), t);
            this.indexes.forEach(StorageAttachedIndex::makeIndexNonQueryable);
            return null;
        }
    }

    @Override
    public boolean handles(IndexTransaction.Type type) {
        return type == IndexTransaction.Type.UPDATE;
    }

    @Override
    public Set<Component> getComponents() {
        return this.getComponents(this.indexes);
    }

    private Set<Component> getComponents(Collection<StorageAttachedIndex> indices) {
        Set<Component> components = Version.LATEST.onDiskFormat().perSSTableIndexComponents(this.baseCfs.metadata.get().comparator.size() > 0).stream().map(Version.LATEST::makePerSSTableComponent).collect(Collectors.toSet());
        indices.forEach(index -> components.addAll(index.getComponents()));
        return components;
    }

    @VisibleForTesting
    public static Set<Component> getLiveComponents(SSTableReader sstable, Collection<StorageAttachedIndex> indices) {
        IndexDescriptor indexDescriptor = IndexDescriptor.create(sstable);
        Set<Component> components = indexDescriptor.getLivePerSSTableComponents();
        indices.forEach(index -> components.addAll(indexDescriptor.getLivePerIndexComponents(index.termType(), index.identifier())));
        return components;
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification notice = (SSTableAddedNotification)notification;
            this.onSSTableChanged(Collections.emptySet(), notice.added, this.indexes, IndexValidation.NONE);
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification notice = (SSTableListChangedNotification)notification;
            this.onSSTableChanged(notice.removed, notice.added, this.indexes, IndexValidation.NONE);
        } else if (notification instanceof MemtableRenewedNotification) {
            this.indexes.forEach(index -> index.memtableIndexManager().renewMemtable(((MemtableRenewedNotification)notification).renewed));
        } else if (notification instanceof MemtableDiscardedNotification) {
            this.indexes.forEach(index -> index.memtableIndexManager().discardMemtable(((MemtableDiscardedNotification)notification).memtable));
        }
    }

    void deletePerSSTableFiles(Collection<SSTableReader> sstables) {
        this.contextManager.release(sstables);
        sstables.forEach(sstableReader -> IndexDescriptor.create(sstableReader).deletePerSSTableIndexComponents());
    }

    void dropIndexSSTables(Collection<SSTableReader> ss, StorageAttachedIndex index) {
        try {
            index.drop(ss);
        }
        catch (Throwable t) {
            index.makeIndexNonQueryable();
            throw Throwables.unchecked(t);
        }
    }

    synchronized Set<StorageAttachedIndex> onSSTableChanged(Collection<SSTableReader> removed, Iterable<SSTableReader> added, Set<StorageAttachedIndex> indexes, IndexValidation validation) {
        Pair<Set<SSTableContext>, Set<SSTableReader>> results = this.contextManager.update(removed, added, validation);
        if (!((Set)results.right).isEmpty()) {
            ((Set)results.right).forEach(sstable -> {
                IndexDescriptor indexDescriptor = IndexDescriptor.create(sstable);
                indexDescriptor.deletePerSSTableIndexComponents();
                indexes.forEach(index -> {
                    indexDescriptor.deleteColumnIndex(index.termType(), index.identifier());
                    index.makeIndexNonQueryable();
                });
            });
            return indexes;
        }
        HashSet<StorageAttachedIndex> incomplete = new HashSet<StorageAttachedIndex>();
        for (StorageAttachedIndex index : indexes) {
            Collection<SSTableContext> invalid = index.onSSTableChanged(removed, (Collection)results.left, validation);
            if (invalid.isEmpty()) continue;
            invalid.forEach(context -> context.indexDescriptor.deleteColumnIndex(index.termType(), index.identifier()));
            index.makeIndexNonQueryable();
            incomplete.add(index);
        }
        return incomplete;
    }

    @Override
    public boolean validateSSTableAttachedIndexes(Collection<SSTableReader> sstables, boolean throwOnIncomplete, boolean validateChecksum) {
        boolean complete = true;
        for (SSTableReader sstable : sstables) {
            IndexDescriptor indexDescriptor = IndexDescriptor.create(sstable);
            if (indexDescriptor.isPerSSTableIndexBuildComplete()) {
                indexDescriptor.validatePerSSTableComponents(IndexValidation.CHECKSUM, validateChecksum, true);
                for (StorageAttachedIndex index : this.indexes) {
                    if (indexDescriptor.isPerColumnIndexBuildComplete(index.identifier())) {
                        indexDescriptor.validatePerIndexComponents(index.termType(), index.identifier(), IndexValidation.CHECKSUM, validateChecksum, true);
                        continue;
                    }
                    if (throwOnIncomplete) {
                        throw new IllegalStateException(indexDescriptor.logMessage("Incomplete per-column index build for SSTable " + sstable.descriptor.toString()));
                    }
                    complete = false;
                }
                continue;
            }
            if (throwOnIncomplete) {
                throw new IllegalStateException(indexDescriptor.logMessage("Incomplete per-SSTable index build" + sstable.descriptor.toString()));
            }
            complete = false;
        }
        return complete;
    }

    public int openIndexFiles() {
        return this.contextManager.openFiles() + this.indexes.stream().mapToInt(StorageAttachedIndex::openPerColumnIndexFiles).sum();
    }

    public long diskUsage() {
        return this.contextManager.diskUsage();
    }

    public int totalIndexBuildsInProgress() {
        return (int)this.indexes.stream().filter(i -> this.baseCfs.indexManager.isIndexBuilding(i.getIndexMetadata().name)).count();
    }

    public int totalQueryableIndexCount() {
        return Ints.checkedCast((long)this.indexes.stream().filter(this.baseCfs.indexManager::isIndexQueryable).count());
    }

    public int totalIndexCount() {
        return this.indexes.size();
    }

    public long totalDiskUsage() {
        return this.diskUsage() + this.indexes.stream().flatMap(index -> index.view().getIndexes().stream()).mapToLong(SSTableIndex::sizeOfPerColumnComponents).sum();
    }

    public TableMetadata metadata() {
        return this.baseCfs.metadata();
    }

    public ColumnFamilyStore table() {
        return this.baseCfs;
    }

    @VisibleForTesting
    public SSTableContextManager sstableContextManager() {
        return this.contextManager;
    }

    @VisibleForTesting
    public void unsafeReload() {
        this.contextManager.clear();
        this.onSSTableChanged(this.baseCfs.getLiveSSTables(), Collections.emptySet(), this.indexes, IndexValidation.NONE);
        this.onSSTableChanged(Collections.emptySet(), this.baseCfs.getLiveSSTables(), this.indexes, IndexValidation.HEADER_FOOTER);
    }

    @VisibleForTesting
    public void reset() {
        this.contextManager.clear();
        this.indexes.forEach(StorageAttachedIndex::makeIndexNonQueryable);
        this.onSSTableChanged(this.baseCfs.getLiveSSTables(), Collections.emptySet(), this.indexes, IndexValidation.NONE);
    }
}

