/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.IndexEntry;
import org.apache.cassandra.schema.IndexMetadata;

public class RegularColumnIndex
extends CassandraIndex {
    public RegularColumnIndex(ColumnFamilyStore baseCfs, IndexMetadata indexDef) {
        super(baseCfs, indexDef);
    }

    @Override
    public ByteBuffer getIndexedValue(ByteBuffer partitionKey, Clustering<?> clustering, CellPath path, ByteBuffer cellValue) {
        return cellValue;
    }

    @Override
    public <T> CBuilder buildIndexClusteringPrefix(ByteBuffer partitionKey, ClusteringPrefix<T> prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(partitionKey);
        for (int i = 0; i < prefix.size(); ++i) {
            builder.add(prefix.get(i), prefix.accessor());
        }
        return builder;
    }

    @Override
    public IndexEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        ClusteringPrefix clustering = indexEntry.clustering();
        Clustering<ByteBuffer> indexedEntryClustering = null;
        if (this.getIndexedColumn().isStatic()) {
            indexedEntryClustering = Clustering.STATIC_CLUSTERING;
        } else {
            ClusteringComparator baseComparator = this.baseCfs.getComparator();
            CBuilder builder = CBuilder.create(baseComparator);
            for (int i = 0; i < baseComparator.size(); ++i) {
                builder.add(clustering, i + 1);
            }
            indexedEntryClustering = builder.build();
        }
        return new IndexEntry(indexedValue, (Clustering<?>)clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.bufferAt(0), indexedEntryClustering);
    }

    private static <V> boolean valueIsEqual(AbstractType<?> type, Cell<V> cell, ByteBuffer value) {
        return type.compare(cell.value(), cell.accessor(), value, ByteBufferAccessor.instance) == 0;
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, long nowInSec) {
        Cell<?> cell = data.getCell(this.indexedColumn);
        return cell == null || !cell.isLive(nowInSec) || !RegularColumnIndex.valueIsEqual(this.indexedColumn.type, cell, indexValue);
    }
}

