/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.ClearableHistogram;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.messages.RepairMessage;

public class RepairMetrics {
    public static final String TYPE_NAME = "Repair";
    public static final Counter previewFailures = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("Repair", "PreviewFailures", null));
    public static final Histogram retries = CassandraMetricsRegistry.Metrics.histogram(DefaultNameFactory.createMetricName("Repair", "Retries", null), false);
    public static final Map<Verb, Histogram> retriesByVerb;
    public static final Counter retryTimeout;
    public static final Map<Verb, Counter> retryTimeoutByVerb;
    public static final Counter retryFailure;
    public static final Map<Verb, Counter> retryFailureByVerb;

    public static void init() {
    }

    @VisibleForTesting
    public static void unsafeReset() {
        RepairMetrics.reset(previewFailures);
        RepairMetrics.reset(retries);
        retriesByVerb.values().forEach(RepairMetrics::reset);
        RepairMetrics.reset(retryTimeout);
        retryTimeoutByVerb.values().forEach(RepairMetrics::reset);
        RepairMetrics.reset(retryFailure);
        retryFailureByVerb.values().forEach(RepairMetrics::reset);
    }

    private static void reset(Histogram retries) {
        ((ClearableHistogram)retries).clear();
    }

    private static void reset(Counter counter) {
        counter.dec(counter.getCount());
    }

    public static void retry(Verb verb, int attempt) {
        retries.update(attempt);
        retriesByVerb.get((Object)verb).update(attempt);
    }

    public static void retryTimeout(Verb verb) {
        retryTimeout.inc();
        retryTimeoutByVerb.get((Object)verb).inc();
    }

    public static void retryFailure(Verb verb) {
        retryFailure.inc();
        retryFailureByVerb.get((Object)verb).inc();
    }

    static {
        retryTimeout = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName(TYPE_NAME, "RetryTimeout", null));
        retryFailure = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName(TYPE_NAME, "RetryFailure", null));
        EnumMap<Verb, Histogram> retries = new EnumMap<Verb, Histogram>(Verb.class);
        EnumMap<Verb, Counter> timeout = new EnumMap<Verb, Counter>(Verb.class);
        EnumMap<Verb, Counter> failure = new EnumMap<Verb, Counter>(Verb.class);
        for (Verb verb : RepairMessage.ALLOWS_RETRY) {
            retries.put(verb, CassandraMetricsRegistry.Metrics.histogram(DefaultNameFactory.createMetricName(TYPE_NAME, "Retries-" + verb.name(), null), false));
            timeout.put(verb, CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName(TYPE_NAME, "RetryTimeout-" + verb.name(), null)));
            failure.put(verb, CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName(TYPE_NAME, "RetryFailure-" + verb.name(), null)));
        }
        retriesByVerb = Collections.unmodifiableMap(retries);
        retryTimeoutByVerb = Collections.unmodifiableMap(timeout);
        retryFailureByVerb = Collections.unmodifiableMap(failure);
    }
}

