/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.AbstractGuavaIterator;

@NotThreadSafe
public abstract class KeyRangeIterator
extends AbstractGuavaIterator<PrimaryKey>
implements Closeable {
    private final PrimaryKey min;
    private final PrimaryKey max;
    private final long count;
    private Runnable onClose;

    protected KeyRangeIterator(Builder.Statistics statistics, Runnable onClose) {
        this(statistics.min, statistics.max, statistics.count, onClose);
    }

    public KeyRangeIterator(KeyRangeIterator range, Runnable onClose) {
        this(range == null ? null : range.min, range == null ? null : range.max, range == null ? -1L : range.count, onClose);
    }

    public KeyRangeIterator(PrimaryKey min, PrimaryKey max, long count) {
        this(min, max, count, () -> {});
    }

    public KeyRangeIterator(PrimaryKey min, PrimaryKey max, long count, Runnable onClose) {
        boolean isComplete = min != null && max != null && count != 0L;
        boolean isEmpty = min == null && max == null && (count == 0L || count == -1L);
        Preconditions.checkArgument((isComplete || isEmpty ? 1 : 0) != 0, (String)"Range: [%s,%s], Count: %d", (Object)min, (Object)max, (Object)count);
        if (isEmpty) {
            this.endOfData();
        }
        this.min = min;
        this.max = max;
        this.count = count;
        this.onClose = onClose;
    }

    public final PrimaryKey getMinimum() {
        return this.min;
    }

    public final PrimaryKey getMaximum() {
        return this.max;
    }

    public final long getMaxKeys() {
        return this.count;
    }

    public final void skipTo(PrimaryKey nextKey) {
        if (this.state == AbstractGuavaIterator.State.DONE) {
            return;
        }
        if (this.state == AbstractGuavaIterator.State.READY && ((PrimaryKey)this.next).compareTo(nextKey) >= 0) {
            return;
        }
        if (this.max.compareTo(nextKey) < 0) {
            this.endOfData();
            return;
        }
        this.performSkipTo(nextKey);
        this.state = AbstractGuavaIterator.State.NOT_READY;
    }

    protected abstract void performSkipTo(PrimaryKey var1);

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    @Override
    public void close() {
        this.onClose.run();
    }

    public static KeyRangeIterator empty() {
        return EmptyRangeIterator.instance;
    }

    protected static PrimaryKey nullSafeMin(PrimaryKey a, PrimaryKey b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareToStrict(b) > 0 ? b : a;
    }

    protected static PrimaryKey nullSafeMax(PrimaryKey a, PrimaryKey b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareToStrict(b) > 0 ? a : b;
    }

    @VisibleForTesting
    public static abstract class Builder {
        protected final Statistics statistics;
        protected final Runnable onClose;

        public Builder(Statistics statistics, Runnable onClose) {
            this.statistics = statistics;
            this.onClose = onClose;
        }

        public PrimaryKey getMinimum() {
            return this.statistics.min;
        }

        public PrimaryKey getMaximum() {
            return this.statistics.max;
        }

        public long getCount() {
            return this.statistics.count;
        }

        public Builder add(Iterable<KeyRangeIterator> ranges) {
            if (ranges == null || Iterables.isEmpty(ranges)) {
                return this;
            }
            ranges.forEach(this::add);
            return this;
        }

        public final KeyRangeIterator build() {
            if (this.rangeCount() == 0) {
                this.onClose.run();
                return KeyRangeIterator.empty();
            }
            return this.buildIterator();
        }

        public abstract Builder add(KeyRangeIterator var1);

        public abstract int rangeCount();

        public void cleanup() {
            this.onClose.run();
        }

        protected abstract KeyRangeIterator buildIterator();

        public static abstract class Statistics {
            protected PrimaryKey min;
            protected PrimaryKey max;
            protected long count;

            public abstract void update(KeyRangeIterator var1);
        }
    }

    private static class EmptyRangeIterator
    extends KeyRangeIterator {
        static final KeyRangeIterator instance = new EmptyRangeIterator();

        EmptyRangeIterator() {
            super(null, null, 0L, () -> {});
        }

        @Override
        public PrimaryKey computeNext() {
            return (PrimaryKey)this.endOfData();
        }

        @Override
        protected void performSkipTo(PrimaryKey nextKey) {
        }

        @Override
        public void close() {
        }
    }
}

