/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.ShardManager;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;

public interface ShardTracker {
    public Token shardStart();

    @Nullable
    public Token shardEnd();

    public Range<Token> shardSpan();

    public double shardSpanSize();

    public boolean advanceTo(Token var1);

    public int count();

    public double fractionInShard(Range<Token> var1);

    public double rangeSpanned(PartitionPosition var1, PartitionPosition var2);

    public int shardIndex();

    default public long shardAdjustedKeyCount(Set<SSTableReader> sstables) {
        long shardAdjustedKeyCount = 0L;
        for (SSTableReader sstable : sstables) {
            shardAdjustedKeyCount = (long)((double)shardAdjustedKeyCount + (double)sstable.estimatedKeys() * this.fractionInShard(ShardManager.coveringRange(sstable)));
        }
        return shardAdjustedKeyCount;
    }

    default public void applyTokenSpaceCoverage(SSTableWriter writer) {
        if (writer.getFirst() != null) {
            writer.setTokenSpaceCoverage(this.rangeSpanned(writer.getFirst(), writer.getLast()));
        }
    }
}

